/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import simtools.ui.DesktopCardPanel;
import simtools.ui.DesktopCardPanelMode;

public class ExternalMode
implements DesktopCardPanelMode {
    private List _frames = new ArrayList();
    private ExternalFrameListener _externalFramesListener = new ExternalFrameListener();
    protected DesktopCardPanel _desktopCardPanel;
    private static final int OFF_SET = 40;
    private int _frameX;
    private int _frameY;
    private int _frameWidth;
    private int _frameHeight;

    public ExternalMode(DesktopCardPanel desktopCardPanel) {
        this._desktopCardPanel = desktopCardPanel;
    }

    public void addComponent(JComponent jComponent) {
        ExternalFrame externalFrame = new ExternalFrame(jComponent, this._desktopCardPanel.is_scrollable(), this._desktopCardPanel.is_closable());
        if (this._externalFramesListener != null) {
            externalFrame.addWindowListener(this._externalFramesListener);
        }
        this._frames.add(externalFrame);
        this.computeNextFramePosition();
        externalFrame.setBounds(this._frameX, this._frameY, this._frameWidth, this._frameHeight);
        externalFrame.validate();
        this.selectComponent(jComponent);
    }

    public void removeComponent(JComponent jComponent) {
        ExternalFrame externalFrame = (ExternalFrame)this.getContainer(jComponent);
        if (externalFrame != null) {
            this._frames.remove(externalFrame);
            externalFrame.dispose();
        }
    }

    public void selectComponent(JComponent jComponent) {
        if (jComponent != null) {
            jComponent.requestFocus();
        }
    }

    public void updateComponentName(JComponent jComponent) {
        ExternalFrame externalFrame = (ExternalFrame)this.getContainer(jComponent);
        if (externalFrame != null) {
            externalFrame.setTitle(jComponent.getName());
        }
    }

    public Container getContentPane() {
        return null;
    }

    public Container getContainer(JComponent jComponent) {
        for (int i = 0; i < this._frames.size(); ++i) {
            ExternalFrame externalFrame = (ExternalFrame)this._frames.get(i);
            if (externalFrame.getComponent() != jComponent) continue;
            return externalFrame;
        }
        return null;
    }

    protected void computeNextFramePosition() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this._frameWidth = (int)dimension.getWidth() / 2;
        this._frameHeight = (int)dimension.getHeight() / 2;
        this._frameX += 40;
        this._frameY += 40;
        if ((double)(this._frameY + this._frameHeight) >= dimension.getWidth()) {
            this._frameY = 0;
        }
        if ((double)this._frameX >= dimension.getHeight()) {
            this._frameX = 0;
        }
    }

    public class ExternalFrameListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ExternalFrame externalFrame = (ExternalFrame)windowEvent.getSource();
            externalFrame.setVisible(false);
            ExternalMode.this._desktopCardPanel.removeComponent(externalFrame.getComponent());
        }

        public void windowActivated(WindowEvent windowEvent) {
            ExternalFrame externalFrame = (ExternalFrame)windowEvent.getSource();
        }
    }

    public class ExternalFrame
    extends JFrame {
        private JComponent _component;
        private JScrollPane _scrollPane;

        public ExternalFrame(JComponent jComponent, boolean bl) {
            this(jComponent, bl, true);
        }

        public ExternalFrame(JComponent jComponent, boolean bl, boolean bl2) {
            super("");
            this._component = jComponent;
            this.setDefaultCloseOperation(0);
            if (bl) {
                this._scrollPane = new JScrollPane(this._component, 22, 32);
                this.getContentPane().add("Center", this._scrollPane);
            } else {
                this.getContentPane().add("Center", this._component);
            }
            if (jComponent.getName() != null) {
                this.setTitle(jComponent.getName());
            }
            this.pack();
            this.show();
        }

        public JComponent getComponent() {
            return this._component;
        }

        public boolean isScrollable() {
            return this._scrollPane != null;
        }
    }
}

