/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public class XYDrawableAnnotation
implements XYAnnotation,
Cloneable,
Serializable {
    private double x;
    private double y;
    private double width;
    private double height;
    private Drawable drawable;

    public XYDrawableAnnotation(double d, double d2, double d3, double d4, Drawable drawable) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.drawable = drawable;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = (float)valueAxis.translateValueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.translateValueToJava2D(this.y, rectangle2D, rectangleEdge2);
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)f - this.width / 2.0, (double)f2 - this.height / 2.0, this.width, this.height);
        this.drawable.draw(graphics2D, (Rectangle2D)double_);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYDrawableAnnotation) {
            XYDrawableAnnotation xYDrawableAnnotation = (XYDrawableAnnotation)object;
            boolean bl = this.x == xYDrawableAnnotation.x;
            boolean bl2 = this.y == xYDrawableAnnotation.y;
            boolean bl3 = this.width == xYDrawableAnnotation.width;
            boolean bl4 = this.height == xYDrawableAnnotation.height;
            boolean bl5 = ObjectUtils.equal((Object)this.drawable, (Object)xYDrawableAnnotation.drawable);
            return bl && bl2 && bl3 && bl4 && bl5;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

