/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.SignalsDataset;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class SignalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double markOffset = 5.0;
    private double shapeWidth = 15.0;
    private double shapeHeight = 25.0;

    public double getMarkOffset() {
        return this.markOffset;
    }

    public void setMarkOffset(double d) {
        this.markOffset = d;
    }

    public double getShapeWidth() {
        return this.shapeWidth;
    }

    public void setShapeWidth(double d) {
        this.shapeWidth = d;
    }

    public double getShapeHeight() {
        return this.shapeHeight;
    }

    public void setShapeHeight(double d) {
        this.shapeHeight = d;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        Object object;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        SignalsDataset signalsDataset = (SignalsDataset)xYDataset;
        Number number = signalsDataset.getXValue(n, n2);
        Number number2 = signalsDataset.getYValue(n, n2);
        int n4 = signalsDataset.getType(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        int n5 = 1;
        if (n4 == 1 || n4 == -2) {
            d2 += this.markOffset;
            n5 = -1;
        } else {
            d2 -= this.markOffset;
        }
        GeneralPath generalPath = new GeneralPath();
        if (n4 == 1 || n4 == -1) {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)(d + this.shapeWidth / 2.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d - this.shapeWidth / 2.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)d, (float)d2);
        } else {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)d, (float)(d2 - (double)n5 * this.shapeHeight));
            object = new Ellipse2D.Double(d - this.shapeWidth / 2.0, d2 + (n5 == 1 ? -this.shapeHeight : this.shapeHeight - this.shapeWidth), this.shapeWidth, this.shapeWidth);
            generalPath.append((Shape)object, false);
        }
        graphics2D.fill(generalPath);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(generalPath);
        if (entityCollection != null) {
            object = null;
            if (this.getToolTipGenerator() != null) {
                object = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(generalPath, xYDataset, n, n2, (String)object, string);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

