/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsynoptic.plugins.jfreechart.JSynopticCyclicXYItemRenderer;
import jsynoptic.plugins.jfreechart.JSynopticXYItemRenderer;
import jsynoptic.plugins.jfreechart.SourceXYDataset;
import jsynoptic.plugins.jfreechart.StandardPlotShape;
import jsynoptic.ui.LongAction;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.ui.ActionCheckBox;
import simtools.ui.ColorMapper;
import simtools.ui.DynamicColorChooser;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class CyclicPlotShape
extends StandardPlotShape {
    static final long serialVersionUID = -7549636147827861795L;
    public static ResourceBundle resources = ResourceFinder.get((Class)(class$jsynoptic$plugins$jfreechart$CyclicPlotShape == null ? (class$jsynoptic$plugins$jfreechart$CyclicPlotShape = CyclicPlotShape.class$("jsynoptic.plugins.jfreechart.CyclicPlotShape")) : class$jsynoptic$plugins$jfreechart$CyclicPlotShape), (ResourceBundle)StandardPlotShape.resources);
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$CyclicPlotShape;

    public CyclicPlotShape(JFreeChart jFreeChart) {
        this(jFreeChart, 0, 0, 400, 300);
    }

    public CyclicPlotShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(jFreeChart, n, n2, n3, n4);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDomainAxis((ValueAxis)new CyclicNumberAxis(10.0, 0.0));
        xYPlot.setRenderer((XYItemRenderer)new JSynopticCyclicXYItemRenderer());
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return super.getActions(d, d2, object, n);
        }
        if (n == 4) {
            return super.getActions(d, d2, object, n);
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        XYPlot xYPlot = this.chart.getXYPlot();
        SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
        if (object instanceof DataSource) {
            vector.add(resources.getString("setX"));
            if (sourceXYDataset.getSources().size() != 0) {
                vector.add(resources.getString("addY"));
            }
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getString("setXY1Yn"));
            if (sourceXYDataset.getSources().size() != 0) {
                vector.add(resources.getString("addY1Yn"));
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    int n;
                    ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(CyclicPlotShape.this.chart);
                    JTabbedPane jTabbedPane = CyclicPlotShape.this.findTab((Container)chartPropertyEditPanel);
                    PlotPanel plotPanel = null;
                    if (jTabbedPane != null) {
                        plotPanel = new PlotPanel();
                        jTabbedPane.add((Component)plotPanel, 0);
                    }
                    if ((n = JOptionPane.showConfirmDialog(null, chartPropertyEditPanel, resources.getString("ChartProperties"), 2, -1)) == 0) {
                        chartPropertyEditPanel.updateChartProperties(CyclicPlotShape.this.chart);
                        if (plotPanel != null) {
                            plotPanel.updateChartProperties();
                        }
                    }
                    CyclicPlotShape.this.notifyChange();
                }
            }.start();
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PlotPanel
    extends JPanel {
        ActionCheckBox cbautox;
        ActionCheckBox cbfixedautox;
        ActionCheckBox cbcyclex;
        ActionCheckBox cbinvertx;
        NumberField nffixedautox;
        NumberField tfpxmin;
        NumberField tfpxmax;
        NumberField nfperiodx;
        NumberField nfoffsetx;
        JLabel lpxmin;
        JLabel lpxmax;
        ActionCheckBox cbautoy;
        ActionCheckBox cbfixedautoy;
        ActionCheckBox cbcycley;
        ActionCheckBox cbinverty;
        NumberField nffixedautoy;
        NumberField tfpymin;
        NumberField tfpymax;
        NumberField nfperiody;
        NumberField nfoffsety;
        JLabel lpymin;
        JLabel lpymax;
        JTextField tfTitle;
        JPanel xcards;
        JPanel ycards;
        Color noCurveColor;
        JComboBox pcbxcurves;
        JButton pcurvecolor;
        JButton pcurvedelete;
        StandardPlotShape.CbxEntry pactiveEntry;
        JTextField pcbxeditortf;
        boolean peditLocked;

        public PlotPanel() {
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            this.setName(resources.getString("PlotProperties"));
            XYPlot xYPlot = CyclicPlotShape.this.chart.getXYPlot();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("PlotTitle:")));
            this.tfTitle = new JTextField();
            box2.add(this.tfTitle);
            this.tfTitle.setText(CyclicPlotShape.this.chart.getTitle().getText());
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("XAxis")));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            CyclicNumberAxis cyclicNumberAxis = null;
            if (xYPlot.getDomainAxis() instanceof CyclicNumberAxis) {
                cyclicNumberAxis = (CyclicNumberAxis)xYPlot.getDomainAxis();
            }
            this.cbcyclex = new ActionCheckBox(this, resources.getString("CyclicAxis"), cyclicNumberAxis != null){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CardLayout cardLayout = (CardLayout)this.this$1.xcards.getLayout();
                    if (this.isSelected()) {
                        cardLayout.show(this.this$1.xcards, "cyclic");
                    } else {
                        cardLayout.show(this.this$1.xcards, "normal");
                    }
                }
            };
            jPanel.add((Component)this.cbcyclex);
            this.cbinvertx = new ActionCheckBox(this, resources.getString("Inverted"), xYPlot.getDomainAxis().isInverted()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            jPanel.add((Component)this.cbinvertx);
            box2.add(jPanel);
            this.xcards = new JPanel();
            this.xcards.setLayout(new CardLayout());
            Box box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("Period")));
            this.nfperiodx = new NumberField(cyclicNumberAxis == null ? 0.0 : cyclicNumberAxis.getPeriod());
            box3.add((Component)this.nfperiodx);
            box3.add(Box.createHorizontalGlue());
            box3.add(new JLabel(resources.getString("Offset")));
            this.nfoffsetx = new NumberField(cyclicNumberAxis == null ? 0.0 : cyclicNumberAxis.getOffset());
            box3.add((Component)this.nfoffsetx);
            this.xcards.add((Component)box3, "cyclic");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            double d = xYPlot.getDomainAxis().getFixedAutoRange();
            this.cbfixedautox = new ActionCheckBox(this, resources.getString("FixedRange"), d != 0.0){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.nffixedautox.setEnabled(this.isSelected() && this.isEnabled());
                }
            };
            jPanel.add((Component)this.cbfixedautox);
            this.nffixedautox = new NumberField(d, 10);
            jPanel.add((Component)this.nffixedautox);
            this.xcards.add((Component)jPanel, "normal");
            box2.add(this.xcards);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbautox = new ActionCheckBox(this, resources.getString("Auto-update"), xYPlot.getDomainAxis().isAutoRange()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cbfixedautox.setEnabled(this.isSelected());
                    this.this$1.cbfixedautox.apply();
                    this.this$1.lpxmin.setEnabled(!this.isSelected());
                    this.this$1.lpxmax.setEnabled(!this.isSelected());
                    this.this$1.tfpxmin.setEnabled(!this.isSelected());
                    this.this$1.tfpxmax.setEnabled(!this.isSelected());
                }
            };
            jPanel.add((Component)this.cbautox);
            this.lpxmin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lpxmin);
            this.tfpxmin = new NumberField(10);
            jPanel.add((Component)this.tfpxmin);
            this.tfpxmin.setValue(xYPlot.getDomainAxis().getLowerBound());
            this.lpxmax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lpxmax);
            this.tfpxmax = new NumberField(10);
            jPanel.add((Component)this.tfpxmax);
            this.tfpxmax.setValue(xYPlot.getDomainAxis().getUpperBound());
            this.cbautox.apply();
            box2.add(jPanel);
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("YAxis")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            cyclicNumberAxis = null;
            if (xYPlot.getRangeAxis() instanceof CyclicNumberAxis) {
                cyclicNumberAxis = (CyclicNumberAxis)xYPlot.getRangeAxis();
            }
            this.cbcycley = new ActionCheckBox(this, resources.getString("CyclicAxis"), cyclicNumberAxis != null){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CardLayout cardLayout = (CardLayout)this.this$1.ycards.getLayout();
                    if (this.isSelected()) {
                        cardLayout.show(this.this$1.ycards, "cyclic");
                    } else {
                        cardLayout.show(this.this$1.ycards, "normal");
                    }
                }
            };
            jPanel.add((Component)this.cbcycley);
            this.cbinverty = new ActionCheckBox(this, resources.getString("Inverted"), xYPlot.getRangeAxis().isInverted()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            jPanel.add((Component)this.cbinverty);
            box2.add(jPanel);
            this.ycards = new JPanel();
            this.ycards.setLayout(new CardLayout());
            box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("Period")));
            this.nfperiody = new NumberField(cyclicNumberAxis == null ? 0.0 : cyclicNumberAxis.getPeriod());
            box3.add((Component)this.nfperiody);
            box3.add(Box.createHorizontalGlue());
            box3.add(new JLabel(resources.getString("Offset")));
            this.nfoffsety = new NumberField(cyclicNumberAxis == null ? 0.0 : cyclicNumberAxis.getOffset());
            box3.add((Component)this.nfoffsety);
            this.ycards.add((Component)box3, "cyclic");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            d = xYPlot.getRangeAxis().getFixedAutoRange();
            this.cbfixedautoy = new ActionCheckBox(this, resources.getString("FixedRange"), d != 0.0){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.nffixedautoy.setEnabled(this.isSelected() && this.isEnabled());
                }
            };
            jPanel.add((Component)this.cbfixedautoy);
            this.nffixedautoy = new NumberField(d, 10);
            jPanel.add((Component)this.nffixedautoy);
            this.ycards.add((Component)jPanel, "normal");
            box2.add(this.ycards);
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbautoy = new ActionCheckBox(this, resources.getString("Auto-update"), xYPlot.getRangeAxis().isAutoRange()){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cbfixedautoy.setEnabled(this.isSelected());
                    this.this$1.cbfixedautoy.apply();
                    this.this$1.lpymin.setEnabled(!this.isSelected());
                    this.this$1.lpymax.setEnabled(!this.isSelected());
                    this.this$1.tfpymin.setEnabled(!this.isSelected());
                    this.this$1.tfpymax.setEnabled(!this.isSelected());
                }
            };
            jPanel.add((Component)this.cbautoy);
            this.lpymin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lpymin);
            this.tfpymin = new NumberField(10);
            jPanel.add((Component)this.tfpymin);
            this.tfpymin.setValue(xYPlot.getRangeAxis().getLowerBound());
            this.lpymax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lpymax);
            this.tfpymax = new NumberField(10);
            jPanel.add((Component)this.tfpymax);
            this.tfpymax.setValue(xYPlot.getRangeAxis().getUpperBound());
            this.cbautoy.apply();
            box2.add(jPanel);
            Box box4 = Box.createHorizontalBox();
            box4.add(new JLabel(resources.getString("Curves:")));
            this.pcbxcurves = new JComboBox();
            box4.add(this.pcbxcurves);
            this.pcurvecolor = new JButton("    ");
            box4.add(this.pcurvecolor);
            this.pcurvedelete = new JButton(resources.getString("Delete"));
            box4.add(this.pcurvedelete);
            box2.add(box4);
            box.add(box2);
            this.pcbxcurves.setEditable(true);
            this.noCurveColor = this.pcurvecolor.getBackground();
            this.pcurvecolor.setFocusPainted(false);
            SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
            int n = sourceXYDataset.getSeriesCount();
            JSynopticXYItemRenderer jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getRenderer();
            for (int i = 0; i < n; ++i) {
                DataSource dataSource;
                DataSource dataSource2 = jSynopticXYItemRenderer.getDataSource(i);
                if (dataSource2 == null && (dataSource = DataInfo.getLinkedSource((Object)(dataSource2 = sourceXYDataset.getYSource(i)))) != null) {
                    dataSource2 = dataSource;
                }
                this.pcbxcurves.addItem(new StandardPlotShape.CbxEntry(i, sourceXYDataset.getSeriesName(i), (Color)jSynopticXYItemRenderer.getSeriesPaint(i), dataSource2, jSynopticXYItemRenderer.getColorMapper(i)));
            }
            this.pcbxeditortf = (JTextField)this.pcbxcurves.getEditor().getEditorComponent();
            this.pupdateForEntry(this.pcbxcurves.getSelectedItem());
            this.pcbxcurves.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = true;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }
            });
            this.pcbxcurves.addItemListener(new ItemListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        this.this$1.pactiveEntry = null;
                    } else {
                        this.this$1.pupdateForEntry(itemEvent.getItem());
                    }
                }
            });
            this.pcbxeditortf.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void updateName() {
                    if (this.this$1.peditLocked || this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.name = this.this$1.pcbxeditortf.getText();
                }
            });
            this.pcurvecolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    Color color = DynamicColorChooser.showDialog(null, (String)resources.getString("ChooseAColor"), null, (Color)this.this$1.pactiveEntry.color, (DataSource)this.this$1.pactiveEntry.source, (ColorMapper)this.this$1.pactiveEntry.mapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.color = color;
                    this.this$1.pactiveEntry.source = DynamicColorChooser.getSource();
                    this.this$1.pactiveEntry.mapper = DynamicColorChooser.getMapper();
                    this.this$1.pupdateForEntry(this.this$1.pactiveEntry);
                }
            });
            this.pcurvedelete.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pcbxcurves.removeItem(this.this$1.pactiveEntry);
                }
            });
            this.cbcyclex.apply();
            this.cbcycley.apply();
            this.add((Component)box, "North");
        }

        protected void pupdateForEntry(Object object) {
            this.pactiveEntry = object instanceof StandardPlotShape.CbxEntry ? (StandardPlotShape.CbxEntry)object : null;
            if (this.pactiveEntry == null) {
                return;
            }
            this.pcurvecolor.setBackground(this.pactiveEntry.color);
        }

        protected void updateChartProperties() {
            Object object;
            NumberAxis numberAxis = null;
            if (this.cbcyclex.isSelected()) {
                numberAxis = new CyclicNumberAxis(this.nfperiodx.getDoubleValue(), this.nfoffsetx.getDoubleValue());
            } else {
                numberAxis = new NumberAxis();
                if (this.nffixedautox.isEnabled()) {
                    numberAxis.setFixedAutoRange(this.nffixedautox.getDoubleValue());
                }
            }
            numberAxis.setAutoRange(this.cbautox.isSelected());
            numberAxis.setInverted(this.cbinvertx.isSelected());
            if (this.tfpxmin.isEnabled() && this.tfpxmax.isEnabled()) {
                numberAxis.setRange(this.tfpxmin.getDoubleValue(), this.tfpxmax.getDoubleValue());
            }
            NumberAxis numberAxis2 = null;
            if (this.cbcycley.isSelected()) {
                numberAxis2 = new CyclicNumberAxis(this.nfperiody.getDoubleValue(), this.nfoffsety.getDoubleValue());
            } else {
                numberAxis2 = new NumberAxis();
                if (this.nffixedautoy.isEnabled()) {
                    numberAxis2.setFixedAutoRange(this.nffixedautoy.getDoubleValue());
                }
            }
            numberAxis2.setAutoRange(this.cbautoy.isSelected());
            numberAxis2.setInverted(this.cbinverty.isSelected());
            if (this.tfpymin.isEnabled() && this.tfpymax.isEnabled()) {
                numberAxis2.setRange(this.tfpymin.getDoubleValue(), this.tfpymax.getDoubleValue());
            }
            CyclicPlotShape.this.chart.setTitle(this.tfTitle.getText());
            XYPlot xYPlot = CyclicPlotShape.this.chart.getXYPlot();
            xYPlot.setDomainAxis((ValueAxis)numberAxis);
            xYPlot.setRangeAxis((ValueAxis)numberAxis2);
            SourceXYDataset sourceXYDataset = (SourceXYDataset)xYPlot.getDataset();
            int n = sourceXYDataset.getSeriesCount();
            if (n != this.pcbxcurves.getItemCount()) {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < this.pcbxcurves.getItemCount(); ++i) {
                    blArray[((StandardPlotShape.CbxEntry)this.pcbxcurves.getItemAt((int)i)).datasetIndex] = true;
                }
                object = (JSynopticXYItemRenderer)xYPlot.getRenderer();
                for (int i = n - 1; i >= 0; --i) {
                    if (blArray[i]) continue;
                    if (i > 0) {
                        sourceXYDataset.removeXSource(i);
                    } else {
                        sourceXYDataset.removeYSource(i);
                    }
                    object.removeColorMapper(i);
                    object.removeDataSource(i);
                }
            }
            for (int i = 0; i < this.pcbxcurves.getItemCount(); ++i) {
                object = (StandardPlotShape.CbxEntry)this.pcbxcurves.getItemAt(i);
                sourceXYDataset.setName(i, ((StandardPlotShape.CbxEntry)object).name);
                JSynopticXYItemRenderer jSynopticXYItemRenderer = (JSynopticXYItemRenderer)xYPlot.getRenderer();
                jSynopticXYItemRenderer.setSeriesPaint(i, ((StandardPlotShape.CbxEntry)object).color);
                jSynopticXYItemRenderer.setDataSource(i, ((StandardPlotShape.CbxEntry)object).source);
                jSynopticXYItemRenderer.setColorMapper(i, ((StandardPlotShape.CbxEntry)object).mapper);
            }
        }
    }
}

