/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class SizeSelector
extends BaseExtendSelector {
    private long size = -1L;
    private long multiplier = 1L;
    private long sizelimit = -1L;
    private int cmp = 2;
    public static final String SIZE_KEY = "value";
    public static final String UNITS_KEY = "units";
    public static final String WHEN_KEY = "when";

    public String toString() {
        StringBuffer buf = new StringBuffer("{sizeselector value: ");
        buf.append(this.sizelimit);
        buf.append("compare: ");
        if (this.cmp == 0) {
            buf.append("less");
        } else if (this.cmp == 1) {
            buf.append("more");
        } else {
            buf.append("equal");
        }
        buf.append("}");
        return buf.toString();
    }

    public void setValue(long size) {
        this.size = size;
        if (this.multiplier != 0L && size > -1L) {
            this.sizelimit = size * this.multiplier;
        }
    }

    public void setUnits(ByteUnits units) {
        int i = units.getIndex();
        this.multiplier = 0L;
        if (i > -1 && i < 4) {
            this.multiplier = 1000L;
        } else if (i > 3 && i < 9) {
            this.multiplier = 1024L;
        } else if (i > 8 && i < 13) {
            this.multiplier = 1000000L;
        } else if (i > 12 && i < 18) {
            this.multiplier = 0x100000L;
        } else if (i > 17 && i < 22) {
            this.multiplier = 1000000000L;
        } else if (i > 21 && i < 27) {
            this.multiplier = 0x40000000L;
        } else if (i > 26 && i < 31) {
            this.multiplier = 1000000000000L;
        } else if (i > 30 && i < 36) {
            this.multiplier = 0x10000000000L;
        }
        if (this.multiplier > 0L && this.size > -1L) {
            this.sizelimit = this.size * this.multiplier;
        }
    }

    public void setWhen(SizeComparisons cmp) {
        this.cmp = cmp.getIndex();
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                String paramname = parameters[i].getName();
                if (SIZE_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setValue(new Long(parameters[i].getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid size setting " + parameters[i].getValue());
                    }
                } else if (UNITS_KEY.equalsIgnoreCase(paramname)) {
                    ByteUnits units = new ByteUnits();
                    units.setValue(parameters[i].getValue());
                    this.setUnits(units);
                } else if (WHEN_KEY.equalsIgnoreCase(paramname)) {
                    SizeComparisons cmp = new SizeComparisons();
                    cmp.setValue(parameters[i].getValue());
                    this.setWhen(cmp);
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++i;
            }
        }
    }

    public void verifySettings() {
        if (this.size < 0L) {
            this.setError("The value attribute is required, and must be positive");
        } else if (this.multiplier < 1L) {
            this.setError("Invalid Units supplied, must be K,Ki,M,Mi,G,Gi,T,or Ti");
        } else if (this.sizelimit < 0L) {
            this.setError("Internal error: Code is not setting sizelimit correctly");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        if (file.isDirectory()) {
            return true;
        }
        if (this.cmp == 0) {
            return file.length() < this.sizelimit;
        }
        if (this.cmp == 1) {
            return file.length() > this.sizelimit;
        }
        return file.length() == this.sizelimit;
    }

    static {
        SIZE_KEY = SIZE_KEY;
        UNITS_KEY = UNITS_KEY;
        WHEN_KEY = WHEN_KEY;
    }

    public static class SizeComparisons
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"less", "more", "equal"};
        }
    }

    public static class ByteUnits
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"K", "k", "kilo", "KILO", "Ki", "KI", "ki", "kibi", "KIBI", "M", "m", "mega", "MEGA", "Mi", "MI", "mi", "mebi", "MEBI", "G", "g", "giga", "GIGA", "Gi", "GI", "gi", "gibi", "GIBI", "T", "t", "tera", "TERA", "Ti", "TI", "ti", "tebi", "TEBI"};
        }
    }
}

