/* $Id: SpecSampleList.java,v 1.2 2006/06/04 08:33:45 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */


package tsp.consumer.util.configuration;


import java.util.LinkedList;
import java.util.List;

import tsp.util.ToStringHelper;

public class SpecSampleList implements Consolidatable{

    private Integer implicitPeriod; 
    private VarTypeEnum implicitType;
    private Integer implicitPhase;
    private VarAccessEnum implicitAccess;
    private String implicitProviderName;
    private LinkedList samples = new LinkedList();
    private final SpecSamplingConfig root;

    public SpecSampleList(final SpecSamplingConfig root) {
		super();
		this.root = root;
		/* Default attributes if not informed */
		this.implicitProviderName = new String("rpc://localhost");
		this.implicitPeriod = new Integer(1);
		this.implicitPhase = new Integer(0);
		this.implicitAccess = VarAccessEnum.SYNC;
	}
    
    // Internal
    SpecSample getLastSample(){
        return (SpecSample)samples.getLast();
    }

    void addLastSample(SpecSample l){        
        l.setSampleList(this);
    }

    // External
    public Integer getImplicitPeriod() {
        return implicitPeriod;
    }

    public void setImplicitPeriod(Integer implicitPeriod) {
        this.implicitPeriod = implicitPeriod;
    }
    
    public VarTypeEnum getImplicitType() {
        return implicitType;
    }

    public void setImplicitType(VarTypeEnum implicitType) {
        this.implicitType = implicitType;
    }
    
    public VarAccessEnum getImplicitAccess() {
        return implicitAccess;
    }

    public void setImplicitAccess(VarAccessEnum implicitAccess) {
        this.implicitAccess = implicitAccess;
    }
   
    
    public Integer getImplicitPhase() {
        return implicitPhase;
    }
    public void setImplicitPhase(Integer implicitPhase) {
        this.implicitPhase = implicitPhase;
    }
    
    public String getImplicitProviderName() {
        return implicitProviderName;
    }

    public void setImplicitProviderName(String implicitProviderName) {
        this.implicitProviderName = implicitProviderName;
    }

    public List getSamples() {
        return samples;
    }

     public String toString(){
        return ToStringHelper.toString(this);
    }
     
     public void consolidate() throws SpecException {
		ConsolidatorHelper.Consolidate(samples);
	}

}
