/***************************************************************************
                          statistics.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qpainter.h>
#include <klocale.h>
#include "statistics.h"
#include "stuff.h"

Statistics::Statistics (statistical_data* input):QWidget (0, "KWiFiManager")
{
  this->setCaption (i18n ("Statistics - KWiFiManager"));
  drawdata=input;
}

void
Statistics::paintEvent (QPaintEvent *)
{
  statpainter = new QPainter (this);
  QColor farbe (255, 255, 255);
  statpainter->drawText (40, 30, i18n ("Noise/Signal Level Statistics"));
  statpainter->drawText (150, 260, i18n ("BLUE = signal level, RED = noise level"));
  statpainter->drawLine (41, 244, 41, 260);
  statpainter->drawLine (520, 244, 520, 260);
  statpainter->drawText (21, 274, i18n ("-240 s"));
  statpainter->drawText (510, 274, i18n ("now"));
  statpainter->fillRect (41, 41, 480, 201, farbe);
  QPointArray datensatz (240);
  QPointArray datensatz2 (240);
  // we may need to scale the output to fit into the window, so here we 
  // determine the range of values
  int bottom = (drawdata->sigLevelMin > drawdata->noiseLevelMin) ? drawdata->noiseLevelMin : drawdata->sigLevelMin;
  int top    = (drawdata->sigLevelMax > drawdata->noiseLevelMax) ? drawdata->sigLevelMax : drawdata->noiseLevelMax;
  int datarange = top - bottom;
  statpainter->drawText (25, 50, QString("%1").arg(top));
  statpainter->drawText (25,240, QString("%1").arg(bottom));
  double scaleRatio;
  if (datarange!=0) {
    scaleRatio = 200. / datarange;
  } else {
    scaleRatio = 1.;
  }
  int i = 0;
  bool atLeastOneValid = false;
  for (int j = drawdata->current; j < drawdata->current + 240; j++)
    {
      if (drawdata->valid[j % 240]) {
        atLeastOneValid = true;
	datensatz.setPoint (i, 40 + (i * 2), 241 - (int)((drawdata->sigLevel[j % 240]-bottom) * scaleRatio));
        datensatz2.setPoint (i, 40 + (i * 2), 241 - (int)((drawdata->noiseLevel[j % 240]-bottom) * scaleRatio));
      } else {
        datensatz.setPoint (i, 40 + (i * 2), 241);
        datensatz2.setPoint (i, 40 + (i * 2), 241);
      }
      i++;
    };
  // the above point array is only useful if at least one entry has its
  // valid flag set. This fact is determined in the iteration before.
  // Only paint the point array if there is one valid entry
  if (atLeastOneValid) {
    statpainter->setPen (red);
    statpainter->drawPolyline (datensatz2, 1);
    statpainter->setPen (blue);
    statpainter->drawPolyline (datensatz, 1);
  }
  delete statpainter;
}
