# Conditional build (replace "#" with "%" to enable):
#
#define _with_ncurses		 1 # use ncurses
#define _with_included_slang	 1 # use included S-Lang library
#define _with_charset		 1 # enable code for charset conversion
#define _with_samba		 1 # enable SMB/CIFS virtual file system
#define _with_ext2undel		 1 # compile with ext2 undelete code
#define _without_x		 1 # avoid dependency on X11 libraries

# Note that this is NOT a relocatable package
%define ver     2007-03-09-18
%define rpmver   2007030918
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary:   Midnight Commander visual shell
Name:      mc
Version:   %rpmver
Release:   %rel
Epoch:     1
License:   GPL/LGPL
Group:     Applications/File
Source0:   ftp://ftp.ibiblio.org/pub/Linux/utils/file/managers/mc/mc-%{ver}.tar.gz
URL:       http://www.ibiblio.org/mc/
BuildRoot: /var/tmp/mc-%{PACKAGE_VERSION}-root

# Names of those packages are distribution specific
#BuildRequires: glib-devel
#%{!?_with_included_slang:%{!?_with_ncurses:BuildRequires: slang-devel}}
#%{?_with_ncurses:BuildRequires: ncurses-devel}

%description
GNU Midnight Commander is a visual file manager.  It's a feature rich
full-screen text mode application that allows you to copy, move and
delete files and whole directory trees, search for files and run
commands in the subshell.  Internal viewer and editor are included.
Mouse is supported under X Window System and on Linux console.  VFS
(Virtual Filesystem) allows you to view archives and files on remote
servers.

%prep
%setup -q -n mc-%{ver}

%build
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix=%{_prefix} \
	--mandir=%{_mandir} \
%{?_with_ncurses: --with-screen=ncurses} \
%{?_with_included_slang: --with-screen=mcslang} \
%{?_with_charset: --enable-charset} \
%{?_with_samba: --with-samba} \
%{?_with_ext2undel: --with-ext2undel} \
%{?_without_x: --without-x}

make

%install
echo $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/%{_sysconfdir}/profile.d
cp -f $RPM_BUILD_ROOT/%{_datadir}/mc/bin/mc.*sh \
	$RPM_BUILD_ROOT/%{_sysconfdir}/profile.d


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc FAQ COPYING NEWS README
%{_bindir}/mc
%{_bindir}/mcedit
%{_bindir}/mcview
%{_bindir}/mcmfmt
%{_libexecdir}/mc/cons.saver
%{_mandir}/man1/*
%{_mandir}/*/man1/*

%config %{_sysconfdir}/profile.d/*
%{_datadir}/mc/cedit.menu
%{_datadir}/mc/edit.indent.rc
%{_datadir}/mc/edit.spell.rc
%{_datadir}/mc/bin/*
%{_datadir}/mc/extfs/*
%{_datadir}/mc/mc.ext
%{_datadir}/mc/mc.lib
%{_datadir}/mc/mc.menu*
%{?_with_charset:%config %{_datadir}/mc/mc.charsets}

%{_datadir}/mc/mc.hint*
%{_datadir}/mc/mc.hlp*
%{_datadir}/mc/syntax/*
%{_datadir}/locale/*/LC_MESSAGES/*

%dir %{_libexecdir}/mc
%dir %{_datadir}/mc
%dir %{_datadir}/mc/extfs
%dir %{_datadir}/mc/syntax

%changelog
* Thu Dec 21 2006 Pavel Roskin <proski@gnu.org>
- Don't rely on brace expansion, it may be disabled

* Mon Jan 30 2006 Pavel Roskin <proski@gnu.org>
- Avoid using %{_prefix} where more specialized macros are available.

* Tue Aug 02 2005 Pavel Roskin <proski@gnu.org>
- Replace obsolete "Copyright" with "License".

* Thu Mar 31 2005 Pavel Roskin <proski@gnu.org>
- Comment out build dependencies - they are too distribution specific.

* Tue Sep 23 2003 Pavel Roskin <proski@gnu.org>
- Remove term directory, it's obsolete and irrelevant on modern systems.
- Include translated menu files.

* Sun Feb 16 2003 Pavel Roskin <proski@gnu.org>
- Remove obsolete dependency on /sbin/chkconfig.

* Tue Dec 24 2002 Pavel Roskin <proski@gnu.org>
- Work around bug in rpm 4.1 that expands defines in comments.
- Handle --without-x.

* Mon Nov 04 2002 Andrew V. Samoilov <sav@bcs.zp.ua>
- Handle --with ext2undel.

* Fri Nov 01 2002 Pavel Roskin <proski@gnu.org>
- Add wrappers to support setting last directory on exit.  Keep all
  scripts in their original directory, just copy them.

* Tue Oct 22 2002 Pavel Roskin <proski@gnu.org>
- Don't use the included S-Lang, there is a workaround for Red Hat 8.0
  S-Lang, and binary compatibility with Red Hat 7.x doesn't work anyway.

* Tue Oct 08 2002 Pavel Roskin <proski@gnu.org>
- Use the included S-Lang again, since we include a better version now.
  This should avoid incompatibility with Red Hat 7.x.
- Add _with_glib2 option.

* Mon Oct 07 2002 Pavel Roskin <proski@gnu.org>
- Remove installed mc.sh and mc.csh from %{_prefix}/share/mc/bin to
  suppress a warning about installed but unpackaged files.

* Mon Sep 30 2002 Andrew V. Samoilov <sav@bcs.zp.ua>
- Don't require slang-devel if _with_ncurses.
- Handle --with samba.

* Sun Sep 29 2002 Pavel Roskin <proski@gnu.org>
- Use --with-screen instead of --with-ncurses and --with-included-slang.

* Mon Sep 23 2002 Andrew V. Samoilov <sav@bcs.zp.ua>
- Restore %config for %{_prefix}/share/mc/mc.charsets.
- Restore %{_prefix}/share/mc/edit.spell.rc.

* Sat Sep 21 2002 Pavel Roskin <proski@gnu.org>
- Use FHS-compliant paths.
- Drop %config from files under /usr/share - users are not supposed to
  edit them.  Local copies under ~/.mc should be used for that.

* Wed Aug 21 2002 Pavel Roskin <proski@gnu.org>
- Change description, update URLs, allow dash in the version.

* Tue Aug 20 2002 Pavel Roskin <proski@gnu.org>
- Support conditional builds.

* Tue Aug 20 2002 Andrew V. Samoilov <sav@bcs.zp.ua>
- Add /usr/lib/mc/mc.charsets.
- Add %{_mandir}/*/man1/*.

* Fri Aug 16 2002 Pavel Roskin <proski@gnu.org>
- Remove mc.global.

* Mon Jan 21 2002 Pavel Roskin <proski@gnu.org>
- Remove --with-gnome and --with-included-slang from configure options.
- Add BuildPrereq.

* Fri Aug 24 2001 Pavel Roskin <proski@gnu.org>
- Remove gmc.  Reunite mc and mc-common.

* Sun Aug 05 2001 Pavel Roskin <proski@gnu.org>
- Set epoch.

* Sun Jul 15 2001 Pavel Roskin <proski@gnu.org>
- Remove /usr/lib/mc/layout.

* Sat Jun 09 2001 Pavel Roskin <proski@gnu.org>
- Use %{_prefix} and %{_mandir}. Specify --mandir to configure.

* Fri May 25 2001 Pavel Roskin <proski@gnu.org>
- Change groups. Don't include locale directories. More config files.

* Sun May 20 2001 Pavel Roskin <proski@gnu.org>
- Don't require stylesheets, since HTML files are now in the tarball.

* Thu Apr 19 2001 Pavel Roskin <proski@gnu.org>
- Remove package mcserv. Drop dependency on PAM.

* Mon Feb 26 2001 Pavel Roskin <proski@gnu.org>
- Remove mc-gnome.ext.

* Thu Jan 11 2001 Pavel Roskin <proski@gnu.org>
- Include mcview.

* Mon Oct 23 2000 Pavel Roskin <proski@gnu.org>
- Allow mcserv.8 to be gzipped.

* Sat Sep 30 2000 Pavel Roskin <proski@gnu.org>
- New package mc-common.
- Use DESTDIR instead of misusing prefix.
- Don't install old icons - they don't exist

* Sat Sep 23 2000 Pavel Roskin <proski@gnu.org>
- Include translations with mc, not gmc
- chkconfig --del in %preun, not %postun
- --without-debug not needed
- /etc/X11/wmconfig not needed
- /etc/pam.d/mcserv shouldn't be executable
- New files in %{prefix}/lib/mc/ - translated hints, editor files

* Thu Sep 09 1999 Elliot Lee <sopwith@redhat.com>
- Include .idl files in the package.

* Sat Sep 04 1999 Gregory McLean <gregm@comstar.net>
- Added a build prereq so that rpms get built with documentation ;)

* Mon Jul 12 1999 Kjartan Maraas  <kmaraas@online.no>
- added help and locale files to %files

* Tue Jun 22 1999 Vladimir Kondratiev <vkondra@iil.intel.com>
- added syntax files to %files

* Wed May 26 1999 Cody Russell <bratsche@dfw.net>
- chmod cons.saver at $RPM_BUILD_ROOT%{prefix}/lib rather than at
  $RPM_BUILD_ROOT/usr/lib. We can now install to somewhere other than /usr.

* Sun Apr 18 1999 Gregory McLean <gregm@comstar.net>
- Updated the specfile, removed some kludges.

* Thu Aug 20 1998 Michael Fulbright <msf@redhat.com>
- rebuilt against gnome-libs 0.27 and gtk+-1.1

* Thu Jul 09 1998 Michael Fulbright <msf@redhat.com>
- made cons.saver not setuid

* Sun Apr 19 1998 Marc Ewing <marc@redhat.com>
- removed tkmc

* Wed Apr 8 1998 Marc Ewing <marc@redhat.com>
- add /usr/lib/mc/layout to gmc

