/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.CloseableIterationBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableIteratorIteration<E, X extends Exception>
extends CloseableIterationBase<E, X> {
    private Iterator<? extends E> iter;

    public CloseableIteratorIteration() {
    }

    public CloseableIteratorIteration(Iterator<? extends E> iter) {
        this.setIterator(iter);
    }

    protected void setIterator(Iterator<? extends E> iter) {
        this.iter = iter;
    }

    @Override
    public boolean hasNext() {
        return !this.isClosed() && this.iter.hasNext();
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        this.iter.remove();
    }
}

