/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "chanlist.h"
#include "chanlist.moc"

#include <stdio.h>
#include <stdlib.h>

#include "flags.h"
#include "main.h"
#include "channel.h"
#include "global.h"

#include <kwin.h>

#include <qpainter.h>
#include <qaccel.h>
//---------------------------------------------------------------------------
#define WIDTH_0 80
#define WIDTH_1 20
#define WIDTH_2 80
#define WIDTH_3 50
#define WIDTH_4 150
#define WIDTH_ALL (WIDTH_0+WIDTH_1+WIDTH_2+WIDTH_3+WIDTH_4)
//---------------------------------------------------------------------------
extern TopLevel *toplevel;
//---------------------------------------------------------------------------
char modes[][50] = {"information transfer",
                    "setup connection",
                    "disconnected",
                    "7plus-autosave",
                    "AutoBIN-save",
                    "AutoBIN-send",
                    "DIDADIT-RX",
                    "DIDADIT-TX"};
//---------------------------------------------------------------------------
ChanListToolTip::ChanListToolTip( ChanList *parent )
		: QToolTip( parent )
{
	chlist = parent;
}
//---------------------------------------------------------------------------
ChanListToolTip::~ChanListToolTip()
{
}
//---------------------------------------------------------------------------
void ChanListToolTip::maybeTip( const QPoint & rect )
{
	int i, swtype;
   ChanListEntry *entry;
   QString sTip, tmp;
   QRect moveRect;		// Der Tooltip wird solange gezeigt, wie Mauszeiger
   							// innerhalb dieses Rechtecks ist


   if ((entry = chlist->getEntry( rect.y(), moveRect )) == NULL) return;

	sTip = i18n("Call")+": <b>"+entry->getCall()+"</b><br>";
   if (!entry->chan->userinfo->getName().isEmpty())
      sTip += i18n("Name")+": "+entry->chan->userinfo->getName()+"<br>";
	sTip += i18n("Type")+": ";
   switch (entry->chan->userinfo->getType())
   {
   	case TYPE_TERMINAL:
      	sTip += i18n("Terminal"); break;
   	case TYPE_MAILBOX:
      	sTip += i18n("Mailbox"); break;
   	case TYPE_DIGI:
      	sTip += i18n("Digipeater"); break;
   	case TYPE_CONVERS:
      	sTip += i18n("Convers"); break;
		default:
      	sTip += i18n("unknown");
   }

   tmp = "";
   swtype = entry->chan->userinfo->getSwType();
	for (i=0;i<SW_ANZ;i++)
      if (swType[i].id == swtype)
      {
	   	tmp.sprintf(" (%s)", swType[i].text );
         break;
		}
	sTip += tmp;

//	+"<br>";


   tip( moveRect, sTip );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
ChanListEntry::ChanListEntry( Channel *rxchan, const QString & rxcall, const QString & rxmycall, const QString & rxtype, bool rxincoming )
       : QObject()
{
   mycall = rxmycall;
   call = rxcall;
   type = rxtype;
   incoming = rxincoming;
   isnew = false;

   mode = 0;
   chan = rxchan;
}
//---------------------------------------------------------------------------
ChanListEntry::~ChanListEntry()
{
}
//---------------------------------------------------------------------------
const QString & ChanListEntry::getCall()
{
   return call;
}
//---------------------------------------------------------------------------
const QString & ChanListEntry::getMycall()
{
   return mycall;
}
//---------------------------------------------------------------------------
const QString & ChanListEntry::getType()
{
   return type;
}
//---------------------------------------------------------------------------
void ChanListEntry::setType( int newtype )
{
   switch (newtype)
   {
      case -1: type = "????"; break;
      case TYPE_TERMINAL: type = "TERM"; break;
      case TYPE_MAILBOX: type = "BBS"; break;
      case TYPE_DIGI: type = "DIGI"; break;
      case TYPE_CONVERS: type = "CONV"; break;
   }
}
//---------------------------------------------------------------------------
void ChanListEntry::setCall( const QString & newcall )
{
   call = newcall;
}
//---------------------------------------------------------------------------
bool ChanListEntry::isIncoming()
{
   return incoming;
}
//---------------------------------------------------------------------------
bool ChanListEntry::isNew()
{
   return isnew;
}
//---------------------------------------------------------------------------
bool ChanListEntry::setNew( bool neu )
{
   if (isnew == neu) return false;
   isnew = neu;
   return true;
}
//---------------------------------------------------------------------------
void ChanListEntry::setMode( int newmode )
{
   mode = newmode;
}
//---------------------------------------------------------------------------
int ChanListEntry::getMode()
{
   return mode;
}
//---------------------------------------------------------------------------
void ChanListEntry::paintCell( QPainter *p, QFont & f, int col, int w, int h )
{
	QString str;


	f.setBold( isnew );

   switch (mode)
   {
		case MODE_INFO:
      		p->setPen( colors[conf->getColor(CFG_COLOR_CL_INF)].color );
            break;
		case MODE_SETUP:
      		p->setPen( colors[conf->getColor(CFG_COLOR_CL_SETUP)].color );
            break;
		case MODE_DISC:
      		p->setPen( colors[conf->getColor(CFG_COLOR_CL_DISC)].color );
            break;
		case MODE_7AUTOSAVE:
		case MODE_AUTOBINRX:
		case MODE_AUTOBINTX:
		case MODE_DIDADITRX:
		case MODE_DIDADITTX:
      		p->setPen( colors[conf->getColor(CFG_COLOR_CL_FILETRANS)].color );
            break;
   }


	switch (col)
	{
		case 0: str = call; break;
		case 1: if (incoming)
						str = "->";
					else
						str = "<-";
					break;
		case 2: str = mycall; break;
		case 3: str = type; break;
		case 4: str = modes[mode]; break;
	}

	p->setFont(f);

	// Die zweite Spalte zentrieren
	switch (col)
	{
		case 0: p->drawText( 2, 0, w, h, AlignLeft, str ); break;
		case 1: p->drawText( 0, 0, w, h, AlignCenter, str ); break;
		default: p->drawText( 0, 0, w, h, AlignLeft, str ); break;
	}
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
ChanList::ChanList( QWidget* parent )
             : QTableView( parent )
{
   QAccel *a;

   font = QFont("helvetica", 12);

   QFontMetrics fm(font);

   setNumCols(5);
   setNumRows(0);
   setCellWidth(0);
   setCellHeight(fm.height()+2);

   setTableFlags( Tbl_clipCellPainting );
   setBackgroundMode( PaletteBase );
   setFrameStyle( QFrame::WinPanel|QFrame::Sunken );
   setFocusPolicy(StrongFocus);

   rows = new QList<ChanListEntry>();
   setAutoUpdate(true);

   a = new QAccel( this );
   a->connectItem( a->insertItem( Key_Up+CTRL ), this, SLOT(slotCTRLKeyUp()) );
   a = new QAccel( this );
   a->connectItem( a->insertItem( Key_Down+CTRL ), this, SLOT(slotCTRLKeyDown()) );
   a = new QAccel( this );
   a->connectItem( a->insertItem( Key_M+ALT ), this, SLOT(slotLastChannel()) );

   change_chan = false;
   akt_row = -1;

   // Tooltip erzeugen. QObject sorgt fuers Enfernen aus dem Speicher, wenn
   // die ChanList-Klasse entfernt wird.
   new ChanListToolTip( this );

   setFixedSize( useWidth(), useHeight() );
}
//---------------------------------------------------------------------------
ChanList::~ChanList()
{
   delete rows;
}
//---------------------------------------------------------------------------
void ChanList::paintCell( QPainter *p, int row, int col )
{
	int w = cellWidth( col );			// width of cell in pixels
	int h = cellHeight( row );			// height of cell in pixels
	int x2 = w - 1;
	int y2 = h - 1;
	ChanListEntry *chlist;
	QFont f(font);


	// Wenn dies nicht die letzte Zeile ist, wird die untere Trennlinie
   // zwischen den Zeilen gezeichnet.
	if (row != (int)rows->count()-1)
   {
   	p->setPen( colorGroup().foreground() );
      p->setBrush( colorGroup().background() );
		p->drawLine( 0, y2, x2, y2 );
	}


	// Ist diese Zeile aktuell, wird der Rahmen gezeichnet
   if (row == akt_row)
   {
   	p->setBrush( colorGroup().highlight() );
      p->setPen( colorGroup().highlight() );
      p->drawRect( 0, 0, x2+1, y2 );
      p->setPen( colorGroup().highlightedText() );
   }
   else
   {
   	p->setBrush( colorGroup().background() );
      p->setPen( colorGroup().foreground() );
   }

	chlist = rows->at(row);

	chlist->paintCell( p, f, col, w, h );
}
//---------------------------------------------------------------------------
int ChanList::cellWidth( int cell )
{
   switch (cell)
   {
      case 0: return WIDTH_0;
      case 1: return WIDTH_1;
      case 2: return WIDTH_2;
      case 3: return WIDTH_3;
      case 4: return WIDTH_4;
   }
   return 0;
}
//---------------------------------------------------------------------------
void ChanList::addLine( Channel *chan, const QString & call, const QString & mycall, int itype, bool incoming )
{
	QString type;
   ChanListEntry *entry;

   switch (itype)
   {
      case -1: type = "????"; break;
      case TYPE_TERMINAL: type = "TERM"; break;
      case TYPE_MAILBOX: type = "BBS"; break;
      case TYPE_DIGI: type = "DIGI"; break;
      case TYPE_CONVERS: type = "CONV"; break;
   }

   entry = new ChanListEntry( chan, call, mycall, type, incoming );
   rows->append( entry );
   setNumRows( rows->count() );

	setFixedSize( useWidth(), useHeight() );
	toplevel->setMainwinSize();
}
//---------------------------------------------------------------------------
void ChanList::delLine( Channel *chan )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         rows->remove();
         setNumRows( rows->count() );
         update();
         setFixedSize( useWidth(), useHeight() );
         toplevel->setMainwinSize();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
int ChanList::useWidth()
{
   return WIDTH_0+WIDTH_1+WIDTH_2+WIDTH_3+WIDTH_4;
}
//---------------------------------------------------------------------------
int ChanList::useHeight()
{
   int count = rows->count();
   int height;

//   if (count > 5) count = 5;
   height = cellHeight() * count;

   if (height == 0) height = 1;

   if (height > 1) height += 4;

   return height;
}
//---------------------------------------------------------------------------
/*
 *  void ChanList::changeType( QWidget *chan, int newtype )
 * Bei einer Station hat jemand den Typen geaendert
 */
void ChanList::changeType( QWidget *chan, int newtype )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         entry->setType( newtype );
         update();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
/*
 *  void ChanList::changeCall( QWidget *chan, const QString & newcall )
 * Bei einer Station hat jemand den Typen geaendert
 */
void ChanList::changeCall( QWidget *chan, const QString & newcall )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         entry->setCall( newcall );
         update();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
/*
 *  void ChanList::changeCallAndType( QWidget *chan, const QString & newcall, int newtype )
 * Bei einer Station hat jemand den Typen geaendert
 */
void ChanList::changeCallAndType( QWidget *chan, const QString & newcall, int newtype )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         entry->setCall( newcall );
         entry->setType( newtype );
         update();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
void ChanList::setNew( QWidget *chan, bool neu )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         if (entry->setNew( neu ))
            update();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
void ChanList::setMode( QWidget *chan, int mode )
{
   ChanListEntry *entry = rows->first();

   while (entry != NULL)
   {
      if (entry->chan == chan)
      {
         entry->setMode( mode );
         update();
         return;
      }
      entry = rows->next();
   }
}
//---------------------------------------------------------------------------
void ChanList::mousePressEvent( QMouseEvent* e )
{
   int clickedRow;
   QWidget *win,*akt;


   QTableView::mousePressEvent(e);

   QPoint clickedPos = e->pos();
   clickedRow = findRow( clickedPos.y() );

   if (clickedRow == -1) return;
   win = rows->at(clickedRow)->chan;

   if (e->button() == RightButton)
   {
      // Das Kontext-Menue auch hier anzeigen
      ((Channel *)win)->showKontextMenu();
      return;
   }

   if (toplevel->currentChannel)
     (* toplevel->lastWinPos)=toplevel->currentChannel->pos();
   akt = toplevel->currentChannel;
   toplevel->activateChannel(win, akt, true);
}
//---------------------------------------------------------------------------
void ChanList::slotCTRLKeyUp()
{
   switchChannel(SWITCH_UP);
}
//---------------------------------------------------------------------------
void ChanList::slotCTRLKeyDown()
{
   switchChannel(SWITCH_DOWN);
}
//---------------------------------------------------------------------------
void ChanList::switchChannel(int sw)
{
   ChanListEntry *tmp;
   bool found=false, carry=false;
 
   if (rows->count() == 0) return;

   if (!change_chan)
   {
      // Erster Switch
     if (toplevel->currentChannel)
       (* toplevel->lastWinPos)=toplevel->currentChannel->pos();
      // Den aktuellen Kanal verstecken
      if (conf->getFlag(CFG_HIDEWINSWITCH))
         if (toplevel->currentChannel != NULL)
            toplevel->currentChannel->hide();

      change_chan = true;

      tmp = rows->first();
      while ((tmp != NULL) && !found)
      {
         if (tmp->chan == toplevel->currentChannel)
         {
            found = true;
            akt_row = rows->at();
            if (!rowIsVisible(akt_row))
               setTopCell(akt_row);
         }
         else tmp = rows->next();
      }
      if (!found)
      {
         // Wir fangen ganz oben an
         akt_row = 0;
         setTopCell(0);
      }

      KWin::setActiveWindow( toplevel->winId() );
      setFocus();
      update();
      return;
   }

   switch (sw)
   {
      case SWITCH_UP:
//           if (akt_row <= 0) return;
           akt_row--;
           if (akt_row < 0)
           {
              akt_row = (int)rows->count()-1;
              carry = true;
           }
           if (!rowIsVisible(akt_row))
              setTopCell(topCell()-1);
           updateRow( akt_row );
           if (carry)
              updateRow( 0 );
           else
              updateRow( akt_row+1 );
           break;
      case SWITCH_DOWN:
//           if (akt_row >= (int)rows->count()-1) return;
           akt_row++;
           if (akt_row > (int)rows->count()-1)
           {
              akt_row = 0;
              carry = true;
           }
           if (!rowIsVisible(akt_row))
              setTopCell(topCell()+1);
           updateRow( akt_row );
           if (carry)
              updateRow( (int)rows->count()-1 );
           else
              updateRow( akt_row-1 );
           break;
   }
}
//---------------------------------------------------------------------------
void ChanList::updateRow( int row )
{
   for (int i=0; i<5 ; i++)
      updateCell(row, i, true);
}
//---------------------------------------------------------------------------
void ChanList::keyReleaseEvent( QKeyEvent *e )
{

   if (change_chan){
      if (e->key() == Key_Control)
      {
         change_chan = false;
         update();
         toplevel->activateChannel(rows->at(akt_row)->chan, NULL, true);
         akt_row = -1;
      }
   }

   e->ignore();
}
//---------------------------------------------------------------------------
void ChanList::keyPressEvent( QKeyEvent *e)
{
   if (((e->state() & ControlButton) == 0) && (e->key() >= Key_F1) && (e->key() <= Key_F10))
   {
      emit signalFunctionKey(e->key()-Key_F1);
      e->accept();
      return;
   }
}
//---------------------------------------------------------------------------
void ChanList::auswahlLoeschen()
{
   if (change_chan)
   {
      change_chan = false;
      update();
      akt_row = -1;
   }
}
//---------------------------------------------------------------------------
void ChanList::activateWindow()
{
	KWin::setActiveWindow( toplevel->winId() );
   toplevel->setFocus();
}
//---------------------------------------------------------------------------
void ChanList::slotLastChannel()
{
   if (toplevel->currentChannel == NULL) return;

	KWin::setActiveWindow( toplevel->currentChannel->winId() );
   toplevel->currentChannel->setFocus();
   toplevel->currentChannel->show();
}
//---------------------------------------------------------------------------
ChanListEntry * ChanList::getEntry( const int y, QRect & rect )
{
	ChanListEntry *entry;
   int row = findRow( y ), ypos;


   if (row == -1) return NULL;

	if (!rowYPos( row, &ypos )) return NULL;

   entry = rows->at( row );
   if (entry == NULL)
   	return NULL;

	rect.setRect( 0, ypos, WIDTH_ALL, cellHeight() );

 	return entry;
}
//---------------------------------------------------------------------------

