/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "channel.h"

#include <qfiledialog.h>
#include "settingsdlg.h"      // TODO: remove
#include "settings.h"
#include "toolbox.h"
#include "global.h"
#include "version.h"
#include "main.h"
#include "comp.h"
#include "filetrans.h"
#include "../config.h"
#include "channel.moc"
#include "queuelist.h"
#include "yapp.h"
#include "ahuf.h"
#include "gpg.h"
#include "didadit.h"
#include "infobar.h"
#include "pathcheck.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <sys/socket.h>

#ifdef HAVE_BROKEN_AX25_H
#include "local_ax25.h"
#include <netrose/rose.h>
#elif HAVE_NETAX25_AX25_H
#include <netax25/ax25.h>
#include <netrose/rose.h>
#else
#include <linux/ax25.h>
#include <linux/rose.h>
#endif

#include <kiconloader.h>
#include <kapp.h>
#include <kwin.h>
#include <X11/Xlib.h>
#include <kstddirs.h>
#include <ktoolbarbutton.h>

#include <qclipboard.h>
#include <qnamespace.h>
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtextstream.h>
//---------------------------------------------------------------------------
#define SOL_AX25 257
//---------------------------------------------------------------------------
extern TopLevel *toplevel;
extern KApplication *mykapp;
//---------------------------------------------------------------------------
s_colors colors[17] = {{Qt::black, 			"black"},
							  {Qt::white, 			"white"},
							  {Qt::darkGray, 		"dark gray"},
							  {Qt::gray, 			"gray"},
							  {Qt::lightGray,		"light gray"},
							  {Qt::red, 			"red"},
							  {Qt::green, 			"green"},
                       {Qt::blue, 			"blue"},
                       {Qt::cyan, 			"cyan"},
                       {Qt::magenta, 		"magenta"},
                       {Qt::yellow, 		"yellow"},
                       {Qt::darkRed, 		"dark red"},
                       {Qt::darkGreen, 	"dark green"},
                       {Qt::darkBlue, 		"dark blue"},
                       {Qt::darkCyan, 		"dark cyan"},
                       {Qt::darkMagenta,	"dark magenta"},
                       {Qt::darkYellow,	"dark yellow"}};
//---------------------------------------------------------------------------
// System-Meldungen
static char conn_str[] = "\r*** (%1) CONNECTED to %2 [%3]\r";
static char disc_str[] = "\r*** (%1) DISCONNECTED fm %2 [%3]\r";
static char failed_str[] = "\r*** (%1) CONNECTION to %2 FAILED [%3]\r";
static char timeout_str[] = "\r*** (%1) CONNECTION to %2 TIMED OUT [%3]\r";
//---------------------------------------------------------------------------
// Gruende, weshalb ein Verbindungsaufbau abgrebrochen werden kann
#define FAILED_TIMEOUT 1
#define FAILED_FAILED 2
//---------------------------------------------------------------------------
s_swtype swType[SW_ANZ] = {{SW_UNKNOWN, "Unknown"},
                           {SW_AWZNODE, "AWZNode"},
                           {SW_BAYBOX,  "BayBox"},
                           {SW_DPBOX,   "DPBOX"},
                           {SW_FBB,     "FBB"},
                           {SW_FLEXNET, "FlexNet"},
                           {SW_GP85,    "GP85"},
                           {SW_LINKT,   "LinKT"},
                           {SW_MCUT,    "MCuT"},
                           {SW_PAXON,   "Paxon"},
                           {SW_THEBOX,  "TheBox"},
                           {SW_TNN,     "TNN"},
                           {SW_WINGT,   "WinGT"},
                           {SW_WINSTOP, "WinSTOP"},
                           {SW_XNET,    "XNET"},
                           {SW_XPACKET, "XPacket"}};
//---------------------------------------------------------------------------
//  Konstruktor fuer die Klasse Channel.
// Hier wird das zu diese Kanal gehoerende Fenster aufgebaut, alle
// Kernel-AX.25-Geschichten erledigt etc.
Channel::Channel( char *port, char *mycall, char *call, char *digis, int fd, bool connected )
           : KTMainWindow( "abcde" )
{
   int idle=0;
   bool ansi;
   int screenwidth;
   QValueList<int> qvl;


   centralWidget = new QWidget( this );
   centralVBox = new QVBoxLayout( centralWidget );

   // Variablen initialisieren
   transferDlg = NULL;
   save_text = NULL;
   save_text_len = 0;
   save_text_showed = 0;
   len_already_showed = 0;
   typeCheckLine = 0;
   bytesRX = 0;
   bytesTX = 0;
   closeWinDisc = false;
   flags = CH_STDFLAGS;


   sendQueue = new SendQueue( this );

	// Anhand des Portnamens suchen wir den richtigen Maxframe-Wert 'raus
   maxframe = getMaxframe(port);

   setupToolbar();


	infobar = new InfoBar( centralWidget );
   infobar->setFixedHeight( 20 );
   centralVBox->addWidget( infobar );


   if (connected)
   {
      old_status = 4;
   	infobar->setStat( old_status );
   }
   else
   {
      old_status = 1;
   	infobar->setStat( old_status );
   }

   // Variablen besetzen
   data_firstcall = call;
   data_call = call;
   data_mycall = mycall;
   data_logintime = time(NULL);
   data_port = port;
   data_digis = digis;

   // Ueberschrift des Fensters setzen
	setCaption();

   framesize = 255;

   // User-Informationen
   userinfo = new UserInfo( data_call );
	infobar->setName( userinfo->getName() );


   panner = new QSplitter( QSplitter::Vertical, centralWidget);
   centralVBox->addWidget( panner, 1 );

   // ANSI-Codes erlaubt?
   if (conf->getFlag( CFG_ALLOWANSI ))
   	ansi = true;
 	else
   	if (userinfo->getFlags() & CH_ALLOWANSI)
      	ansi = true;
		else
      	ansi = false;


	// Vorschreib- und Outupt-Widget
   if (conf->getFlag( CFG_TXWINOBEN ))
	{
		vorschreib = new myVorschreib( toplevel->chanListTable, this, panner );
		output = new OutputWidget( panner );
      qvl << conf->getTxWinSize()*10 << 1000-conf->getTxWinSize()*10;
	}
   else
   {
		output = new OutputWidget( panner );
		vorschreib = new myVorschreib( toplevel->chanListTable, this, panner );
      qvl << 1000-conf->getTxWinSize()*10 << conf->getTxWinSize()*10;
   }
   panner->setSizes( qvl );

	// Drops ins Output-Widget erlauben
	setAcceptDrops( true );


   vorschreib->setFont ( conf->txFont() );
   vorschreib->setColors( colors[conf->getColor(CFG_COLOR_TXWIN)].color, colors[conf->getColor(CFG_COLOR_BG)].color );
   vorschreib->setBackgroundColor( colors[conf->getColor(CFG_COLOR_TXWINBG)].color );
   vorschreib->setFocus();

   output->setFont( conf->qsoFont() );
   output->setBackgroundColor( colors[conf->getColor(CFG_COLOR_BG)].color );
   updateColors();
   connect( output, SIGNAL(kontextMenu()), SLOT(showKontextMenu()) );
   connect( vorschreib, SIGNAL(returnPressed()), SLOT(returnPressedGot()) );
   connect( vorschreib, SIGNAL(signalPageUp()), output, SLOT(slotPageUp()) );
   connect( vorschreib, SIGNAL(signalPageDown()), output, SLOT(slotPageDown()) );
   connect( vorschreib, SIGNAL(signalFunctionKey(int)), toplevel, SLOT(slotCallKey(int)) );
   connect( vorschreib, SIGNAL(kontextMenu()), SLOT(showKontextVorschrMenu()) );
   connect( vorschreib, SIGNAL(signalCTRLUp()), toplevel, SLOT(slotCTRLUp()) );
   connect( vorschreib, SIGNAL(signalCTRLDown()), toplevel, SLOT(slotCTRLDown()) );


   // Die Spaltenbreite auf 80 * die Breite des Zeichens 'm' einstellen
   QFontMetrics fm( conf->qsoFont() );
   screenwidth = 84 * fm.width("m");
   if (!(conf->getTbarFlg() & BARFLG_SHOW))
		resize( screenwidth, (int)(screenwidth * 0.6) );
   else
   {
	   if (toolbar->barPos() == KToolBar::Top || toolbar->barPos() == KToolBar::Bottom)
		   resize( screenwidth, (int)(screenwidth * 0.65)+45/*toolbar->height()*/ );
	   else
		   resize( screenwidth+45/*toolbar->width()*/, (int)(screenwidth * 0.65) );
	}


   // Verbindungs-Kommunikation
   txfd = fd;
   sockrx = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sockrx, SIGNAL(activated(int)), this, SLOT(rxFrame(int)) );

   // IDLE-Disconnect abschalten
   setsockopt( fd, SOL_AX25, AX25_IDLE, &idle, sizeof(idle) );

   // Shortcuts fuer diverse Befehle erzeugen
   accels = new QList<QAccel>();

   QAccel *a;
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_C+ALT ), this, SLOT(newConnect()) );
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_D+ALT ), this, SLOT(discStation()) );
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_S+ALT ), this, SLOT(settings()) );
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_T+ALT ), this, SLOT(slotSaveText()) );
   // Passwort mit ALT-P aussenden
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_P+ALT ), this, SLOT(slotSendPW()) );
   // Away-Dialog mit ALT-A
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_A+ALT ), this, SLOT(slotAway()) );
   // Mit der Menue-Taste wird das Kontextmenu angezeigt
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_Menu ), this, SLOT(showKontextMenu()) );
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_M+ALT ), toplevel->chanListTable, SLOT(activateWindow()) );
   // Mit CTRL-B oder CTRL-C kann die Check-Liste dieses Kanals in den Vordergrund geholt werden
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_B+CTRL ), this, SLOT(activateCheckWin()) );
   a->connectItem( a->insertItem( Key_C+CTRL ), this, SLOT(activateCheckWin()) );
   // Mit ALT-H kann die TOP-Online-Komprimierung (#HUF# aktiviert werden)
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_H+ALT ), this, SLOT(slotHufComp()) );
   // Mit CTRL-Y kann ein YAPP-File ausgesendet oder empfangen werden
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_Y+CTRL ), this, SLOT(slotYAPP()) );
   // Mit CTRL-W wird der WhatsThis-Modus aktiviert
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_W+CTRL ), this, SLOT(slotWhatsThis()) );
   a = new QAccel( this );
   accels->append(a);
   a->connectItem( a->insertItem( Key_G+ALT ), this, SLOT(slotSendGPG()) );

   // Kontextmenue erstellen
   kontextmenu = new QPopupMenu();
   kontextmenu->insertItem( QIconSet(BarIcon("linkt_mini_connect")), i18n("&Connect"), this, SLOT(newConnect()));
   kontextmenu->insertItem( QIconSet(BarIcon("linkt_mini_disconnect")), i18n("&Disconnect"), this, SLOT(discStation()));
   kontextmenu->insertSeparator( -1 );
   kontextmenu->insertItem( QIconSet(BarIcon("linkt_mini_settings")), i18n("&Settings"), this, SLOT(settings()));
   kontextmenu->insertSeparator( -1 );
   kontextmenu->insertItem( i18n("Send &File"), this, SLOT(slotBtnFileSend()));
   mnu_gpg_1 = kontextmenu->insertItem( i18n("Send public &key"), this, SLOT(slotBtnKeySend()));
   kontextmenu->setItemEnabled( mnu_gpg_1, conf->getFlag(CFG_GPGSUPPORT) );
   kontextmenu->insertItem( i18n("Send queue"), this, SLOT(slotShowSendQueue()));
   mnu_textfile = kontextmenu->insertItem( i18n("Save &Textfile"), this, SLOT(slotSaveText()));
   kontextmenu->insertSeparator( -1 );
   mnu_boxcheck = kontextmenu->insertItem( i18n("&BoxCheck"), this, SLOT(activateCheckWin()));
   kontextmenu->setItemEnabled( mnu_boxcheck, false );

   // Kontextmenue fuer die rechte Maustaste im Vorschreib-Fenster erstellen
   kontextvorschr = new QPopupMenu();
   kontextvorschr->insertItem( i18n("&Send quoted"), this, SLOT(slotSendQuoted()));
   kontextvorschr->insertItem( i18n("&Insert quoted"), this, SLOT(slotInsertQuoted()));
   kontextvorschr->insertItem( i18n("&Send unquoted"), this, SLOT(slotSendUnquoted()));

   // Remote-Geschichten
   remote = new RemoteCmds( this );

   // Die Passwort-Verarbeitung
   password = new Passwords( this );

   // Das BoxCheck-Zeugs
   boxcheck = new BoxCheckWin( this );

   boxcheck->readData( userinfo->getBoxCheck().latin1() );

   // TOP-Huffman
   ahuf = new AHUF();

   // Connect-Pfad
   connectPath = new ConnectPathCheck();
   connectPath->add( call );

   // Die QSO-Liste im Hauptfenster
   toplevel->chanListTable->addLine( this, call, mycall, userinfo->getType(), connected );
   toplevel->setMainwinSize();

   if (!connected)
      toplevel->chanListTable->setMode( this, MODE_SETUP );


   // Binaer- und 7plus-Transfers initialisieren
   auto7 = new auto7plus( this );
   binrx = new BinRX( this );
   didadit = NULL;
   yapp = NULL;
   gpg = new CheckGPG( this );

   if (connected)
   {
      // eine connect-Meldung aussenden
      showConnectMessage( port, call, digis );

      // den Connect-Text aussenden
      sendCText();
      // Bimmeln (ankommende Verbindung)
      toplevel->playSound( SOUND_CONN_IN );
   }


   if (conf->getFlag(CFG_HIDEWINSWITCH))
   {
   }

	setView( centralWidget );

   // QWhatsThis-Texte setzen
   QWhatsThis::add( vorschreib, i18n("Just type the text you want to send and press <i>enter</i>.") );
   QWhatsThis::add( output, i18n("This is the <b>QSO Window</b>. All text received and sent will be displayed here.") );

   // Connect-Icon
   QWhatsThis::add( toolbar->getWidget(1), i18n("Press this button to initiate a <b>new connecton</b>.") );


	if (conf->getFlag(CFG_OPENCHANWIN) || !connected)
	{
		show();
		if (conf->getFlag(CFG_HIDEWINSWITCH) && (toplevel->lastWinPos != NULL))
			XMoveWindow(x11Display(), winId(), toplevel->lastWinPos->x(), toplevel->lastWinPos->y() );
	}
}
//---------------------------------------------------------------------------
void Channel::makeNewConnect( char *port, char *mycall, char *call, char *digis, int fd )
{
   int idle=0;

	// Anhand des Portnamens suchen wir den richtigen Maxframe-Wert 'raus
   maxframe = getMaxframe(port);

   // Variablen initialisieren
   transferDlg = NULL;
   save_text = NULL;
   save_text_len = 0;
   save_text_showed = 0;
   len_already_showed = 0;
   typeCheckLine = 0;
   bytesRX = 0;
   bytesTX = 0;
   closeWinDisc = false;
   flags = CH_STDFLAGS;


   // Status aktualisieren
   old_status = 1;
	infobar->setStat( old_status );


   // Variablen besetzen
   data_firstcall = call;
   data_call = call;
   data_mycall = mycall;
   data_logintime = time(NULL);
   data_port = port;
   data_digis = digis;

   // Fenster-Ueberschrift setzen
	setCaption();

   framesize = 255;


   // Verbindungs-Kommunikation
   txfd = fd;
   sockrx = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sockrx, SIGNAL(activated(int)), this, SLOT(rxFrame(int)) );

   // IDLE-Disconnect abschalten
   setsockopt( fd, SOL_AX25, AX25_IDLE, &idle, sizeof(idle) );


   // User-Informationen
   userinfo = new UserInfo( data_call );
   boxcheck->readData( userinfo->getBoxCheck().latin1() );
	infobar->setName( userinfo->getName() );

   // Die Passwort-Verarbeitung
   delete password;
   password = new Passwords( this );



   // Die QSO-Liste im Hauptfenster
   toplevel->chanListTable->delLine( this );
   toplevel->chanListTable->addLine( this, call, mycall, userinfo->getType(), false );
   toplevel->setMainwinSize();
   toplevel->chanListTable->setMode( this, MODE_SETUP );


   // Binaer- und 7plus-Transfers initialisieren
   auto7 = new auto7plus( this );
   binrx = new BinRX( this );
   didadit = NULL;

   connectPath->clear();
   connectPath->add( call );
}
//---------------------------------------------------------------------------
//   void Channel::updateWindowPos()
//
// Die Position der Fenster (QSO- und Vorschreib) sind vertauscht worden.
void Channel::updateWindowPos()
{
	if (conf->getFlag(CFG_TXWINOBEN))
		panner->moveToFirst( vorschreib );
	else
		panner->moveToFirst( output );
}
//---------------------------------------------------------------------------
Channel::~Channel()
{
	// Connect-Pfad loeschen
   delete connectPath;

   // Sendqueue leeren
	delete sendQueue;


   // In dieser Klasse gespeicherte Daten wieder freigeben

   // Dateiuebertragungen abbrechen
   if (didadit != NULL) delete didadit;
   if (auto7 != NULL) delete auto7;
   if (binrx != NULL) delete binrx;
   if (yapp != NULL) delete yapp;


   // QSO aus der QSO-Liste des Hauptfensters entfernen
   toplevel->chanListTable->delLine( this );
   toplevel->setMainwinSize();

   // Widgets
   delete output;
   delete vorschreib;
   delete panner;
   delete kontextmenu;

   if (save_text != NULL) free(save_text);


   // Sonstige Klassen
   delete accels;       // Speicher fuer die Tastatur-Kuerzel freigeben
   delete userinfo;
   delete remote;
   delete ahuf;
   delete password;
   delete boxcheck;
}
//---------------------------------------------------------------------------
void Channel::setupToolbar()
{
   QPopupMenu *menu;
	KToolBarButton *btn;


   toolbar = new KToolBar( this );
	toolbar->applySettings( KGlobal::config(), "ToolBar" );

   toolbar->insertButton( BarIcon("linkt_connect"), 1, SIGNAL(clicked()), this,
   			SLOT(newConnect()), true, i18n("Connect") );

   toolbar->insertButton( BarIcon("linkt_disconnect"), 2, SIGNAL(clicked()), this,
   			SLOT(discStation()), true, i18n("Disconnect") );

	toolbar->insertLineSeparator();

   toolbar->insertButton( BarIcon("linkt_config"), 3, SIGNAL(clicked()), this,
   			SLOT(settings()), true, i18n("Settings") );

	toolbar->insertLineSeparator();

	toolbar->insertButton( BarIcon("linkt_transmit"), 4, SIGNAL(clicked()), this,
   			SLOT(slotBtnFileSend()), true, i18n("File-TX") );
   // Kontextmen fr AutoBIN, DIDADIT und Textfile
   menu = new QPopupMenu( toolbar );
   menu->insertItem( i18n("Send &AutoBIN"), this, SLOT(slotFilesendAutoBIN()));
   menu->insertItem( i18n("Send &DIDADIT"), this, SLOT(slotFilesendDIDADIT()));
   menu->insertItem( i18n("Send &Textfile"), this, SLOT(slotFilesendTextfile()));
   btn = toolbar->getButton( 4 );
   btn->setDelayedPopup( menu, true );

   toolbar->insertButton( BarIcon("linkt_receive"), 5, SIGNAL(clicked()), this,
   			SLOT(slotSaveText()), true, i18n("File-RX") );

	toolbar->insertLineSeparator();

   toolbar->insertButton( BarIcon("linkt_password"), 6, SIGNAL(clicked()), this,
   			SLOT(slotSendPW()), true, i18n("Password") );

	toolb_boxcheck = 7;
	toolbar->insertButton( BarIcon("linkt_boxcheck"), 7, SIGNAL(clicked()), this,
   			SLOT(activateCheckWin()), false, i18n("BoxCheck") );

	toolb_gpg = 8;
   toolbar->insertButton( BarIcon("linkt_gpg"), 8, SIGNAL(clicked()), this,
   			SLOT(slotSendGPG()), conf->getFlag(CFG_GPGSUPPORT),
   			i18n("GnuPG-TX") );


   addToolBar( toolbar );


//   connect( toolbar, SIGNAL(moved(BarPosition)), this, SLOT(slotToolbarMoved()) );
	connect( this, SIGNAL(toolBarPositionChanged(QToolBar *)), this, SLOT(slotToolbarMoved()) );
}
//---------------------------------------------------------------------------
//  void Channel::outText( char *text, int len, int color )
// Einen Text im RX-Fenster ausgeben.
void Channel::outText( const char *text, int len, int color )
{
   char *str,*tmp;
   int str_len,i;

   str = (char *) malloc( len+1 );
   tmp = (char *) malloc( len+1 );
   memcpy(str, text, len);
   str[len] = '\0';
   str_len = len;

   // Text im Hauptfenster in fett anzeigen
   if (!isActiveWindow())
      toplevel->chanListTable->setNew( this, true );

	for (i=0; i<len; i++)
   	if (str[i] == 0x00) str[i] = ' ';

   while ((str_len>0) && ((i = POS('\xD',str)) != -1))
   {
      memcpy(tmp,str,i);
      tmp[i] = '\0';
      memmove(str,str+i+1,str_len-i-1);
      str_len = str_len-i-1;
      str[str_len] = '\0';

      output->writeText(tmp, color);
      output->newLine();
   }

   if (str_len>0)
   {
      output->writeText(str, color);
   }

   free(tmp);
   free(str);
}
//---------------------------------------------------------------------------
//  void Channel::showConnectMessage(char *port, char *call, char *digis)
// Zeigt einen Text an, der z.B. wie folgt aussieht:
//   *** (23cm) CONNECTED to DG4IAD via DB0EA DB0HDB [Connect-Zeit]
void Channel::showConnectMessage( const QString & port, const QString & call, const QString & digis )
{
   struct tm sTm;
   QString sZeit, sMsg, sPath;

   sTm = *localtime( &data_logintime );

   sZeit.sprintf( "%.2i.%.2i.%.4i %.2i:%.2i",
         sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900, sTm.tm_hour,sTm.tm_min );

	if (digis.isEmpty())
   	sPath = call;
	else
   	sPath = call+" via "+digis;

	sMsg = QString(conn_str).arg(port).arg(sPath).arg(sZeit);

   outText( sMsg.latin1(), sMsg.length(), OUTCOLOR_STATUSTEXT );
}
//---------------------------------------------------------------------------
//  void Channel::showDisconnectMessage(char *port, char *call, char *digis)
// Zeigt einen Text an, der z.B. wie folgt aussieht:
//   *** (23cm) DISCONNECTED fm DG4IAD via DB0EA DB0HDB
void Channel::showDisconnectMessage( const QString & port, const QString & call, const QString & digis )
{
   struct tm sTm;
   QString sZeit, sMsg, sPath;
   time_t t;

   t = time( NULL );
   sTm = *localtime( &t );

   sZeit.sprintf( "%.2i.%.2i.%.4i %.2i:%.2i",
         sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900, sTm.tm_hour,sTm.tm_min );

	if (digis.isEmpty())
   	sPath = call;
	else
   	sPath = call+" via "+digis;

	sMsg = QString(disc_str).arg(port).arg(sPath).arg(sZeit);

   outText( sMsg.latin1(), sMsg.length(), OUTCOLOR_STATUSTEXT );
}
//---------------------------------------------------------------------------
void Channel::showConnFailedMessage( const QString & port, const QString & call, int reason )
{
   struct tm sTm;
   QString sZeit, sMsg, sReason;
   time_t t;


   t = time( NULL );
   sTm = *localtime( &t );

   sZeit.sprintf( "%.2i.%.2i.%.4i %.2i:%.2i",
         sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900, sTm.tm_hour,sTm.tm_min );

	switch (reason)
   {
   	case FAILED_TIMEOUT: sReason = timeout_str; break;
   	case FAILED_FAILED: sReason = failed_str; break;
   	default: sReason = failed_str;
   }

	sMsg = sReason.arg(port).arg(call).arg(sZeit);


   outText( sMsg.latin1(), sMsg.length(), OUTCOLOR_STATUSTEXT );
}
//---------------------------------------------------------------------------
//  void Channel::macroLine(  QString & makroString )
// Liest den String ein, und wandelt eventuell vorkommende Makros um.
void Channel::macroLine( QString & makroString )
{
	struct tm sTm;
	time_t akttime;
	int i=0, k;
	QString tmp;


	// Erstmal alle \n in \r umwandeln
	while ((k = makroString.find('\n')) != -1)
		makroString[k] = '\r';

	// Jetzt die Makros umwandeln
	while ((k = makroString.find('%', i)) != -1)
	{
		i = k;
		if ((int)makroString.length() < k+1)
		{
			makroString.truncate( makroString.length()-1 );
			return;
		}

		switch (makroString[k+1].latin1())
		{
	      case '%':
				makroString.insert( k+1, "%" );
				i += 2;
				break;
			case 'V': // Versions-Info mit Patchlevel
            makroString.remove( k, 2 );
				tmp.sprintf( "%i.%i.%i", MAJORLEVEL, MINORLEVEL, PATCHLEVEL);
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'v': // Versions-Info ohne Patchlevel
            makroString.remove( k, 2 );
				tmp.sprintf( "%i.%i", MAJORLEVEL, MINORLEVEL );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'n':	// Wenn der Name der Gegenstation bekannt ist, wird dieser
							// ausgesendet, ansonsten das Rufzeichen.
				tmp = userinfo->getName();
				if (tmp.isEmpty())
					tmp = data_call;
            makroString.remove( k, 2 );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'D': // Einlog-Datum
				sTm = *localtime(&data_logintime);
            makroString.remove( k, 2 );
				tmp.sprintf( "%.2i.%.2i.%.4i",sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900 );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'd': // Aktuelles Datum
				akttime = time(NULL);
				sTm = *localtime(&akttime);
            makroString.remove( k, 2 );
				tmp.sprintf( "%.2i.%.2i.%.4i",sTm.tm_mday,sTm.tm_mon+1,sTm.tm_year+1900 );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'T': // Einlog-Zeit
				sTm = *localtime(&data_logintime);
            makroString.remove( k, 2 );
				tmp.sprintf( "%.2i:%.2i:%.2i",sTm.tm_hour,sTm.tm_min,sTm.tm_sec );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'a': // Away-Zeit
				sTm = *localtime(&config->awayTime);
            makroString.remove( k, 2 );
				tmp.sprintf( "%.2i:%.2i:%.2i",sTm.tm_hour,sTm.tm_min,sTm.tm_sec );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 't': // aktuelle Zeit
				akttime = time(NULL);
				sTm = *localtime(&akttime);
            makroString.remove( k, 2 );
				tmp.sprintf( "%.2i:%.2i:%.2i",sTm.tm_hour,sTm.tm_min,sTm.tm_sec );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
			case 'm': // eigenes Call
            makroString.remove( k, 2 );
				makroString.insert( k, data_mycall );
				i += data_mycall.length();
				break;
			case 'c': // Call der Gegenstation
            makroString.remove( k, 2 );
				makroString.insert( k, data_call );
				i += data_call.length();
				break;
			case 'p': // Portname
            makroString.remove( k, 2 );
				makroString.insert( k, data_port );
				i += data_port.length();
				break;
			case 'o': // Cookie
			case 'O':
				getCookie( tmp );
            makroString.remove( k, 2 );
				makroString.insert( k, tmp );
				i += tmp.length();
				break;
		}
	}
}
//---------------------------------------------------------------------------
//  void Channel::sendMacrofile( char *filename )
// Wertet im uebergebenen File alle Makros aus und sendet es.
void Channel::sendMacrofile( const QString & filename )
{
	QFile f( filename );
   QString sSend;


   if (!f.open(IO_ReadOnly)) return;

   QTextStream t( &f );
   QString s;
   while (!t.eof())
   {
   	s = t.readLine();		// Zeile ohne \n einlesen
		macroLine( s );
      sSend += s + "\r";
      if (sSend.length() > 10000)
      {
      	sendString( sSend );
         sSend = "";
      }
   }

   f.close();

   if (sSend.length() > 0)
		sendString( sSend );
}
//---------------------------------------------------------------------------
//  void Channel::sendString(int len, char *data)
// Schickt diesen String aus (= traegt ihn in die Sendqueue ein)
void Channel::sendString(int len, const char *data, bool show)
{
   sendQueue->addString( data, len, COMP_FLAG, show );
}
//---------------------------------------------------------------------------
//  void Channel::sendStringNow( int len, char *data )
// Schickt diesen String JETZT aus (= traegt ihn ganz oben in die
// Sendqueue ein)
void Channel::sendStringNow( int len, const char *data, bool show )
{
   sendQueue->addString( data, len, COMP_FLAG, show );
}
//---------------------------------------------------------------------------
//   void Channel::sendStringComp(int len, const char *data, bool show, int comp)
//
// Sendet den String aus und setzt die comp-Variable auf den uebergebenen
// Wert
void Channel::sendStringComp(int len, const char *data, bool show, int comp)
{
   sendQueue->addString( data, len, comp, show );
}
//---------------------------------------------------------------------------
//  void Channel::sendString( char *data )
// Sendet einen null-terminierten String aus und zeigt ihn auf dem Bildschirm
// an.
void Channel::sendString( const char *data )
{
   sendString( strlen(data), data, true );
}
//---------------------------------------------------------------------------
void Channel::sendString( const QString & data, bool show )
{
	sendString( data.length(), data.latin1(), show );
}
//---------------------------------------------------------------------------
void Channel::sendMacroString( const QString & data, bool show )
{
	QString sMacro;

   sMacro = data;
   macroLine( sMacro );
	sendString( sMacro.length(), sMacro.latin1(), show );
}
//---------------------------------------------------------------------------
//  void Channel::sendTextFile( char *filename )
// Sendet eine Datei aus (traegt sie in die Sendqueue ein).
void Channel::sendTextFile( char *filename, bool show)
{
	sendQueue->addTextFile( filename, COMP_FLAG, show, -1 );
}
//---------------------------------------------------------------------------
//  void Channel::send_a_frame()
// Diese Funktion wird regelmaessig aufgerufen. Es wird
// geguckt, ob etwas zum Senden vorliegt.
void Channel::send_a_frame()
{
   char frame[500];
   const char *tmp;
   int len=255;
   bool show;
   int comp;


   tmp = sendQueue->getData( len, show, comp );
   if (tmp == NULL) return;

   memcpy(frame, tmp, len);

	// Sendet den Inhalt von sendstr aus.
	sendFrame( frame, len, comp );

	// Hier wird geguckt, ob der zu sendende Text angezeigt werden soll
	if (show)
	{
		frame[len] = '\0';
		outText( frame, len, OUTCOLOR_TXTEXT );
	}
}
//---------------------------------------------------------------------------
//   int Channel::pollStatus()
//
// Der Status dieses Kanals soll gepollt und zurueckgegeben werden. Hier
// wird nix laengerfristig gespeichert!
int Channel::pollStatus()
{
   ax25_info_struct axinfo;


   if (ioctl(txfd, SIOCAX25GETINFO, &axinfo) != -1)
   {
      switch (axinfo.state)
      {
         case 0:
         case 1: return axinfo.state;
         case 2: return 3;
         case 3: return 4;
         case 4: return 6;
         default: return 0;
      }
   }

   return 0;
}
//---------------------------------------------------------------------------
void Channel::sendFrame( char *str, int len, int comp )
{
   int count,newlen=0;
   bool is_huff;
   char buffer[FRAMESIZE+1];


	if (pollStatus() == 0) return;

   bytesTX += len;

   // Wenn dieses Frame Huffman gepackt sein soll, wird hier gewandelt.
   is_huff = false;
   if (comp != COMP_NO)
   {
      if (((flags & CH_COMP) > 0) || (comp == COMP_SP))
      {
         is_huff = true;
         if ((newlen = comp_stat_huff( str, len, buffer )) == 0)
            is_huff = false;
      }
      if (((flags & CH_HUF_TX) > 0) || (comp == COMP_HUF))
      {
         is_huff = true;
         if ((newlen = ahuf->Komprimieren( true, buffer, str, len )) == 0)
            is_huff = false;
      }
   }

   if (is_huff)
   {
      if ((count = write(txfd, buffer, newlen)) != newlen) send_error = true;
   }
   else
   {
      if ((count = write(txfd, str, len)) != len) send_error = true;
   }
}
//---------------------------------------------------------------------------
//   void Channel::rxFrame(int socket)
//
// Diese Funktion wird aufgerufen, wenn von unserer Verbindung Daten
// gekommen sind.
void Channel::rxFrame(int socket)
{
   char tmp[1000], output[1000];
   int len, tmplen;

   len = read(socket, tmp, 1000);

   if (len > 0)
   {
      if ((flags & CH_COMP) > 0)
      {
         if ((tmplen = decomp_stat_huff( tmp, len, output )) > 0)
         {
            len = tmplen;
            memcpy(tmp, output, len);
            tmp[len] = '\0';
         }
      }

      if ((flags & CH_HUF_RX) > 0)
      {
         if ((tmplen = ahuf->DeKomprimieren( output, tmp, len )) > 0)
         {
            len = tmplen;
            memcpy(tmp, output, len);
            tmp[len] = '\0';
         }
      }

      bytesRX += len;

      if (old_status == 1)
      {
         statusConnectGot();
         old_status = 4;
      }

      work_with_frame(tmp, len);
      return;
   }
}
//---------------------------------------------------------------------------
void Channel::checkPi1chlConnect(char *data)
{
   int i = POS(':', data);
   int j = POS('}', data);
   char tmp[100];
   int len;


   if (i == -1 || j == -1) return;
   if (i > j) return;

   if (strstr(data, "} Connected to ") == NULL) return;


   len = strlen(data)-j-15;
   memcpy(tmp, data+j+15, len);
   tmp[len] = '\0';

   if ((i = POS('\r', tmp)) > -1) tmp[i] = '\0';
   checkConnectedTo(tmp);
}
//---------------------------------------------------------------------------
void Channel::checkTNNConnect( const QString & data)
{
   int i;


   if ((i = data.find("> Connected to ")) == -1) return;

   checkConnectedTo( data.mid( i+15 ) );
}
//---------------------------------------------------------------------------
void Channel::checkTNNReconnect(char *data)
{
   int i = POS(':', data);
   int j = POS('>', data);
   char tmp[100];
   int len;

   if (i == -1 || j == -1) return;
   if (i > j) return;

   if (strstr(data, "> Reconnected to ") == NULL) return;


   len = strlen(data)-j-18;
   memcpy(tmp, data+j+17, len);
   tmp[len] = '\0';

   checkReconnectedTo( QString(tmp) );
}
//---------------------------------------------------------------------------
void Channel::work_with_frame(char *neu_str, int neu_str_len)
{
   char *tmp, *data, *str, tmp2[200];
   int datalen, i, str_len;
   bool linemode;
   QString qString;


   str = (char *) malloc(neu_str_len+1);
   memcpy(str,neu_str,neu_str_len);
   str_len = neu_str_len;
   str[str_len] = '\0';


  // Gucken, ob in save_text noch was gespeichert ist. Wenn ja, werden
  // diese Daten vor die empfangenen Daten gepackt.
  if (save_text_len != 0)
  {
    tmp = (char *) malloc( str_len+save_text_len+1 );
    memcpy(tmp,save_text,save_text_len);
    memcpy(tmp+save_text_len,str,str_len);
    str_len = str_len + save_text_len;
    free(str);
    str = tmp;
    str[str_len] = '\0';
    free(save_text);
    save_text = NULL;
    save_text_len = 0;
  }


  linemode = flags & CH_LINEMODE;
  while ((str_len > 0) && ((tmp = (char *)memchr(str, '\r', str_len)) != NULL || !linemode))
  {
    i = tmp-str;

    // linemode oder nicht?
    if (!linemode)
    {
      data = str;
      str = NULL;
      datalen = str_len;
      str_len = 0;
    }
    else
    {
      data = (char *) malloc(i+2);
      memcpy(data,str,i+1);
      data[i+1] = '\0';
      datalen = i+1;

      str_len = str_len - i-1;
      memmove(str,str+i+1,str_len);
      str[str_len] = '\0';
    }

    // Do something with data and datalen

    // Haben wir jemanden connected?
    if ((userinfo->getFlags() & CH_CHECKCONN) == CH_CHECKCONN)
    {
       if (!strncmp(data,"*** connected to",16) ||
           !strncmp(data,"*** Connected to",16))
       {
         COPY(tmp2,data,17,strlen(data)-17);
         KillSpacesLeft(tmp2);
         KillSpacesRight(tmp2);
         Gross(tmp2);
         i = strlen(tmp2)-1;
         if (tmp2[i] == '\r') tmp2[i] = '\0';

         checkConnectedTo(tmp2);
       }

       // PE1CHL-Digis
       checkPi1chlConnect( data );

       // TNN-Digis
       checkTNNConnect( data );
    }


    if ((userinfo->getFlags() & CH_CHECKDISC) == CH_CHECKDISC)
    {
       if (!strncmp(data,"*** reconnected to",18) ||
           !strncmp(data,"*** Reconnected to",18))
       {
         COPY(tmp2,data,19,strlen(data)-19);
         KillSpacesLeft(tmp2);
         KillSpacesRight(tmp2);
         Gross(tmp2);
         i = strlen(tmp2)-1;

         if (tmp2[i] == '\r') tmp2[i] = '\0';
         checkReconnectedTo( QString(tmp2) );
       }

       // TNN-Digis
       checkTNNReconnect(data);
    }


    ///////////////////////////////////////////////////////////////////////
    ////  Text auf dem Bildschirm ausgeben.                            ////
    if (datalen > len_already_showed)
	 {
       if (!binrx->isRxfile() &&
          !auto7->isRxfile() &&
          didadit == NULL &&
          yapp == NULL &&
          sendQueue->whichTransfer() != FTPROT_DIDADIT &&
          sendQueue->whichTransfer() != FTPROT_YAPP)
             outText( data+len_already_showed, datalen-len_already_showed, OUTCOLOR_RXTEXT );
       len_already_showed = 0;
    }
    ////  Ab hier koennen Funktionen aufgerufen werden, die etwas      ////
    ////  aussenden                                                    ////
    ///////////////////////////////////////////////////////////////////////

	 if (sendQueue->isTransferActive())
    {
 	    emit receivedString( data, datalen );
		 emit sendFileTXData();
	 }


	// Ist ein Dateitransfer im Gange?
	if ((!(flags & CH_DIDADIT)) &&
        (!(flags & CH_YAPP)) &&
        (!binrx->isRxfile()) &&
        (!sendQueue->isTransferActive()) &&
        (!auto7->isRxfile()))
	{
//      qString = data;

   	// Nein. GPG-Check
		gpg->proceed( data, datalen );

      // Wenn diese eine Mailbox ist, gehen die Daten auch an BoxCheck
		if (userinfo->getType() == TYPE_MAILBOX)
			boxcheck->proceed(data, datalen);

 		// Remote-Befehle?
		if ((userinfo->getFlags() & CH_REMOTE) != 0)
			if (!strncmp(data,"//",2))
				remote->checkLine( data+2 );

		// Passwort-Abfrage?
		password->proceed(data, datalen);

		// Wird #HUF# angefordert?
		if ((userinfo->getFlags() & CH_HUFALLOW) || (flags & CH_HUF_RX))
			checkForHUF(data, datalen);

		// Normales Textfile speichern
		if ((flags & CH_SAVE) == CH_SAVE)
		{
			write(filerx_fd, data, datalen-1);
			write(filerx_fd, "\n", 1);
		}
	}


    // Gucken, welche Software auf der Gegenseite laeuft, wenn dies noch
    // nicht erledigt wurde. (Maximal bis zur 20. Zeile.)
    if (typeCheckLine <= 20)
    {
       typeCheckLine++;
       if (!(flags & CH_TSIDTX))
          checkTerminalSID( data );
       if (!userinfo->getSwType())
          checkSwType( data );
    }


    // auto7plus-Zeugs
    if ((((userinfo->getFlags() & CH_CHECK7PLUS) == CH_CHECK7PLUS) ||
         (auto7->isRxfile())) &&
         (!binrx->isRxfile()) &&            // Nur 7plus wenn kein AutoBIN und
			(!sendQueue->isTransferActive()))
    {
       auto7->proceed( data, datalen );
    }


    // DIDADIT-Empfang
    // Muss vor dem DIDADIT Autosave stehen
    if ((flags & CH_DIDADIT) == CH_DIDADIT)
    {
       switch (didadit->proceed(data, datalen))
       {
          case 0: // Die Uebertragung ist fertig
                  flags &= ~CH_DIDADIT;
                  flags |= CH_LINEMODE;
                  delete didadit;
                  didadit = NULL;
                  break;
          case 1: // Abbruch, keine Didadit-Uebertragung
                  flags &= ~CH_DIDADIT;
                  flags |= CH_LINEMODE;
                  delete didadit;
                  didadit = NULL;
                  break;
          case 2: break;
       }
    }


    // AutoBIN RX
    if ((((userinfo->getFlags() & CH_CHECKAUTOBIN) == CH_CHECKAUTOBIN) ||
         (binrx->isRxfile())) &&
         (!sendQueue->isTransferActive()) &&
         (!auto7->isRxfile()) &&         // Nur AutoBIN, wenn kein 7plus
         ((flags & CH_DIDADIT) == 0))    // und kein DIDADIT
    {
       i = binrx->proceed( data, datalen );
       if (i != datalen && i != 0)
       {
          // Es wurden nicht alle Bytes "gebraucht". Die uebrigen
          // wieder an den str-String haengen
          tmp = (char *) malloc(datalen-i+str_len+1);
          memcpy(tmp,data+i,datalen-i);
          memcpy(tmp+datalen-i,str,str_len);
          str_len = str_len + datalen-i;
          tmp[str_len] = '\0';
          free(str);
          str = tmp;
       }
    }



    // DIDADIT - RX (Autosave)
    if (((userinfo->getFlags() & CH_CHECKDIDADIT) != 0) &&
         (!auto7->isRxfile()) &&          // Nur DIDADIT, wenn kein 7plus
         ((flags & CH_AUTOBINRX) == 0))  // und wenn kein AutoBIN empfangen wird.
    if (!strcmp(data,"#DIDADIT#\xD"))
    {
       didadit = new DIDADIT( this );
       flags |= CH_DIDADIT;
       flags &= ~CH_LINEMODE;
    }


    // YAPP-Transfer?
    if ((flags & CH_YAPP) == CH_YAPP)
    {
       if (yapp->proceed( data, datalen ))
       {
          delete yapp;
          yapp = NULL;
          flags |= CH_LINEMODE;
          flags &= ~CH_YAPP;
       }
    }


    linemode = (flags & CH_LINEMODE) == CH_LINEMODE;
    free(data);
    datalen = 0;
    data = NULL;
  }


  // Sind noch ein paar Daten in str enthalten? Wenn ja werden die jetzt nach
  // save_text gespeichert
  if (str_len > 0)
  {
    save_text = (char *) malloc(str_len);
    memcpy(save_text, str, str_len);
    save_text_len = str_len;

    free(str);
    str_len = 0;
    str = NULL;

    // Text ausgeben
    if (!auto7->isRxfile() &&
        !binrx->isRxfile())
          outText( save_text+len_already_showed, save_text_len-len_already_showed, OUTCOLOR_RXTEXT );
    len_already_showed = save_text_len;
  }

	if (str != NULL)
		free( str );
}
//---------------------------------------------------------------------------
void Channel::sendCText()
{
/*   char tmp2[500],tmp[1000],tmp3[500];
   int i;*/
   QString tmp, sAway;


   // Existiert im userdb-Verzeichnis ein File namens <call>.ctext? Wenn ja wird dieses als
   // ctext ausgesendet.
/*   COPY(tmp2,data_call,0,3);
   Klein(tmp2);
   strcpy(tmp3,data_call);
   Klein(tmp3);
   if ((i = POS('-', tmp3)) > -1)
      tmp3[i] = '\0';
   sprintf(tmp,"%s/userdb/%s.../%s.ctext", conf->localDir().latin1(),tmp2,tmp3);
*/
	tmp = conf->localDir()+"/userdb/"+data_call.lower().left(3)+".../"+data_call.lower()+".ctext";
   if (!file_exist(tmp.latin1()))
   	tmp = conf->localDir()+"/ctext";

   sendTerminalSID();

   sendMacrofile( tmp );

   // Away-Meldung, wenn jemand connected
   if (config->awayStatus != 0)
   {
   	sAway = conf->getAwayText(config->awayStatus);
		macroLine( sAway );

		tmp = "## SysOp is away: "+sAway+" ##\r";
      macroLine( tmp );
      sendString( tmp );
   }
}
//---------------------------------------------------------------------------
void Channel::returnPressedGot()
{	// TODO: Eventuell umbauen auf QString
   char text[500], zeichen;
   int len, src, dest;
   int line, col;


   // Die Daten fuer //ACTIVITY setzen
   config->lastactivity = time( NULL );


   vorschreib->cursorPosition(&line, &col);
   strncpy( text, vorschreib->textLine(line), 499 );

   KillSpacesRight(text);
   len = strlen(text);

   text[len] = '\xD';
   text[len+1] = '\0';

   // ^A bis ^Z in ASCII(0) bis ASCII(25) umwandeln
   src = 0;
   dest = 0;
   while (text[src] != '\0')
   {
      if (text[src] == '^')
      {
         src++;
         if (text[src] == '\0')
            text[dest] = text[src];
         else
         {
            zeichen = toupper(text[src]);
            if (zeichen >= 'A' && zeichen <= 'Z')
            {
               text[dest] = zeichen-'A'+1;
            }
            else
            {
               if (text[src] == '^')
                  text[dest] = '^';
            }
         }
      }
      else text[dest] = text[src];
      src++;
      dest++;
   }
   text[dest] = '\0';

   if ((flags & CH_AUTOBINTX) != 0)
   {
      if (conf->getFlag(CFG_LOCALECHO))
         insertBINChatLine( text, true );
      else
         insertBINChatLine( text, false );
      return;
   }

   if (conf->getFlag(CFG_LOCALECHO))
      sendString( strlen(text), text, true );
   else
      sendString( strlen(text), text, false );
}
//---------------------------------------------------------------------------
//  const char * Channel::getCall()
// Das Rufzeichen der Gegenstation auf diesem Kanal zurueckgeben
const QString & Channel::getCall()
{
   return data_call;
}
//---------------------------------------------------------------------------
//  char * Channel::getMycall()
// Das eigene Rufzeichen auf diesem Kanal zurueckgeben
const QString & Channel::getMycall()
{
   return data_mycall;
}
//---------------------------------------------------------------------------
const QString & Channel::getPort()
{
   return data_port;
}
//---------------------------------------------------------------------------
void Channel::setUnack(int value)
{
   infobar->setUnAck( value );
}
//---------------------------------------------------------------------------
void Channel::setSQueue(int value)
{
   char frame[500];
   const char *tmp;
   int len;
   bool show;
   int comp;
   int justsent = 0;


   infobar->setUnSent( value );
   squeue = value;

   // Wenn die Verbindung noch nicht steht, wird abgebrochen
   if (old_status < 2) return;		// <2 == weder DIS noch SET

   while (squeue+justsent < maxframe)
   {
	   len = framesize;
	   tmp = sendQueue->getData( len, show, comp );
	   if (tmp == NULL)
	   	return;

	   memcpy(frame, tmp, len);

		// Sendet den Inhalt von sendstr aus.
		sendFrame( frame, len, comp );

      justsent++;

		// Hier wird geguckt, ob der zu sendende Text angezeigt werden soll
		if (show)
		{
			frame[len] = '\0';
			outText( frame, len, OUTCOLOR_TXTEXT );
		}
   }
}
//---------------------------------------------------------------------------
void Channel::setTries(int value)
{
   infobar->setRetry( value );
}
//---------------------------------------------------------------------------
void Channel::statusConnectGot()
{
   data_logintime = time(NULL);

   // eine connect-Meldung aussenden
   showConnectMessage( data_port, data_call, data_digis );

   // QSO-Liste im Haupfenster
   if (!isActiveWindow())
      toplevel->chanListTable->setNew( this, true );
   toplevel->chanListTable->setMode( this, MODE_INFO );

   // Wenn das Passwort fuer diese Station automatisch beantwortet
   // werden soll, wird dies die ersten 20 Zeilen lang gemacht.
   if ((userinfo->getFlags() & CH_AUTOSEND_PW) != 0)
      password->activatePassword();
}
//---------------------------------------------------------------------------
void Channel::setStatus(int value)
{
	infobar->setStat( value );


   // Haben wir connected?
   if ((old_status == 1) && (value == 4))
   {
      statusConnectGot();
      // Bimmeln
      toplevel->playSound( SOUND_CONN_OUT );
   }

   // Verbindungsabbau
   if ((old_status > 1) && (value == 0))
   {
      if (!isActiveWindow())
         toplevel->chanListTable->setNew( this, true );

      // Wenn noch ein Transferfenster offen ist, wirds jetzt auch
      // geschlossen
      // TODO: Gucken, ob hier das Transfer-Info-Widget sichtbar ist. Wenn
      //       ja: entfernen
      auto7->closeTransferwin();

      // Kein Text darf mehr markiert sein
      output->clearAllMarks();

      showDisconnectMessage(data_port, data_call, data_digis);

      // Bimmeln
      toplevel->playSound( SOUND_CONN_CLOSED );

      if (sockrx != NULL)
      {
         delete sockrx;
         sockrx = NULL;
      }
      flags &= ~CH_DISC;
      toplevel->deleteChannelList( this );
      old_status = value;

      // Eventuell vorhanden Transfer-Fenster schliessen
      if (auto7 != NULL)
      {
         delete auto7;
         auto7 = NULL;
      }
      if (binrx != NULL)
      {
         delete binrx;
         binrx = NULL;
      }
      if (didadit != NULL)
      {
      	delete didadit;
         didadit = NULL;
      }

      if (conf->getFlag(CFG_CLOSEWINDISC)) close();
      if (txfd != -1)
      {
         ::close(txfd);
         txfd = -1;
      }
      // Die QSO-Liste im Hauptfenster
      toplevel->chanListTable->setMode( this, MODE_DISC );
      if (conf->getFlag(CFG_USELOG))
         logBookEntry();

      sendQueue->clear();
   }

   // Verbindungsaufbau gescheitert?
   if ((old_status == 1) && (value == 0))
   {
      if (!isActiveWindow())
         toplevel->chanListTable->setNew( this, true );

      // Kein Text darf mehr markiert sein
      output->clearAllMarks();

      showConnFailedMessage( data_port, data_call, FAILED_FAILED );

      // Bimmeln
      toplevel->playSound( SOUND_CONN_CLOSED );

      if (sockrx != NULL)
      {
         delete sockrx;
         sockrx = NULL;
      }
      flags &= ~CH_DISC;
      toplevel->deleteChannelList( this );
      old_status = value;

      // Eventuell vorhanden Transfer-Fenster schliessen
      if (auto7 != NULL)
      {
         delete auto7;
         auto7 = NULL;
      }
      if (binrx != NULL)
      {
         delete binrx;
         binrx = NULL;
      }

      if (conf->getFlag(CFG_CLOSEWINDISC)) close();
      if (txfd != -1)
      {
         ::close(txfd);
         txfd = -1;
      }
      // Die QSO-Liste im Hauptfenster
      toplevel->chanListTable->setMode( this, MODE_DISC );

      sendQueue->clear();
   }

   // Wenn wir im IXF-Status sind und CH_DISC aktiv ist, wird disconnected
   if (value == 4)
      if ((flags & CH_DISC) != 0)
         reallyDisconnect();

   old_status = value;
}
//---------------------------------------------------------------------------
void Channel::closeEvent(QCloseEvent *e)
{
   char text[100];

   if (old_status != 0)
   {
      sprintf(text, i18n("Do you really want to disconnect from %1?").arg(data_call));
      if (KMessageBox::questionYesNo( this, text,
      										i18n("Disconnect?")) != KMessageBox::Yes)
      {
         e->ignore();
         return;
      }

      // Sachen erledigen, die nur bei noch bestehenden Verbindungen erledigt
      // werden sollten.
      discStn();
      closeWinDisc = true;
      if (conf->getFlag(CFG_USELOG))
	      logBookEntry();
   }

   if (sendQueue->allSent() || old_status == 0)
      closeQSOWindow();
}
//---------------------------------------------------------------------------
//  void Channel::newConnect()
// Baut eine neue Verbindung auf.
void Channel::newConnect()
{
   toplevel->slotConnect();
}
//---------------------------------------------------------------------------
//  void Channel::discStation()
// Diese Verbindung soll disconnected werden.
void Channel::discStation()
{
   close();
}
//---------------------------------------------------------------------------
//   void Channel::discStn()
// Die Gegenstation soll Disconnected werden.
void Channel::discStn()
{
   if ((flags & CH_COMP) > 0)
      sendString("//COMP 0\r");

   if ((flags & CH_HUF_TX) > 0)
      sendString("#HUF:NO#\r");

   reallyDisconnect();
}
//---------------------------------------------------------------------------
//   void Channel::discStnAuto()
//
// Diese Verbindung wird von der Gegenstation oder von LinKT selbst beendet.
void Channel::discStnAuto()
{
   if ((flags & CH_COMP) > 0)
      sendString("//COMP 0\r");

   if ((flags & CH_HUF_TX) > 0)
      sendString("#HUF:NO#\r");

   if (sendQueue->allSent())
      reallyDisconnect();
   else
      flags |= CH_DISC;
}
//---------------------------------------------------------------------------
void Channel::reallyDisconnect()
{
   if (txfd != -1)
   {
      ::close(txfd);
      txfd = -1;
   }
}
//---------------------------------------------------------------------------
void Channel::closeQSOWindow()
{
	toplevel->chanListTable->activateWindow();
	toplevel->deleteChannelList( this );
	if (toplevel->currentChannel == this)
		toplevel->currentChannel = NULL;
	delete this;
}
//---------------------------------------------------------------------------
void Channel::settings()
{
	QDialog *dlg = new SettingsDlg(this);

	QPoint point = this->mapToGlobal (QPoint (0,0));

	QRect pos = this->geometry();
	dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
				point.y() + pos.height()/2 - dlg->height()/2,
				dlg->width(),dlg->height());

	dlg->exec();

	toplevel->chanListTable->changeType( this, userinfo->getType() );
	infobar->setName( userinfo->getName() );

	delete dlg;
}
//---------------------------------------------------------------------------
bool Channel::validCallsign(char */*call*/)
{
   return true;
}
//---------------------------------------------------------------------------
int Channel::getFlags()
{
   return flags;
}
//---------------------------------------------------------------------------
QWidget * Channel::getVorschreibPtr()
{
   return vorschreib;
}
//---------------------------------------------------------------------------
void Channel::showKontextMenu()
{
   kontextmenu->popup(QCursor::pos());
}
//---------------------------------------------------------------------------
void Channel::slotSaveText()
{
   char tmp[500];
   bool fileappend=false;


   if ((flags & CH_SAVE) == CH_SAVE)
   {
      ::close(filerx_fd);
      flags &= ~CH_SAVE;
      kontextmenu->changeItem(i18n("Save &Textfile"), mnu_textfile);
   }
   else
   {
      strcpy(tmp, conf->getDirDown());
      QString f = QFileDialog::getSaveFileName(tmp);

      strcpy(tmp, (const char *)f);

      // Cancel
      if (f.isEmpty()) return;

      if (file_exist(tmp))
      {
      	switch (KMessageBox::warningYesNoCancel(this,
								i18n("The file already exists. Do you want to overwrite or append to it?"),
								i18n("File exists"),
								i18n("&Overwrite"),
								i18n("&Append")))
			{
         	case 2:
         		return;
				case 4:
            	fileappend = true;
            	break;
         }
      }

      if (fileappend)
      {
      	// Append
	      if ((filerx_fd = open(tmp, O_WRONLY|O_APPEND)) == -1)
	      {
	         printf("%s\n",strerror(errno));
	         KMessageBox::error( this,
	         						i18n("Cannot create specified file!"));
	         return;
	      }
		}
      else
	      if ((filerx_fd = open(tmp, O_WRONLY|O_CREAT|O_TRUNC)) == -1)
	      {
	         printf("%s\n",strerror(errno));
	         KMessageBox::error( this,
										i18n("Cannot create specified file!"));
	         return;
	      }

      // Zugriffsrechte einstellen
      fchmod(filerx_fd,S_IRUSR|S_IWUSR);

      flags |= CH_SAVE;
      kontextmenu->changeItem(i18n("Close &Textfile-Save"), mnu_textfile);
   }
}
//---------------------------------------------------------------------------
int Channel::getTxfd()
{
   return txfd;
}
//---------------------------------------------------------------------------
//   void Channel::updateFontSizes(int qsosize, int txsize)
// Aendert die aktuelle Schriftgroesse auf diesem Kanal und setzt die
// Groesse des
void Channel::updateFont()
{
   int screenwidth;

   output->setFont( conf->qsoFont() );
   vorschreib->setFont ( conf->txFont() );

   // Die Farben ebenfalls updaten
   updateColors();

   // Die Spaltenbreite auf 80 * die Breite des Zeichens 'm' einstellen
   QFontMetrics fm( conf->qsoFont() );
   screenwidth = 84 * fm.width("m");
   if (!toolbar->isVisible())
		resize( screenwidth, (int)(screenwidth * 0.6) );
   else
   {
	   if (toolbar->barPos() == KToolBar::Top || toolbar->barPos() == KToolBar::Bottom)
		   resize( screenwidth, (int)(screenwidth * 0.65)+45/*toolbar->height()*/ );
	   else
		   resize( screenwidth+45/*toolbar->width()*/, (int)(screenwidth * 0.65) );
	}
}
//---------------------------------------------------------------------------
void Channel::slotSendPW()
{
   password->transmit();
}
//---------------------------------------------------------------------------
// Gucken, ob wir zu diesem Rufzeichen connecten koennen
//
// Eventuell steht in call "NODE:DA1BCD-7" drin.
void Channel::checkConnectedTo( const QString & rxcall )
{
	QString call;
   int i;


   call = rxcall;
   if ((i = call.find(':')) != -1)
   	call.remove( 0, i+1 );
	if ((i = call.find('\r')) != -1)
   	call.truncate( i );

	data_call = call;

	delete userinfo;
	userinfo = new UserInfo( data_call );
	boxcheck->readData( userinfo->getBoxCheck().latin1() );
	infobar->setName( userinfo->getName() );
	kontextmenu->setItemEnabled( mnu_boxcheck, false );
	toolbar->setItemEnabled( toolb_boxcheck, false );

	// Fenster-Ueberschrift
   setCaption();

	// Im Hauptfenster Rufzeichen und Typen updaten
	toplevel->chanListTable->changeCallAndType( this, data_call, userinfo->getType() );

	// Wenn das Passwort fuer diese Station automatisch beantwortet
	// werden soll, wird dies die ersten 20 Zeilen lang gemacht.
	if ((userinfo->getFlags() & CH_AUTOSEND_PW) != 0)
		password->activatePassword();

	connectPath->add( data_call );
	typeCheckLine = 0;
	flags &= ~CH_TSIDTX;
}
//---------------------------------------------------------------------------
// Gucken, ob wir zu diesem Rufzeichen reconnected werden koennen
void Channel::checkReconnectedTo( const QString & rxcall )
{
	QString call;
   int i;

   call = rxcall;
   if ((i = call.find(':')) != -1)
   	call.mid( i+1 );

   if (!connectPath->check(call)) return;

	data_call = call;

	delete userinfo;
	userinfo = new UserInfo( data_call );
	boxcheck->readData( userinfo->getBoxCheck().latin1() );
	infobar->setName( userinfo->getName() );
	kontextmenu->setItemEnabled( mnu_boxcheck, false );
	toolbar->setItemEnabled( toolb_boxcheck, false );

	// Fenster-Ueberschrift
	setCaption();

	// Im Hauptfenster Rufzeichen und Typen updaten
	toplevel->chanListTable->changeCallAndType( this, data_call, userinfo->getType() );
}
//---------------------------------------------------------------------------
void Channel::checkSwType(char *line)
{
   int i;


   for (i=0;i<SW_ANZ;i++)
   {
      switch (swType[i].id)
      {
         case SW_FLEXNET:
              if (!strncmp(line, "PC/FlexNet V", 12) ||
                  !strncmp(line, "RMNC/FlexNet V", 14))
              {
                 // Digi - entsprechende Flags und den Typen setzen
                 userinfo->typeChecked( TYPE_DIGI, SW_FLEXNET );
                 toplevel->chanListTable->changeType( this, TYPE_DIGI );
                 return;
              }
              break;
         case SW_AWZNODE:
              if (!strncmp(line, "AWZNode v", 9))
              {
                 // Digi - entsprechende Flags und den Typen setzen
                 userinfo->typeChecked( TYPE_DIGI, SW_AWZNODE );
                 toplevel->chanListTable->changeType( this, TYPE_DIGI );
                 return;
              }
              break;
         case SW_TNN:
              if (!strncmp(line, "TNN V", 5))
              {
                 // Digi - entsprechende Flags und den Typen setzen
                 userinfo->typeChecked( TYPE_DIGI, SW_TNN );
                 toplevel->chanListTable->changeType( this, TYPE_DIGI );
                 return;
              }
              break;
         case SW_BAYBOX:
              if (!strncmp(line, "BayCom-Mailbox V", 16))
              {
                 userinfo->typeChecked( TYPE_MAILBOX, SW_BAYBOX );
                 toplevel->chanListTable->changeType( this, TYPE_MAILBOX );
                 return;
              }
              break;
         case SW_FBB:
              if (!strncmp(line, "[FBB-", 5))
              {
                 userinfo->typeChecked( TYPE_MAILBOX, SW_FBB );
                 toplevel->chanListTable->changeType( this, TYPE_MAILBOX );
                 return;
              }
              break;
         case SW_DPBOX:
              if (!strncmp(line, "[DP-", 4))
              {
                 userinfo->typeChecked( TYPE_MAILBOX, SW_DPBOX );
                 toplevel->chanListTable->changeType( this, TYPE_MAILBOX );
                 return;
              }
              break;
         case SW_LINKT:
              if (!strncmp(line, "{LinKT-", 7) ||
                  !strncmp(line, "[LinKT#", 7))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_LINKT );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
         case SW_GP85:
              if (!strncmp(line, "[GP85#", 6))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_GP85 );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
         case SW_WINGT:
              if (!strncmp(line, "*** WinGT ", 10))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_WINGT );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
         case SW_MCUT:
              if (!strncmp(line, "{MCUT-", 6))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_MCUT );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
         case SW_XPACKET:
              if (!strncmp(line, "[XPACKET-", 9))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_XPACKET );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
         case SW_WINSTOP:
              if (!strncmp(line, "{WinSTOP-", 9))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_WINSTOP );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
         case SW_PAXON:
              if (!strncmp(line, "Paxon ", 6) ||
                  !strncmp(line, "{Paxon-", 7))
              {
                 userinfo->typeChecked( TYPE_TERMINAL, SW_PAXON );
                 toplevel->chanListTable->changeType( this, TYPE_TERMINAL );
                 return;
              }
              break;
      }
   }
}
//---------------------------------------------------------------------------
void Channel::slotAway()
{
   toplevel->slotAway();
}
//---------------------------------------------------------------------------
void Channel::checkSIDFlags( char *line )
{
   int i,k,len;

   // Gucken, ob dies ein Header mit der Syntax {Software-Version-Flags}
   // ist. Wenn ja werden die Flags 'rausgesucht.
   if ((i = POS('{', line)) < 0) return;
   if ((k = POS('}', line)) < 0) return;
   if (i > k) return;
   while ((i = POS('-', line)) > -1)
   {
      len = strlen(line);
      memmove(line, line+i+1, len);
      line[len] = '\0';
   }
   if ((k = POS('}', line)) > -1)
      line[k] = '\0';

   // Sooo... Die Flags sind jetzt in line und werden durchsucht.
   for (i=0; line[i] != '\0'; i++)
   {
      switch (line[i])
      {
         case '?': // Unser Name ist der Gegenstation unbekannt.
                   break;
      }
   }
}
//---------------------------------------------------------------------------
void Channel::logBookEntry()
{
   char tmp[500];
   time_t zeit;
   struct tm loti_now, loti_start;
   char mon[12][4]={"jan","feb","mar","apr","may","jun","jul","aug",
                    "sep","okt","nov","dez"};
   int fd;


   zeit = time(NULL);
   loti_now = *localtime(&zeit);
   loti_start = *localtime(&data_logintime);

   sprintf(tmp, "%s/log/%s%i.log", conf->localDir().latin1(), mon[loti_now.tm_mon], loti_now.tm_year+1900);

   if ((fd = open(tmp, O_WRONLY|O_APPEND)) == -1)
      if (errno == ENOENT)
         if ((fd = open(tmp, O_WRONLY|O_CREAT|O_APPEND)) == -1)
            return;
         else
         {
            // Zugriffsrechte einstellen
            fchmod(fd,S_IRUSR|S_IWUSR);

            strcpy(tmp, "\n    port         starttime               endtime         rxbytes   txbytes      mycall     connpath\n");
            write(fd, tmp, strlen(tmp));
            strcpy(tmp, "-------------------------------------------------------------------------------------------------------------\n");
            write(fd, tmp, strlen(tmp));
         }
      else
         return;

   sprintf(tmp, "%10s  %.2i.%.2i.%.4i %.2i:%.2i:%.2i    %.2i.%.2i.%.4i %.2i:%.2i:%.2i  %8li  %8li  %10s <-> %s %s\n",
                data_port.latin1(),
                loti_start.tm_mday, loti_start.tm_mon+1, loti_start.tm_year+1900, loti_start.tm_hour, loti_start.tm_min, loti_start.tm_sec,
                loti_now.tm_mday, loti_now.tm_mon+1, loti_now.tm_year+1900, loti_now.tm_hour, loti_now.tm_min, loti_now.tm_sec,
                bytesRX, bytesTX, data_mycall.latin1(), data_call.latin1(), data_digis.latin1());
   write(fd, tmp, strlen(tmp));
   ::close(fd);
}
//---------------------------------------------------------------------------
void Channel::activateCheckWin()
{
	boxcheck->showWindow();
}
//---------------------------------------------------------------------------
void Channel::checkForHUF(char *data, int len)
{
   char tmp[100];
   int i;

   if (strncmp(data, "#HUF:", 5)) return;

   memcpy(tmp, data+5, len-5);
   tmp[len-5] = '\0';

   if ((i = POS('#', tmp)) > -1)
      tmp[i] = '\0';


   if (!strcmp(tmp, "0"))
   {
      flags &= ~CH_HUF_RX;
      flags &= ~CH_HUF_TX;
      return;
   }

   // Wenn HUFALLOW aus ist, wird nur das Deaktivieren der Kompression
   // unterstuetzt.
	if (!(userinfo->getFlags() & CH_HUFALLOW)) return;

   if (!strcmp(tmp, "1"))
   {
      flags |= CH_HUF_RX;
      return;
   }

   if (!strcmp(tmp, "ON"))
   {
      flags |= CH_HUF_TX|CH_HUF_RX;
      sendStringComp(8, "#HUF:1#\r", true, COMP_NO);
      return;
   }

   if (!strcmp(tmp, "OFF"))
   {
      flags &= ~(CH_HUF_TX|CH_HUF_RX);
      sendStringComp(8, "#HUF:0#\r", true, COMP_HUF);
      return;
   }

   if (!strcmp(tmp, "NO"))
   {
      flags &= ~(CH_HUF_TX|CH_HUF_RX);
      return;
   }
}
//---------------------------------------------------------------------------
void Channel::slotHufComp()
{
   if ((flags & CH_HUF_RX) ||
       (flags & CH_HUF_TX))
   {
      // #HUF# ist aktiviert - deaktivieren?
      if (KMessageBox::questionYesNo( this,
						i18n("Do you want to deactivate the #HUF# online compression?"),
						i18n("#HUF#-Compression?")) == KMessageBox::Yes)
      {
         // #HUF# deaktivieren
         sendStringComp(10, "#HUF:OFF#\r", true, COMP_HUF);
         flags &= ~CH_HUF_TX;
         return;
      }
      return;
   }


	if (!(userinfo->getFlags() & CH_HUFALLOW))
   {
   	KMessageBox::error( this,
                  i18n("This station is not permitted to use #HUF#-compression.\n(Please check the channel-settings)"),
						i18n("#HUF#-Compression"));
		return;
   }


   // #HUF# ist noch nicht aktiviert - aktivieren?
   if (KMessageBox::questionYesNo( this,
                  i18n("Do you want to activate the #HUF# online compression?"),
						i18n("#HUF#-Compression?")) == KMessageBox::Yes)
   {
      // #HUF# aktivieren
      sendStringComp(9, "#HUF:ON#\r", true, COMP_NO);
      flags |= CH_HUF_TX;
      return;
   }
}
//---------------------------------------------------------------------------
//   void Channel::getCookie( QString & cookie )
//
// Holt ein Cookie und packt es nach str. Das File heisst "cookies"
// und wird zuerst unter .kde/share/apps/linkt/ und wenn da nicht
// vorhanden in $(KDEDIR)/share/apps/linkt/cookies gesucht.
void Channel::getCookie( QString & cookie )
{
	QFile f;
   int count, use;
   bool usethis=false;


/*   FILE *f;
   char tmp[500];
   int count, use, len=0, i;
   bool usethis=false;*/


/*   strcpy(str, "Sorry, the cookies-file cannot be found.");
   str[0] = '\0';
*/


	cookie = "";

	f.setName( conf->localDir()+"/cookies" );
   if (!f.open(IO_ReadOnly))
   {
   	f.setName( KStandardDirs::kde_default("data")+"/linkt/cookies" );
		if (!f.open(IO_ReadOnly))
      {
         cookie = "Sorry, the cookies-file cannot be found.";
      	return;
		}
   }

   QTextStream t( &f );
   QString s;

   // Anzahl der Cookies zaehlen
   count = -1;
   while (!t.eof())
   {
   	s = t.readLine();		// Zeile ohne \n einlesen
      if (s == "@@") count++;
   }

   use = 1+(int) ((float)count*rand()/(RAND_MAX+1.0));

   f.at( 0 );		// An den Anfang des Files zurueck
   count = 0;

   while (!t.eof())
   {
   	s = t.readLine();		// Zeile ohne \n einlesen
      if (s == "@@")
      {
      	if (usethis)
         {
         	f.close();
            return;
         }
      	count++;
      }
      else
      {
      	if (usethis)
         {
           	cookie += s;
				if (!t.eof())
            	cookie += '\r';
         }
      }
      if ((count == use) && !usethis)
         usethis = true;
   }

   f.close();
}
//---------------------------------------------------------------------------
void Channel::updateBoxcheckCfg()
{
   boxcheck->readData( userinfo->getBoxCheck().latin1() );
}
//---------------------------------------------------------------------------
void Channel::slotSendQuoted()
{
	QString text = QApplication::clipboard()->text();
   QString sendText="";
   int i;


   // Die Daten fuer //ACTIVITY setzen
   config->lastactivity = time( NULL );


	while (!text.isEmpty())
   {
   	if ((i = text.find('\n')) > -1)
      {
      	sendText += "> "+text.left(i)+"\r";
         text.remove( 0, i+1 );
      }
      else
      {
      	sendText += "> "+text+"\r";
         text.truncate( 0 );
      }
   }

   sendString( sendText );
}
//---------------------------------------------------------------------------
void Channel::slotSendUnquoted()
{
	QString text = QApplication::clipboard()->text();
   QString sendText="";
   int i;


   // Die Daten fuer //ACTIVITY setzen
   config->lastactivity = time( NULL );


	while (!text.isEmpty())
   {
   	if ((i = text.find('\n')) > -1)
      {
      	sendText += text.left(i)+"\r";
         text.remove( 0, i+1 );
      }
      else
      {
      	sendText += text+"\r";
         text.truncate( 0 );
      }
   }

   sendString( sendText );
}
//---------------------------------------------------------------------------
void Channel::slotInsertQuoted()
{
	QString text = QApplication::clipboard()->text();
   int i, line;


   vorschreib->cursorPosition( &line, &i );
   line++;

	while (!text.isEmpty())
   {
   	if ((i = text.find('\n')) > -1)
      {
         vorschreib->insertLine( "> "+text.left(i), line);
         line++;
         text.remove( 0, i+1 );
      }
      else
      {
         vorschreib->insertLine( "> "+text, line);
         line++;
         text.truncate( 0 );
      }
   }
}
//---------------------------------------------------------------------------
void Channel::showKontextVorschrMenu()
{
   kontextvorschr->popup(QCursor::pos());
}
//---------------------------------------------------------------------------
void Channel::slotYAPP()
{
	QString filename;


   DlgYAPP *dlg = new DlgYAPP( this, "DlgYAPP" );

   dlg->setGeometry( (mykapp->desktop()->width()-dlg->width())/2,
                     (mykapp->desktop()->height()-dlg->height())/2,
 		               dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      // YAPP-RX
      dlg->getFilename( filename );
		yapp = new YAPP( this, filename );
		flags |= CH_YAPP;
		flags &= ~CH_LINEMODE;
   }

	delete dlg;
}
//---------------------------------------------------------------------------
void Channel::enableBoxcheckMenu()
{
   kontextmenu->setItemEnabled( mnu_boxcheck, true );
	toolbar->setItemEnabled( toolb_boxcheck, true );
}
//---------------------------------------------------------------------------
//   void Channel::withoutTransInfo()
//
// Fenster ohne TransferInfo-Widget
void Channel::withoutTransInfo()
{
//   panner->setGeometry(0, infobar->height(), centralWidget->width(), centralWidget->height()-infobar->height() );
//   centralVBox->
   transferDlg = NULL;
}
//---------------------------------------------------------------------------
//   void Channel::withTransInfo()
//
// Fenster mit TransferInfo-Widget
void Channel::withTransInfo( TransferInfo *win )
{
   bool ist_unten = output->untenBleiben();


   transferDlg = win;
   centralVBox->addWidget( transferDlg );

   if (ist_unten)
      output->ensureVisibleLastLine();

//   transferDlg->setGeometry( 0, centralWidget->height()-transferDlg->height(), centralWidget->width(), transferDlg->height() );
//	  panner->setGeometry( 0, infobar->height(), centralWidget->width(), centralWidget->height()-infobar->height()-transferDlg->height() );
}
//---------------------------------------------------------------------------
//   void Channel::insertBINChatLine( char *text, bool out )
//
// Packt an den Anfang der BIN-Uebertragung eine Textzeile hin, die mit
// "SP\-" davor ausgesendet wird.
void Channel::insertBINChatLine( char *text, bool out )
{
/*   s_sendqueue *tmp;
   char *data;
   int len = strlen(text);

   data = (char *) malloc(len+5);
   strcpy(data, "SP\\-");
   memmove(data+4, text, len);
   len += 4;
   data[len] = '\0';

   // Ein neues Element vor die Sendqueue packen
   tmp = (s_sendqueue *)malloc(sizeof(s_sendqueue));
   tmp->next = sendqueue;
   sendqueue = tmp;

   tmp->len = len;
   tmp->data = (char *)malloc(len);
   memcpy(tmp->data, data, len);
   tmp->show = out;
   tmp->abin = true;
   tmp->comp = COMP_FLAG;
   tmp->type = SENDQ_TEXT;
   tmp->fd = -1;

   free(data);*/
}
//---------------------------------------------------------------------------
bool Channel::isConnected()
{
   return (txfd != -1);
}
//---------------------------------------------------------------------------
void Channel::updateColors()
{	// TODO: Beide Farb-Arrays aufeinander abstimmen
   int outputColors[OUTCOLOR_COUNT];

   outputColors[OUTCOLOR_WINMARKCOL] = conf->getColor(CFG_COLOR_MARKFORE);
   outputColors[OUTCOLOR_WINMARKBACK] = conf->getColor(CFG_COLOR_MARKBACK);
   outputColors[OUTCOLOR_RXTEXT] = conf->getColor(CFG_COLOR_RX);
   outputColors[OUTCOLOR_TXTEXT] = conf->getColor(CFG_COLOR_TX);
   outputColors[OUTCOLOR_STATUSTEXT] = conf->getColor(CFG_COLOR_STATUS);
   outputColors[OUTCOLOR_BACK] = conf->getColor(CFG_COLOR_BG);
   outputColors[OUTCOLOR_GPG] = conf->getColor(CFG_COLOR_GPG);
   output->updateColors(&(outputColors[0]));
}
//---------------------------------------------------------------------------
int Channel::getMaxframe( const char *port )
{
	s_ports *tmp;


   for (tmp=portlist; tmp; tmp=tmp->next)
   	if (!strcmp(port, tmp->name))
      	return tmp->maxframe;

   // Wenn der Port nicht gefunden wurde (eigentlich duefte das nicht
   // passieren), verwenden wir den Wert 3.
   return 3;
}
//---------------------------------------------------------------------------
void Channel::updateBCSize()
{
	boxcheck->setNewFont();
}
//---------------------------------------------------------------------------
void Channel::slotBtnFileSend()
{
  DlgFiletransfer *dlg = new DlgFiletransfer( sendQueue );

  QPoint point = this->mapToGlobal (QPoint (0,0));

  QRect pos = this->geometry();
  dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
		   point.y() + pos.height()/2 - dlg->height()/2, 
		   dlg->width(),dlg->height());

  dlg->exec();
  delete dlg;
}
//---------------------------------------------------------------------------
void Channel::updateToolbar( KConfig *kconfig, const QString & configGroup )
{
	toolbar->applySettings( kconfig, configGroup );

   toolbar->setItemEnabled( toolb_gpg, conf->getFlag(CFG_GPGSUPPORT) );
}
//---------------------------------------------------------------------------
void Channel::slotSetLinemode( bool lm )
{
   if (lm)
   	flags |= CH_LINEMODE;
	else
   	flags &= ~CH_LINEMODE;
}
//---------------------------------------------------------------------------
void Channel::showStatus( FileTransfer *tr, const QString & shortname, long size, long startvalue, int type )
{
	transferDlg = new TransferInfo( centralWidget, type, shortname, size, startvalue );
   connect( transferDlg, SIGNAL(abortClicked()), tr, SLOT(abortTransmission()) );
	withTransInfo( transferDlg );
}
//---------------------------------------------------------------------------
void Channel::unshowStatus()
{
   TransferInfo *transInfo;


   if (transferDlg == NULL) return;

	transInfo = transferDlg;
	withoutTransInfo();
	delete transInfo;
}
//---------------------------------------------------------------------------
void Channel::statusRxBytes( long bytes )
{
	transferDlg->setReceivedBytes( bytes );
}
//---------------------------------------------------------------------------
void Channel::slotWhatsThis()
{
   QWhatsThis::enterWhatsThisMode();
}
//---------------------------------------------------------------------------
void Channel::slotShowSendQueue()
{
   SendQueueList *dlg = new SendQueueList( this, this );

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   int y = point.y() + pos.height()/2 - dlg->height()/2;
   if (y < 0) y = 0;
   dlg->setGeometry(point.x() + pos.width()/2 - dlg->width()/2, y,
          dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}
//---------------------------------------------------------------------------
void Channel::slotSendGPG()
{
	GPGDialog *dlg = new GPGDialog( this, this );

	QPoint point = this->mapToGlobal (QPoint (0,0));

	QRect pos = this->geometry();
	dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
				point.y() + pos.height()/2 - dlg->height()/2,
				dlg->width(),dlg->height());

	dlg->show();

   // Den Speicher nicht wieder freigeben, das erledigt GPGDialog selbst.
}
//---------------------------------------------------------------------------
void Channel::slotBtnKeySend()
{
   GPGSendPKey *dlg = new GPGSendPKey( this, this );

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   int y = point.y() + pos.height()/2 - dlg->height()/2;
   if (y < 0) y = 0;
   dlg->setGeometry(point.x() + pos.width()/2 - dlg->width()/2, y,
          dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}
//---------------------------------------------------------------------------
void Channel::setReceiving( bool enable )
{
   sockrx->setEnabled( enable );
}
//---------------------------------------------------------------------------
void Channel::updateKontextMenu()
{
   kontextmenu->setItemEnabled( mnu_gpg_1, conf->getFlag(CFG_GPGSUPPORT) );
}
//---------------------------------------------------------------------------
void Channel::sendTerminalSID()
{
	char topline[61];


   // Identifikation der Software senden. Wird nicht angezeigt!
   if (userinfo->getName().isEmpty())
      sprintf(topline,"{LinKT-%s-CDH?}\xD", LINKT_VERSION);
   else
      sprintf(topline,"{LinKT-%s-CDH}\xD", LINKT_VERSION);
   sendString(strlen(topline), topline, conf->getFlag(CFG_SHOWTSID));

   flags |= CH_TSIDTX;
}
//---------------------------------------------------------------------------
void Channel::checkTerminalSID( const char *str )
{
	int i, k, len;
   char sid[61], flag[61];


   if ((i = POS('{', str)) == -1) return;
   if ((k = POS('}', str)) == -1) return;
   if (k < i) return;
   len = k-i-1;
   if (len > 60) return;

   memcpy( sid, str, len );
   sid[len] = '\0';

   if ((i = POS('-', sid)) == -1) return;
   if ((k = lPOS('-', sid)) == -1) return;
   if (i==k) return;

	memcpy( flag, sid+k+1, len-k );
   flag[len-k] = '\0';

	sendTerminalSID();
}
//---------------------------------------------------------------------------
void Channel::dragEnterEvent( QDragEnterEvent *e )
{
	QString str, str2;
   int i;
   bool ok=false;


   if (QTextDrag::decode( e, str))
   {
		while ((i = str.find('\n')) != -1)
      {
         str2 = str.left(i);
         str = str.remove( 0, i+1 );

         if (str2.left(6) == "file:/")
         	ok = true;
      }

      if (str.left(6) == "file:/")
      	ok = true;
   	e->accept( ok );
	}
   else
	   e->accept( false );
}
//---------------------------------------------------------------------------
void Channel::dropEvent( QDropEvent *e )
{
   DlgFiletransfer *dlg=NULL;
	QString str, str2;
   int i;


	if (QTextDrag::decode( e, str))
	{
		dlg = new DlgFiletransfer( sendQueue );

		QPoint point = this->mapToGlobal (QPoint (0,0));

		QRect pos = this->geometry();
		dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
				point.y() + pos.height()/2 - dlg->height()/2,
				dlg->width(),dlg->height());

		while ((i = str.find('\n')) != -1)
      {
         str2 = str.left(i);
         str.remove( 0, i+1 );

         if (str2.left(6) == "file:/")
         {
         	str2.remove( 0, 5 );
         	dlg->addFile( str2 );
			}
      }

		if (str.left(6) == "file:/")
		{
			str.remove( 0, 5 );
			dlg->addFile( str );
		}

		dlg->exec();
		delete dlg;
	}
}
//---------------------------------------------------------------------------
void Channel::slotFilesendAutoBIN()
{
   QString f;
   QFileDialog *qfd;


	qfd = new QFileDialog( conf->getDirUp(), QString::null, this, "", true);
   qfd->setCaption(i18n("Send file using AutoBIN..."));
   qfd->setMode( QFileDialog::ExistingFile );

   if (qfd->exec() == 0) return;

   f = qfd->selectedFile();

   // Cancel
   if (f.isEmpty())
   {
	   delete qfd;
   	return;
	}

   conf->setDirUp( qfd->dir()->absPath() );

   delete qfd;


   // AutoBIN-File aussenden
   sendQueue->addFileTransfer( f, FTPROT_ABIN, NULL, filesize(f.latin1()));
}
//---------------------------------------------------------------------------
void Channel::slotFilesendDIDADIT()
{
   QString f;
   QFileDialog *qfd;


	qfd = new QFileDialog( conf->getDirUp(), QString::null, this, "", true);
   qfd->setCaption(i18n("Send file using DIDADIT..."));
   qfd->setMode( QFileDialog::ExistingFile );

   if (qfd->exec() == 0) return;

   f = qfd->selectedFile();

   // Cancel
   if (f.isEmpty())
   {
	   delete qfd;
   	return;
	}

   conf->setDirUp( qfd->dir()->absPath() );

   delete qfd;


   // DIDADIT-File aussenden
   sendQueue->addFileTransfer( f, FTPROT_DIDADIT, NULL, filesize(f.latin1()) );
}
//---------------------------------------------------------------------------
void Channel::slotFilesendTextfile()
{
   QString f;
   QFileDialog *qfd;


	qfd = new QFileDialog( conf->getDirUp(), QString::null, this, "", true);
   qfd->setCaption(i18n("Send plain textfile..."));
   qfd->setMode( QFileDialog::ExistingFile );

   if (qfd->exec() == 0) return;

   f = qfd->selectedFile();

   // Cancel
   if (f.isEmpty())
   {
	   delete qfd;
   	return;
	}

   conf->setDirUp( qfd->dir()->absPath() );

   delete qfd;


   // Text-File aussenden
   sendQueue->addTextFile( f, COMP_FLAG, filesize(f.latin1()) );
}
//---------------------------------------------------------------------------
void Channel::slotToolbarMoved()
{
	toplevel->toolbarMoved( this, toolbar );
}
//---------------------------------------------------------------------------
void Channel::setCaption()
{
	QString str;


   str = "LinKT: "+data_call+" <-> "+data_mycall+" (port: "+data_port+")";
	setPlainCaption( str );
}
//---------------------------------------------------------------------------

