/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "filetransfer.h"
#include "filetransfer.moc"

#include <qlayout.h>

#include "toolbox.h"
#include "channel.h"
//---------------------------------------------------------------------------
FileTransfer::FileTransfer( Channel *channel, const QString & filename ) : QObject()
{
   int i;


	chan = channel;

   longname = filename;
	if ((i = longname.findRev('/')) == -1)
   	shortname = longname;
   else
   	shortname = longname.mid(i+1);
}
//---------------------------------------------------------------------------
FileTransfer::~FileTransfer()
{
}
//---------------------------------------------------------------------------
//   void FileTransfer::sendMessage( const char *str )
// Eine Nachricht (Statusmeldung) auf dem Bildschirm anzeigen und, wenn
// moeglich (Gegenstation keine automatische Station) auch aussenden.
void FileTransfer::sendMessage( const char *str )
{
   if (((Channel *)chan)->userinfo->getType() == TYPE_TERMINAL)
      emit sendString( str, strlen(str), true );
   else
      chan->outText( str, strlen(str), OUTCOLOR_TXTEXT );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
TransferInfo::TransferInfo( QWidget *parent, int art, const QString & filename, long size, long offset )
                   : QWidget( parent )
{
	QHBoxLayout *hbox = new QHBoxLayout( this );


//   setFixedHeight( 23 );
   startbytes = offset;
   bytes_got = offset;
   filesize = size;
   starttime = time(NULL);
   this->art = art;

   progressbar = new QProgressBar( 500, this );
   progressbar->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   hbox->addWidget( progressbar, 1 );


   lFileName = new QLabel( filename, this );
   lFileName->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   hbox->addWidget( lFileName );

   lTimeLeft = new QLabel( this );
   lTimeLeft->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   hbox->addWidget( lTimeLeft );

   lBytes = new QLabel( this );
   lBytes->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   lBytes->setAlignment( AlignRight|AlignVCenter );
   hbox->addWidget( lBytes );

   lBaudEff = new QLabel( this );
   lBaudEff->setFrameStyle( QFrame::Panel | QFrame::Sunken );
   lBaudEff->setAlignment( AlignRight|AlignVCenter );
   hbox->addWidget( lBaudEff );

   hbox->addSpacing( 5 );

   btnAbort = new QPushButton( i18n("Abort"), this );
   connect( btnAbort, SIGNAL(clicked()), SLOT(slotAbortClicked()) );
   hbox->addWidget( btnAbort );

   timer = new QTimer(this);
   connect( timer, SIGNAL(timeout()), this, SLOT(slotUpdate()) );
   timer->start( 2000, false );


   slotUpdate();
   show();
}
//---------------------------------------------------------------------------
TransferInfo::~TransferInfo()
{
}
//---------------------------------------------------------------------------
void TransferInfo::setReceivedBytes( int rxbytes )
{
	QString tmp;


   bytes_got = rxbytes;

   tmp.sprintf( "%i bytes", rxbytes );
   lBytes->setText( tmp );

   progressbar->setProgress( (int) (((float)rxbytes/(float)filesize) * 500) );

   timer->start( 2000, false );
   slotUpdate();
}
//---------------------------------------------------------------------------
void TransferInfo::setFilesizeBytes( int bytes )
{
   filesize = bytes;
}
//---------------------------------------------------------------------------
void TransferInfo::slotUpdate()
{
   char hours[5], mins[5], secs[5];
   QString tmp;
   time_t timediff = time(NULL) - starttime;
   time_t timeleft;


   // Baud-Rate
   if (timediff == 0) timediff = 1;
   tmp.sprintf( "%li bit/s", ((bytes_got-startbytes)*8)/timediff );
   lBaudEff->setText( tmp );

   // Verbleibende Zeit
   if (((bytes_got-startbytes)/timediff) < 1)
      timeleft = 1;
   else
      timeleft = (filesize-startbytes)/((bytes_got-startbytes)/timediff)-timediff;

   sprintf(secs, "%.2i", (int)timeleft%60);
   timeleft /= 60;
   sprintf(mins, "%.2i", (int)timeleft%60);
   timeleft /= 60;
   sprintf(hours, "%.2i", (int)timeleft);

   tmp.sprintf( "%s:%s:%s", hours, mins, secs );
   lTimeLeft->setText( tmp );
}
//---------------------------------------------------------------------------
void TransferInfo::slotAbortClicked()
{
	emit abortClicked();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

