/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                              
 *  As a special exception, you have permission to link this program
 *  with the Qt library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from Qt.
 */


#include "main.h"
#include "main.moc"

#include "ahuf.h"
#include "global.h"
#include "toolbox.h"
#include "dialog.h"
#include "version.h"
#include "pref.h"
#include "settings.h"
#include "userdata.h"

#include <ktmainwindow.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <X11/Xlib.h>
#include <kwin.h>
#include <kstddirs.h>
#include <kaboutdialog.h>
#include <kiconloader.h>
#include <kcmdlineargs.h>

#include <qwhatsthis.h>
#include <qaccel.h>
#include <qiconset.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>


KApplication *mykapp;
TopLevel *toplevel;


// aus global.h
s_config *config;
QWidget *focusWidget;
s_boxcheck *boxcheckroot;
Config *conf;


/*
 *  TopLevel::TopLevel( QWidget *parent=0, const char *name=0 )
 * Konstruktor des Hauptfensters
 */
TopLevel::TopLevel( const char *name )
             : KTMainWindow(name)
{
   setMinimumSize (200, 100);

   // Lokale Variablen dieser Klasse
   chanlist = NULL;
   currentChannel = NULL;
   qsoWinGeometryFlag = false;

   // Initialisierung der Random-Geschichte
   srand((int)time(NULL));

   init_ax25();

   setPlainCaption(i18n("LinKT - the Linux KDE PR-Terminal"));


   setupMenuBar();
   chanListTable = new ChanList( this );
   connect( chanListTable, SIGNAL(signalFunctionKey(int)), SLOT(slotCallKey(int)) );
   setMainwinSize();


   setView( chanListTable );
   lastWinPos=new QPoint(1,1);

   QAccel *a = new QAccel( this );
   a->connectItem( a->insertItem( Key_W+CTRL ), this, SLOT(slotWhatsThis()) );


   // Audio-Server connecten
#ifdef ENABLE_SOUND
   sound = new LinKTSound();
	if (sound->error)
   printf("sound-error!\n");
#endif

	// QWhatsThis-Eintraege
   QWhatsThis::add( chanListTable, i18n("This is the <b>channel list</b>. You can switch channels by clicking on the according line.") );
}


TopLevel::~TopLevel()
{
}


void TopLevel::setMainwinSize()
{
   int width = chanListTable->useWidth();
   int height = chanListTable->useHeight();

   setFixedSize( width, height );
}


/*
 *  void TopLevel::setupMenuBar()
 * Das Hauptmenue wird aufgebaut und an das KTMainWindow angedockt.
 */
void TopLevel::setupMenuBar()
{
   file = new QPopupMenu ();

   file->insertItem( i18n("&User-Settings"), this, SLOT(slotUserSettings()) );
   file->insertItem( i18n("&Preferences..."), this, SLOT(slotPreferences()) );
   file->insertItem( i18n("Away..."), this, SLOT(slotAway()), ALT+Key_A);
   file->insertSeparator( -1 );
   file->insertItem( i18n("E&xit"), this, SLOT(slotBeenden()), ALT+Key_X);

   channel = new QPopupMenu ();
   channel->insertItem( i18n("&Connect..."), this, SLOT(slotConnect()), ALT+Key_C);


   help = new QPopupMenu ();
   help->insertItem( QIconSet(BarIcon("linkt_contents")), i18n("&Contents"), this, SLOT(slotHelp()));
   help->insertItem( QIconSet(BarIcon("linkt_contexthelp")), i18n("&What's This"), this, SLOT(slotWhatsThis()));
   help->insertSeparator( -1 );
   help->insertItem( i18n("&About LinKT..."), this, SLOT(slotAbout()));



   menubar = new KMenuBar (this);
   menubar->insertItem( i18n("&File"), file );
   menubar->insertItem( i18n("Cha&nnel"), channel );
   menubar->insertSeparator( -1 );
   menubar->insertItem( i18n("&Help"), help );

   setMenu(menubar);
}


/*
 *  void TopLevel::slotBeenden()
 * Wird aufgerufen, wenn LinKT beendet werden soll. (Sicherheitsabfrage)
 */
void TopLevel::slotBeenden()
{
   close();
}


void TopLevel::slotUserSettings()
{
   UserSettings *dlg = new UserSettings( this );

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
             (mykapp->desktop()->height()-dlg->height())/2,
          dlg->width(),dlg->height());

	dlg->exec();


	delete dlg;
}


void TopLevel::slotPreferences()
{
	// Farben
   bool gpgsupport;
   int colTxText, colRxText, colStatusText, colBackground;
   int colMarkColor, colMarkBack, colGpgText;
   int tbarPos, tbarFlg;
   QFont fQso, fTx, fBCheck;

   s_chanlist *tmp;


   Preferences *dlg = new Preferences( this );

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
             (mykapp->desktop()->height()-dlg->height())/2,
          dlg->width(),dlg->height());

	// ----- Alte Einstellungen speichern. -----
   // Farben
   colTxText = conf->getColor(CFG_COLOR_TX);
   colRxText = conf->getColor(CFG_COLOR_RX);
   colStatusText = conf->getColor(CFG_COLOR_STATUS);
   colBackground = conf->getColor(CFG_COLOR_BG);
   colMarkColor = conf->getColor(CFG_COLOR_MARKFORE);
   colMarkBack = conf->getColor(CFG_COLOR_MARKBACK);
   colGpgText = conf->getColor(CFG_COLOR_GPG);
   // Toolbar-Infos
   tbarPos = conf->getTbarPos();
   tbarFlg = conf->getTbarFlg();
	// Schriften
   fQso = conf->qsoFont();
   fTx = conf->txFont();
   fBCheck = conf->bcFont();

   gpgsupport = conf->getFlag(CFG_GPGSUPPORT);



   if (dlg->exec() == QDialog::Rejected)
   {
   	// Cancel gedrueckt: Keine Aenderungen ueberpruefen
   	delete dlg;
      return;
   }

   // ----- Wenn etwas geaendert wurde, wird jetzt aktualisiert. -----
   if (colTxText != conf->getColor(CFG_COLOR_TX) || colRxText != conf->getColor(CFG_COLOR_RX) ||
       colStatusText != conf->getColor(CFG_COLOR_STATUS) || colBackground != conf->getColor(CFG_COLOR_BG) ||
       colMarkColor != conf->getColor(CFG_COLOR_MARKFORE) || colMarkBack != conf->getColor(CFG_COLOR_MARKBACK) ||
       colGpgText != conf->getColor(CFG_COLOR_GPG) ||
       fQso != conf->qsoFont() || fTx != conf->txFont())
   {
      // Schrifgroessen oder Schriftarten haben sich geaendert - updaten
      for (tmp=chanlist; tmp; tmp=tmp->next)
			tmp->channel->updateFont();
	}

	if (fBCheck != conf->bcFont())
		for (tmp=chanlist; tmp; tmp=tmp->next)
			tmp->channel->updateBCSize();

//	if (txWinOben != config->txWinOben)
// 	for (tmp=chanlist; tmp; tmp=tmp->next)
//			tmp->channel->updateWindowPos();

/*	if (tbarFlg != conf->getTbarFlg() || tbarPos != conf->getTbarPos() || gpgsupport != conf->getFlag(CFG_GPGSUPPORT))
		for (tmp=chanlist; tmp; tmp=tmp->next)
      {
			tmp->channel->updateToolbar( tbarFlg );
         tmp->channel->updateKontextMenu();
		}*/

	delete dlg;
}


/*
 *  void TopLevel::slotAway()
 * Hier kann man einstellen, ob man da oder weg ist.
 */
void TopLevel::slotAway()
{
   AwayDlg *dlg = new AwayDlg( this );

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
             (mykapp->desktop()->height()-dlg->height())/2,
          dlg->width(),dlg->height());

	connect( dlg, SIGNAL(awayDataChanged()), SLOT(slotAwayDataChanged()) );
   dlg->exec();

   delete dlg;
}


//   bool incSSID(char *call)
//
// Die SSID des Rufzeichens wird inkrementiert. Wenn die inkrementierte
// SSID groesser als 15 waehre, kommt eine Fehlermeldung.
bool TopLevel::incSSID(char *call)
{
   char tmp[50];
   int i,len,ssid;


   // SSID abtrennen
   if ((i = POS('-', call)) == -1)
   {
      // Keine SSID vorhanden. SSID = 0
      ssid = 0;
   }
   else
   {
      len = strlen(call)-i-1;
      memcpy(tmp, call+i+1, len);
      tmp[i] = '\0';
      ssid = atoi(tmp);
      call[i] = '\0';
   }

   // SSID inkrementieren und gucken, ob sie > 15 wird.
   ssid++;
   if (ssid > 15)
      return false;

   sprintf(call, "%s-%i", call, ssid);

   return true;
}



/*
 *  void TopLevel::slotConnect()
 * Wird aufgerufen, wenn eine Verbindung nach Aussen aufgebaut werden soll.
 */
void TopLevel::slotConnect()
{
   char digis[500],*port=0,*tmp,*mycall=0, call[500], porttmp[500];
   int i,fd,error,len;
   bool ready=false, changed=false;

   Connect *dlg = new Connect( this );

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
             (mykapp->desktop()->height()-dlg->height())/2,
          dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      // Connect aufbauen
      strcpy(digis, dlg->getText());
      port = (char *) strdup(dlg->getPort());
      mycall = (char *) malloc(strlen(dlg->getMycall())+10);
      strcpy(mycall, dlg->getMycall());

      if (mycall[0] == '\0')
      {
      	free(mycall);
         free(port);
      	KMessageBox::error( this,
									i18n("Cannot connect -- no mycall given."),
                           i18n("Connecting"));
         return;
      }

      if (digis[0] == '\0')
      {
         free(port);
         free(mycall);
         return;
      }

      if (port[0] == '\0')
      {
      	free(mycall);
         free(port);
      	KMessageBox::error( this,
                           i18n("Cannot connect -- no ax.25-port active."),
                           i18n("Connecting"));
         return;
      }

      tmp = (char *) malloc( strlen(digis)+1 );

      // Ueberfluessige Leerzeichen weg machen
      OnlyOneSpace(tmp, digis);
      KillSpacesLeft(tmp);
      KillSpacesRight(tmp);

      // Connectpfad in die Liste eintragen
      conf->addConnEntry( tmp );

      Gross(tmp);


      if (changed)
         if ((i = POS(' ', call)) > -1)
         {
            memcpy(porttmp, call, i);
            porttmp[i] = '\0';
            len = strlen(call)-i-1;
            memmove(call, call+i+1, len);
            call[len] = '\0';

            free(tmp);
            tmp = (char *) strdup(call);
            free(port);
            port = (char *) strdup(porttmp);
         }


      if ((i = POS(' ',tmp)) > -1)
      {
         COPY(digis, tmp, i+1, strlen(tmp)-i-1);
         tmp[i] = '\0';
      }
      else
          digis[0] = '\0';

      Gross(tmp);
      Gross(digis);
      Gross(mycall);

      do
      {

         fd = makeConnect( tmp, digis, mycall, port, &error );

         if (fd == -1)
         {
            switch (error)
            {
               case 1: // invalid parameter
						KMessageBox::error( this,
												i18n("Invalid parameter"),
												i18n("AX.25 Error"));
						ready = true;
						break;
               case 2: // cannot open socket
						KMessageBox::error( this,
                                    i18n("Cannot open socket"),
												i18n("AX.25 Error"));
						ready = true;
						break;
               case 3: // cannot bind socket
						KMessageBox::error( this,
                                    i18n("Cannot bind socket"),
												i18n("AX.25 Error"));
						ready = true;
						break;
               case 4: // cannot connect twice
						if (!conf->getFlag(CFG_INCSSID))
						{
							KMessageBox::error( this,
	                                    i18n("Cannot connect twice"),
													i18n("AX.25 Error"));
							ready = true;
						}
						else
							if (!incSSID(mycall))
							{
								KMessageBox::error( this,
		                                    i18n("Cannot increment ssid"),
														i18n("AX.25 Error"));
								ready = true;
							}
							break;
					case 0xFF: // unknown port name
							KMessageBox::error( this,
													i18n("Cannot comply: port unknown"),
													i18n("AX.25 Error"));
							ready = true;
							break;
				}
         }
         else
         {
            if (currentChannel != NULL && !((Channel *)currentChannel)->isConnected())
            {
               ((Channel *)currentChannel)->makeNewConnect( port,
                                                            mycall,
                                                            tmp,
                                                            digis,
                                                            fd );
               addChannelList()->channel = (Channel *)currentChannel;
            }
            else
            {
               addChannelList()->channel = new Channel( port,
                                                        mycall,
                                                        tmp,
                                                        digis,
                                                        fd,
                                                        false);
               if (conf->getFlag(CFG_HIDEWINSWITCH))
                  if (currentChannel != NULL)
                     currentChannel->hide();
            }
            playSound( SOUND_CONN_SETUP );
            ready = true;
         }
      }
      while (!ready);
      free(tmp);
      free(port);
      free(mycall);
   }

   delete dlg;
}


void TopLevel::slotAbout()
{
   AboutDlg *dlg = new AboutDlg(0);

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   int y = point.y() + pos.height()/2 - dlg->height()/2;
   if (y < 0) y = 0;
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
             y,
          dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}


void TopLevel::slotWhatsThis()
{
   QWhatsThis::enterWhatsThisMode();
}


/*
 *  int TopLevel::makeConnect( char *call, char *digis, char *mycall, char *port, int * error )
 * Versucht, die ausgewaehlte Gegenstation zu connecten.
 *
 * Error-Codes: FF = Portname nicht vorhanden
 */
int TopLevel::makeConnect( char *call, char *digis, char *mycall, char *port, int * error )
{
   s_ports *tmp;
   bool found=false;

   // Port suchen
   tmp = portlist;
   while (tmp != NULL && !found)
   {
      if (!strcmp(port, tmp->name))
         found = true;
      else
         tmp = tmp->next;
   }
   if (!found)
   {
      *error = 0xFF;
      return -1;
   }

   return tmp->ax25->makeConnect( call, digis, mycall, port, error);
}



/*
 *  void TopLevel::addChannelList()
 * Macht einen Eintrag in die Kanal-Liste und gibt den Pointer auf
 * die neue Struktur zurueck.
 */
s_chanlist * TopLevel::addChannelList()
{
   s_chanlist *tmp;

   if (chanlist == NULL)
   {
      // Erster Eintrag
      chanlist = (s_chanlist *)malloc(sizeof(s_chanlist));
      tmp = chanlist;
   }
   else
   {
      tmp = chanlist;
      while (tmp->next != NULL) tmp = tmp->next;

      tmp->next = (s_chanlist *)malloc(sizeof(s_chanlist));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->channel = NULL;

   return tmp;
}


/*
 *  void TopLevel::deleteChannelList( Channel *chan )
 * Loescht den uebergebenen Kanal aus der Liste 'raus.
 */
void TopLevel::deleteChannelList( Channel *chan )
{
   s_chanlist *tmp,*last;
   bool found=false;


   if (chanlist == NULL) return;

   if (chanlist->channel == chan)
   {
      tmp = chanlist;
      chanlist = chanlist->next;
      free(tmp);
      return;
   }

   tmp = chanlist->next;
   last = chanlist;
   while (tmp != NULL && !found)
   {
      if (tmp->channel == chan)
      {
         last->next = tmp->next;
         found = true;
         free(tmp);
      }
      last = tmp;
      if (!found) tmp = tmp->next;
   }

   tmp = chanlist;
}


s_chanlist * TopLevel::getChanListPtr()
{
   return chanlist;
}


void TopLevel::setupChanListWidget()
{
   chanListTable = new ChanList( this );
}


void TopLevel::closeEvent(QCloseEvent *e)
{
   if (chanlist != NULL)
   {
	   if (KMessageBox::questionYesNo( this,
                         i18n("Some channels are still connected. Do you really want to quit?"),
                         i18n("Quit LinKT?")) != KMessageBox::Yes)
      {
         e->ignore();
         return;
      }
   }

   // Die letzten 15 connecteten Rufzeichen abspeichern
   conf->saveConnList();

   // Abspeichern des Aussehens der Toolbars
//   toolbar->saveState();

   e->accept();
}


void TopLevel::slotHelp()
{
   mykapp->invokeHTMLHelp( "", "" );
}


//   void TopLevel::slotCallKey(int id);
//
// Wird aufgerufen, wenn im Vorschreibfenster die Funktionstasten benutzt
// werden.
void TopLevel::slotCallKey(int id)
{
   char rxcall[20];
   s_chanlist *tmp;
   int i;
   QWidget *win,*akt;
   s_callKey *callkey = conf->getCallKey(id);


   if (callkey == NULL)
   {
      QApplication::beep();
      return;
   }

   // Gucken, ob dieses Rufzeichen irgendwo eingeloggt ist
   tmp = chanlist;
   while (tmp != NULL)
   {
      strcpy(rxcall, tmp->channel->getCall());
      if (!callkey->ssid)
         if ((i = POS('-', rxcall)) > -1)
           rxcall[i] = '\0';

      if (!strcmp(rxcall, callkey->call))
      {
         win = tmp->channel;

         if (win->isActiveWindow()) return;
	 if (toplevel->currentChannel)
	   (* toplevel->lastWinPos)=toplevel->currentChannel->pos(); 
         akt = toplevel->currentChannel;
         activateChannel(win, akt, true);

         chanListTable->auswahlLoeschen();
         return;
      }

      tmp = tmp->next;
   }

   QApplication::beep();
}


void TopLevel::activateChannel(QWidget *win, QWidget *oldwin, bool show)
{
   if ((win == oldwin) && !show) return;

   win->show();
   KWin::setActiveWindow( win->winId() );
   ((Channel *)win)->getVorschreibPtr()->setFocus();

   if (currentChannel != NULL)
     if (conf->getFlag(CFG_HIDEWINSWITCH) && (lastWinPos != NULL))
       XMoveWindow(x11Display(), win->winId(), lastWinPos->x(), lastWinPos->y() );
   if (conf->getFlag(CFG_HIDEWINSWITCH))
      if (oldwin != NULL)
         oldwin->hide();

   currentChannel = win;
}


void TopLevel::setQsoWinGeometry( const QRect rect )
{
   qsoWinGeometry = rect;
}


QRect & TopLevel::getQsoWinGeometry()
{
   return qsoWinGeometry;
}


bool TopLevel::qsoWinGeometrySet()
{
   return qsoWinGeometryFlag;
}


void TopLevel::checkForFirstRun()
{
   s_ports *tmp;
   char text[500];
   char mycall[50];


   mycall[0] = '\0';
   if (conf->getPorts().isEmpty())
   {
      // Alle Ports aktivieren
      text[0] = '\0';
      tmp = portlist;
      while (tmp != NULL)
      {
         // Port an die Portliste anhaengen
         if (text[0] != '\0') strcat(text,",");
         strcat(text, tmp->name);

         if (mycall[0] == '\0') strcpy(mycall, tmp->addr);
         tmp->ax25 = new AX25(tmp->name, tmp->desc, tmp->dev, tmp->baud, tmp->addr);

         tmp = tmp->next;
      }
   }


   if (conf->getTxMycall().isEmpty())
   {
      // Das eigene Rufzeichen ist unbekannt. Das Standard-Rufzeichen
      // des ersten Ports wird benutzt.
      if (mycall[0] == '\0')
      	conf->setTxMycall( portlist->addr );
      else
      	conf->setTxMycall( mycall );
   }
}


void TopLevel::playSound( int id )
{
#ifdef ENABLE_SOUND
	QString filename = conf->getSound( id );

   if (filename.isEmpty()) return;

   sound->play( filename );
#endif
}

void TopLevel::slotCTRLUp()
{
	chanListTable->switchChannel( SWITCH_UP );
}


void TopLevel::slotCTRLDown()
{
	chanListTable->switchChannel( SWITCH_DOWN );
}
//---------------------------------------------------------------------------
void TopLevel::slotAwayDataChanged()
{
	s_chanlist *tmp;
   QString sTerminal, sConvers;


   if (config->awayStatus == 0)
   	sConvers = "/a\r";
	else
	   sConvers = "/a "+conf->getAwayText(config->awayStatus)+"\r";

   sTerminal = "## "+conf->getAwayText(config->awayStatus)+" ##\r";

	for (tmp=chanlist; tmp; tmp=tmp->next)
   {
   	switch (tmp->channel->userinfo->getType())
      {
      	case TYPE_TERMINAL:
         	tmp->channel->sendMacroString( sTerminal );
         	break;
			case TYPE_CONVERS:
         	tmp->channel->sendMacroString( sConvers );
         	break;
      }
	}
}
//---------------------------------------------------------------------------
void TopLevel::toolbarMoved( Channel *chan, KToolBar *toolbar )
{
	s_chanlist *tmp;
   KConfig *kconfig = KGlobal::config();


   toolbar->saveSettings( kconfig, "ToolBar" );

   // Moved-Signale ueberall disconnecten
	for (tmp=chanlist; tmp; tmp=tmp->next)
		disconnect( tmp->channel, SIGNAL(toolBarPositionChanged(QToolBar *)), tmp->channel, SLOT(slotToolbarMoved()) );

	for (tmp=chanlist; tmp; tmp=tmp->next)
   	if (tmp->channel != chan)
			tmp->channel->updateToolbar( kconfig, "ToolBar" );

	// Moved-Signale ueberall wieder connecten
	for (tmp=chanlist; tmp; tmp=tmp->next)
		connect( tmp->channel, SIGNAL(toolBarPositionChanged(QToolBar *)), tmp->channel, SLOT(slotToolbarMoved()) );
}
//---------------------------------------------------------------------------


/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/*************************************************************************/


int main (int argc, char **argv)
{
   srand(time(NULL));


   if (argc > 1)
   {
      if (!strcmp(argv[1], "--version"))
      {
         #ifdef ENABLE_SOUND
            printf("\nLinKT V%s (%s)\nCopyright (C) 1997-2001 Jochen Sarrazin, DG6VJ\n\n", LINKT_VERSION, DATE);
         #else
            printf("\nLinKT V%s (%s) NO SOUND\nCopyright (C) 1997-2001 Jochen Sarrazin, DG6VJ\n\n", LINKT_VERSION, DATE);
         #endif
         printf("This program is distributed in the hope that it will be useful,\n" \
                "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
                "GNU General Public License for more details.\n\n");
         return 0;
      }
   }

   srand(time(NULL));

#ifdef ENABLE_SOUND
   printf("\nLinKT V%s (%s)\nCopyright (C) 1997-2001 Jochen Sarrazin, DG6VJ\n\n", LINKT_VERSION, DATE);
#else
   printf("\nLinKT V%s (%s) NO SOUND\nCopyright (C) 1997-2001 Jochen Sarrazin, DG6VJ\n\n", LINKT_VERSION, DATE);
#endif

   KCmdLineArgs::init( argc, argv, "linkt", "Linux KDE PR-Terminal", LINKT_VERSION );

   KApplication::addCmdLineOptions();

   mykapp = new KApplication();

   init_globals();
   readBoxCheckFile();

   conf->setFlag( CFG_GPGSUPPORT, isGpgAvailable() );

   toplevel = new TopLevel ();
   toplevel->show ();

   mykapp->setMainWidget( toplevel );
   createDirectories();

   toplevel->checkForFirstRun();

   return mykapp->exec ();
}


/*
 *  void createDirectories()
 * Verzechnisse erstellen, wenn es sie noch nicht gibt.
 */
void createDirectories()
{
   char tmp[500];
   const char *localdir = conf->localDir().latin1();

   mkdir(localdir, 448);
   sprintf(tmp, "%s/7plus", localdir);
   mkdir(tmp, 448);
   sprintf(tmp, "%s/up", localdir);
   mkdir(tmp, 448);
   sprintf(tmp, "%s/down", localdir);
   mkdir(tmp, 448);
   sprintf(tmp, "%s/abin", localdir);
   mkdir(tmp, 448);
   sprintf(tmp, "%s/userdb", localdir);
   mkdir(tmp, 448);
   sprintf(tmp, "%s/log", localdir);
   mkdir(tmp, 448);
}


/*
 *  void init_globals()
 * Globale Variablen aus dem linktrc-File holen und in die config-
 * Struktur packen.
 */
void init_globals()
{
	KConfig *kconfig;


	config = (s_config *) malloc(sizeof(s_config));
	config->starttime = time( NULL );
	config->lastactivity = time( NULL );
	config->awayStatus = 0;		// Hier


	// Konfigurations-File holen
	kconfig = KGlobal::config();

	conf = new Config( kconfig );

	userdata = new UserData();

/*
  // ----------- Away-Texte -----------
  kconfig->setGroup( "Away" );
  if ((tmp = kconfig->readEntry("phone").data()) != NULL)
     config->away.phone = (char *) strdup( tmp );
  else
     config->away.phone = (char *) strdup( "Ma eben telefonieren... [%a]" );

  if ((tmp = kconfig->readEntry("bed").data()) != NULL)
     config->away.bed = (char *) strdup( tmp );
  else
     config->away.bed = (char *) strdup( "Gute n8! Ab in die Falle... [%a]" );

  if ((tmp = kconfig->readEntry("back").data()) != NULL)
     config->away.back = (char *) strdup( tmp );
  else
     config->away.back = (char *) strdup( "Wiiilmaaaaa!!!!! Ich bin wieder daaaaaaa!!! [%a]" );

  if ((tmp = kconfig->readEntry("away").data()) != NULL)
     config->away.away = (char *) strdup( tmp );
  else
     config->away.away = (char *) strdup( "Mal eben wech, %n... Kurz oder laenger... [%a]" );

   strcpy(config->away.text, config->away.away);*/
}



s_boxcheck * newBoxCheckEntry()
{
   s_boxcheck *tmp;


   if (boxcheckroot == NULL)
   {
      // Erster Eintrag
      boxcheckroot = (s_boxcheck *)malloc(sizeof(s_boxcheck));
      tmp = boxcheckroot;
   }
   else
   {
      tmp = boxcheckroot;
      while (tmp->next != NULL) tmp = tmp->next;

      tmp->next = (s_boxcheck *)malloc(sizeof(s_boxcheck));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->enabled = true;
   tmp->type = -1;
   tmp->desc = NULL;
   tmp->title = NULL;
   tmp->board = NULL;
   tmp->lifetime = NULL;
   tmp->size = NULL;
   tmp->sender = NULL;
   tmp->number = NULL;
	tmp->mailtitle = NULL;
   tmp->mustcount = 0;
   tmp->minlen = 0;
   tmp->fields = 0;

   return tmp;
}


void checkBoxCheckEntry( s_boxcheck *bc )
{
	if (bc->desc == NULL)
   {
   	printf("BoxCheck-Error: Description-statement missing. Entry disabled.\n");
      bc->enabled = false;
      return;
   }

   // Der Standard-Typ: BayBox
   if (bc->type == -1)
   	bc->type = BCTYPE_BAYBOX;

   if (bc->title == NULL)
   {
   	printf("BoxCheck-Error: Title in '%s' missing. Entry disabled.\n", bc->desc);
      bc->enabled = false;
      return;
   }

/*   if (bc->board == NULL)
   {
   	printf("BoxCheck-Error: 'pos board'-statement in '%s' missing.\n                Entry disabled.\n", bc->desc);
      bc->enabled = false;
      return;
   }*/

   if (bc->number == NULL)
   {
   	printf("BoxCheck-Error: 'pos number'-statement in '%s' missing.\n                Entry disabled.\n", bc->desc);
      bc->enabled = false;
      return;
   }
}


//   void readBoxCheckFile()
//
// Einlesen der Daten, die fuers BoxCheck benoetigt werden
void readBoxCheckFile()
{
   FILE *f;
   char line[500], cmd[100], str[100], ch;
   s_boxcheck *tmp=NULL;
   int len, pos, linenr=0, i;
   QString fname;
   bool firsterror=true;


   boxcheckroot = NULL;


	// Alle BoxCheck-Eintraege werden durchsucht, wenn dieser Eintrag aus-
   // gewaehlt ist.
	tmp = newBoxCheckEntry();
	tmp->type = 0;
   tmp->desc = (char *) strdup(i18n("check every entry"));
   tmp = NULL;


	fname = locate("data", "linkt/boxcheck.dat");

   sprintf(str, "%s/boxcheck.dat", conf->localDir().latin1());
   if ((f = fopen(str,"r")) == NULL)
   {
   	if (fname.isEmpty()) return;
		if ((f = fopen((const char *)fname, "r")) == NULL) return;
   }


	while (fgets(line, 499, f) != NULL)
	{
   	linenr++;
		KillSpacesLeft(line);
		if (line[0] != '\0' && line[0] != '#' && line[0] != '\n')
		{
      	if ((i = POS('\n', line)) != -1) line[i] = '\0';

			getarg(line, cmd);

			if (!strcmp(cmd, "desc"))
			{
				// Neuer Eintrag
            if (tmp != NULL)
               checkBoxCheckEntry( tmp );
				tmp = newBoxCheckEntry();
            tmp->desc = (char *) strdup(line);
            continue;
         }

         if (tmp == NULL)
         {
         	if (firsterror)
            {
            	printf("Error in boxcheck.dat:\n");
               firsterror = false;
            }
         	printf("Error line %i: 'desc'-statement missing.\n", linenr);
				continue;
         }

         if (!strcmp(cmd, "titel"))
         {
         	// Der Titel des alten Eintrags
				if (tmp->title != NULL)
				{
	         	if (firsterror)
	            {
	            	printf("Error in boxcheck.dat:\n");
	               firsterror = false;
	            }
					printf("Error line %i: Entry already has a titel\n", linenr);
					continue;
				}
				if ((i = POS('\"', line)) == -1)
				{
	         	if (firsterror)
	            {
	            	printf("Error in boxcheck.dat:\n");
	               firsterror = false;
	            }
					printf("Error line %i: Wrong syntax\n", linenr);
					continue;
				}
				else
				{
					len = strlen(line)-i-1;
					memmove(line, line+i+1, len);
					line[len] = '\0';
					if ((i = POS('\"', line)) == -1)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
						printf("Error line %i: Wrong syntax\n", linenr);
						continue;
					}
					else
					{
						line[i] = '\0';
						tmp->title = (char *) strdup(line);
						continue;
					}
				}
         }

         if (!strcmp(cmd, "type"))
         {
         	if (!strcmp(line, "baybox") || !strcmp(line, "thebox"))
            {
            	tmp->type = BCTYPE_BAYBOX;
            	continue;
            }
            if (!strcmp(line, "fbb"))
            {
            	tmp->type = BCTYPE_F6FBB;
            	continue;
            }

         	if (firsterror)
            {
            	printf("Error in boxcheck.dat:\n");
               firsterror = false;
            }
         	printf("Error line %i: Unknown type.\n", linenr);
            continue;
         }

			if (!strcmp(cmd, "pos"))
         {
				getarg(line, cmd);
				if (!strcmp(cmd, "board"))
            {
					if (tmp->board != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a board-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or length in board-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->board = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->board->pos = pos-1;
                  tmp->board->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_BOARD;
						continue;
               }
            }
				if (!strcmp(cmd, "number"))
            {
					if (tmp->number != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a number-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or length in number-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->number = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->number->pos = pos-1;
                  tmp->number->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_NUMBER;
						continue;
               }
            }
				if (!strcmp(cmd, "lifetime"))
            {
					if (tmp->lifetime != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a lifetime-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or length in lifetime-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->lifetime = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->lifetime->pos = pos-1;
                  tmp->lifetime->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_LIFETIME;
						continue;
               }
            }
				if (!strcmp(cmd, "title"))
            {
					if (tmp->mailtitle != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a 'pos title'-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or length in 'pos title'-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->mailtitle = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->mailtitle->pos = pos-1;
                  tmp->mailtitle->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_TITLE;
						continue;
               }
            }
				if (!strcmp(cmd, "size"))
            {
					if (tmp->size != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a size-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or size in number-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->size = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->size->pos = pos-1;
                  tmp->size->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_SIZE;
						continue;
               }
            }
				if (!strcmp(cmd, "sender"))
            {
					if (tmp->sender != NULL)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
               	printf("Error line %i: Entry already has a sender-statement.\n", linenr);
                  continue;
					}
					if (sscanf(line, "%i %i", &pos, &len) != 2)
					{
		         	if (firsterror)
		            {
		            	printf("Error in boxcheck.dat:\n");
		               firsterror = false;
		            }
                  printf("Error line %i: Invalid position or length in sender-statement\n", linenr);
						continue;
					}
               else
               {
						tmp->sender = (s_checkpos *) malloc(sizeof(s_checkpos));
                  tmp->sender->pos = pos-1;
                  tmp->sender->len = len;
                  if (tmp->minlen < pos) tmp->minlen = pos;
                  tmp->fields |= BCFIELD_SENDER;
						continue;
               }
            }
         }

         if (!strcmp(cmd, "char"))
         {
				if (sscanf(line, "%c %i", &ch, &pos) != 2)
            {
	         	if (firsterror)
	            {
	            	printf("Error in boxcheck.dat:\n");
	               firsterror = false;
	            }
            	printf("Error line %i: Syntax error in 'char'-statement.\n", linenr);
            	continue;
            }
            tmp->must[tmp->mustcount].pos = pos-1;
            tmp->must[tmp->mustcount].zeichen = ch;
   			tmp->mustcount++;
				if (tmp->minlen < pos) tmp->minlen = pos;
            continue;
         }

			if (firsterror)
			{
				printf("Error in boxcheck.dat:\n");
				firsterror = false;
			}
         printf("Error line %i: Unknown statement '%s'.\n", linenr, cmd);
      }
   }

   fclose(f);

   if (tmp != NULL)
		checkBoxCheckEntry( tmp );
}


