/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "senddata.h"
#include "channel.h"
#include "flags.h"
//---------------------------------------------------------------------------
SendData::SendData( Channel *chan )
{
	this->chan = chan;
}
//---------------------------------------------------------------------------
SendData::~SendData()
{
}
//---------------------------------------------------------------------------
void SendData::sendString( const char *str )
{
	chan->sendQueue->addString( str, strlen(str), COMP_FLAG );
}
//---------------------------------------------------------------------------
void SendData::sendString( const QString & str )
{
	chan->sendQueue->addString( str.latin1(), str.length(), COMP_FLAG );
}
//---------------------------------------------------------------------------
void SendData::sendData( int len, const char *data )
{
	chan->sendQueue->addString( data, len, COMP_FLAG );
}
//---------------------------------------------------------------------------
void SendData::sendData( const char *data, int len, bool show )
{
	chan->sendQueue->addString( data, len, COMP_FLAG, show );
}
//---------------------------------------------------------------------------
void SendData::statusText( const char *str, int color )
{
	chan->outText( str, strlen(str), color );
}
//---------------------------------------------------------------------------
void SendData::setReceiving( bool enable )
{
	chan->setReceiving( enable );
}
//---------------------------------------------------------------------------
Channel * SendData::getChannel()
{
	return chan;
}
//---------------------------------------------------------------------------
void SendData::sendMessage( const char * text )
{
   if (chan->userinfo->getType() == TYPE_TERMINAL)
      sendString( text );
   else
      chan->outText( text, strlen(text), OUTCOLOR_TXTEXT );
}
//---------------------------------------------------------------------------

