/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "toolbox.moc"

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <linux/ax25.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include "toolbox.h"
#include "string.h"
#include "crc.h"


/* Kopiert 'count' Zeichen von 'src' nach 'dest' ab Position 'start'. 
   src und dest mssen 2 VERSCHIEDENE Strings sein! */
void COPY(char *dest, const char *src, int start, int count)
{
  int from,to,i;

  i = 0;
  from = start;
  to = 0;
  while ((i<count) && (src[from]!='\0')) {
    dest[to] = src[from];
    i++;
    from++;
    to++;
  }
  dest[to] = '\0';
}



/* Wandelt alle Kleinbuchestaben in Grossbuchstaben um */
void Gross(char *str)
{
  size_t i;
  
  i = 0;
  while (i <= strlen(str)) {
    str[i] = (char)toupper(str[i]);
    i++;
  }
}



/* Wandelt alle Grossbuchestaben in Kleinbuchstaben um */
void Klein(char *str)
{
  size_t i;
  
  i=0;
  while (i<=strlen(str)) {
    str[i] = (char)tolower(str[i]);
    i++;
  }
}



/* Wandelt einen Buchstaben in Grossbuchstaben um */
char upcase(char input)
{
  if ((input>=97) && (input<=122)) return(input-32);
  return(input);
}



/* Gibt die erste Position des Zeichens an, oder -1, wenn das Zeichen nicht in
   str ist */
int POS(char zeichen, const char *str)
{
  int i,pos;
  
  i = 0;
  pos = -1;
  while ((str[i]!='\0') && (pos==-1)) {
    if (str[i]==zeichen) pos = i;
    i++;
  }
  
  return pos;
}



/* Gibt die erste Position des Zeichens an, oder -1, wenn das Zeichen nicht in
   str ist */
int nPOS(char zeichen, const char *str, int len)
{
  int i,pos;
  
  i = 0;
  pos = -1;
  while ((len > i) && (pos==-1))
  {
    if (str[i] == zeichen) pos = i;
    i++;
  }
  
  return pos;
}


/* Gibt die letzte Position des Zeichens an, oder -1, wenn das Zeichen nicht in
   str ist */
int lPOS(char zeichen, const char *str)
{
  int i,pos;
  
  i = strlen(str);
  pos = -1;
  while ((i >= 0) && (pos==-1)) {
    if (str[i]==zeichen) pos = i;
    i--;
  }
  
  return pos;
}



/* Schreibt das bergebene Zeichen anz mal in den dest-string */
void StringD(char *dest, int anz, char zeichen)
{
  int i=0;
  while (i<anz) {
    dest[i] = zeichen;
    i++;
  }
  dest[i] = '\0';
}



/* Alle Leerzeichen links vom String lschen */
void KillSpacesLeft(char *str)
{
  int i=0,k=0;	/* anzahl leerzeichen */
  
  while ((str[i] != '\0') && (str[i] == ' ')) i++;
  if (str[i] == '\0') {
    str[0] = '\0';
    return;
  }
  
  /* Nur was machen, wenn sich auch was verndert hat */
  if (i>0) {
    while (str[i] != '\0') {
      str[k] = str[i];
      k++;
      i++;
    }
    str[k] = '\0';
  }
}



/* Alle Leerzeichen rechts lschen */
void KillSpacesRight(char *str)
{
  int i;
  
  i = strlen(str)-1;
  if (i < 0) return;
  
  while ((i>0) && (str[i] == ' ')) i--;
  str[i+1] = '\0';
}


/* Gre des bergebenen Files zurckgeben. Wenn nicht vorhanden wird -1 zurck gegeben. */
long filesize(const char *filename)
{
  FILE *f;
  long i;
  
  f = fopen(filename,"r");
  
  if (f == NULL) return(-1);
  
  fseek(f,0,SEEK_END);
  i = ftell(f);
  fclose(f);
  
  return(i);
}


/* ALLE Leerzeichen in str lschen, und den sich dann ergebenen String nach tmp schreiben */
void KillAllSpaces(char *tmp, char *str)
{
  int i=0, k=0;
  
  while (str[i] != '\0') {
    if (str[i] != ' ') {
      tmp[k] = str[i];
      k++;
    }
    i++;
  }
  tmp[k] = '\0';
}


/* Wenn mehr als ein Leerzeichen nacheinander kommt, werden die brigen Leerzeichen
   gelscht. */
void OnlyOneSpace(char *tmp, const char *str)
{
  int i=0,k=0,anz=0;
  
  while (str[i] != '\0') {
    if (str[i] != ' ') {
      tmp[k] = str[i];
      k++;
      anz = 0;
    }
    else {
      anz++;
      if (anz == 1) {
        tmp[k] = str[i];
        k++;
      }
    }
    
    i++;
  }
  tmp[k] = '\0';
}




/*
 * Lscht count Zeichen aus dem String str ab Position pos
 */
/*void delete(char *str, int pos, int count)
{
  int len;
  
  len = strlen(str);
  
  memmove(str+pos,str+pos+count,len-count);
  str[len-count] = '\0';
}*/


/*
 * Liest Zeichen bis zum nchsten vorkommen von sign aus dem File mit der bergebenen fd ein.
 *
 * Es findet KEINE berlaufprfung statt!
 */
int fdgets(int fd, char *str, char sign)
{
  char tmp[101];
  int count,count_wrote,ok,i,curpos;
  off_t startoffset;
  
  count_wrote = 0;
  
  str[0] = '\0';
  ok = 0;
  while (ok == 0) {
    /* Aktuellen Offset sichern */
    startoffset = lseek(fd,0,SEEK_CUR);
    count = read(fd,tmp,100);
    if (count != 100) ok = 1;
    /* An den Offset vor dem letzten Lesen springen */
    lseek(fd,startoffset,SEEK_SET);
    
    tmp[count] = '\0';
    if ((i = POS(sign,tmp)) == -1) {
      strcat(str,tmp);
    }
    else {
      tmp[i+1] = '\0';
      strcat(str,tmp);
      ok = 1;
    }
  }

  /* Den File-Zeiger neu positionieren */
  curpos = lseek(fd,strlen(str),SEEK_CUR);

  /* Gucken, ob wir am Ende des String sind */
  if (lseek(fd,0,SEEK_END) == curpos) return(-1);	/* Yo, am Ende */
  
  /* Nein, noch nicht am Ende */
  lseek(fd,curpos,SEEK_SET);
  return(0);
}



/* Wandelt den Integer-Wert in Hex-Zahlen um */
void int2hchar(int zahl, char *c1, char *c2)
{
  char hexzahl[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
  
  *c1 = hexzahl[zahl / 16];
  *c2 = hexzahl[zahl % 16];
}




int file_exist(const char *filename)
{
	int fd;
  
	if ((fd = open(filename,O_RDONLY)) == -1)
		return false;

	::close(fd);
	return true;
}


/* Kopiert einen Integer-Array in einen anderen */
void intcpy(int *dest, int *src, int count)
{
  int i=0;
  
  while (i < count)
  {
    dest[i] = src[i];
    i++;
  }
}



unsigned long power(unsigned long k, unsigned long i)
{
  unsigned long answer=1;

  while (i > 0)
  {
    answer *= k;
    i--;
  }
  return(answer);
}


char *dec2bin(unsigned int dec)
{
  int i;
  char *back;
  
  back = (char *)malloc(70);
  back[0] = '\0';
  
  i = 0;
  while (i < 64)
  {
    if ((dec & power(2,i))==0)
       strcat(back,"0");
    else
       strcat(back,"1");
    i++;
  }
  
  return(back);
}






long get_freemem()
{
  int i;
  int free=0,cached=0;
  char tmp[250],tmp2[100],tmp3[100];
  FILE *fs;
  
  if ((fs = fopen("/proc/meminfo","r")) == NULL) return(-1);


  while (fgets(tmp,200,fs) != NULL)
  {
    if ((i = POS(':',tmp)) != -1)
    {
      COPY(tmp2,tmp,0,i);
      COPY(tmp3,tmp,i+1,strlen(tmp)-i-1);
      KillSpacesLeft(tmp3);
      KillSpacesRight(tmp2);
      if ((i = POS(' ',tmp3)) != -1)
      {
        tmp3[i] = '\0';
        
        Gross(tmp2);
        if (!strcmp(tmp2,"MEMFREE"))
           free = atoi(tmp3);
        else if (!strcmp(tmp2,"CACHED"))
                cached = atoi(tmp3);
      }
    }
  }
  
  
  fclose(fs);
  
  return(free+cached);
}



/*
 * Sucht in den ersten count Bytes in str nach search. In search darf kein 0-Byte
 * vorkommen. Zurckgegeben wird die Position von search in str.
 *
 * Ist es garnicht enthalten, wird -1 zurck gegeben.
 */
int memstr(char *str, char *search, int count)
{
  int i,searchlen;
  char *tmp;
  
  searchlen = strlen(search);
  tmp = (char *) malloc(searchlen+1);
  
  i = 0;
  while (i < count-searchlen+1)
  {
    COPY(tmp,str,i,searchlen);
    if (!strcmp(tmp,search))
    {
      free(tmp);
      return(i);
    }
    i++;
  }
  
  free(tmp);
  return(-1);
}



/*
*** get_hex: some compilers have real big trouble when reading hex values from
***          a file with fscanf() that have leading zeros! e.g. 00A will be
***          read as two separate values (0 and A)! grr!!
***          get_hex skips all leading zeros to eliminate the problem.
***
 */

unsigned int get_hex (char *hex)
{
  int i=0;
  int ret=0;

  while (hex[i] == '0')
    i++;
  sscanf(hex+i, "%x", &ret);
  return (ret);
}


void delayus (int us)
{
   struct timeval tv;

   tv.tv_sec = 0;
   tv.tv_usec = us;

   select(0, NULL, NULL, NULL, &tv);
}


char *spec_time(int zeit)
{
  char *str,tmp[500];
  if (zeit < 100)	/* Sekunden */
     sprintf(tmp,"%i seconds",zeit);
  else
  {
    zeit = zeit / 60;		/* Minuten */
    if (zeit < 99)
       sprintf(tmp,"%i minutes",zeit);
    else
    {
       zeit = zeit / 60;	/* Stunden */
       sprintf(tmp,"%i hours",zeit);
    }
  }
  
  str = (char *)strdup(tmp);
  return(str);
}


char lo(unsigned short i)
{
   return (i&0xFF);
}


char hi(unsigned short i)
{
   return ((i>>8) & 0xFF);
}

//---------------------------------------------------------------------------

KIntLineEdit::KIntLineEdit( QWidget *parent, const char *name )
						: QLineEdit( parent, name )
{
}

int KIntLineEdit::getValue()
{
	return atoi( text() );
};


void KIntLineEdit::keyPressEvent( QKeyEvent *e )
{
	char key = e->ascii();

	if( isdigit( key )
		|| ( e->key() == Key_Return) || ( e->key() == Key_Enter    )
		|| ( e->key() == Key_Delete) || ( e->key() == Key_Backspace)
		|| ( e->key() == Key_Left  ) || ( e->key() == Key_Right    ))
	{
		QLineEdit::keyPressEvent( e );
      return;
	}
	else
	{
		e->ignore();
		return;
	}
};
//---------------------------------------------------------------------------
void getarg( char *line, char *arg )
{
   int i;
   int len;


   if ((i = POS(' ', line)) == -1)
   {
      len = strlen(line);
      memcpy(arg, line, len);
      arg[len] = '\0';
      line[0] = '\0';
      return;
   }

   len = strlen(line)-i-1;
   memcpy(arg, line, i);
   arg[i] = '\0';
   memmove(line, line+i+1, len);
   line[len] = '\0';
}
//---------------------------------------------------------------------------
void getcharg( char *line, char *arg, char ch )
{
   int i;
   int len;


   if ((i = POS(ch, line)) == -1)
   {
      len = strlen(line);
      memcpy(arg, line, len);
      arg[len] = '\0';
      line[0] = '\0';
      return;
   }

   len = strlen(line)-i-1;
   memcpy(arg, line, i);
   arg[i] = '\0';
   memmove(line, line+i+1, len);
   line[len] = '\0';
}
//---------------------------------------------------------------------------
// Sucht nach GnuPG und gibt TRUE zurueck, wenn installiert.
bool isGpgAvailable()
{
	int status;
	if (fork() == 0)
   {
		execlp("gpg", "gpg", "--version", 0);
		_exit(25);
	}
   else
   {
      wait(&status);
      printf("%i\n", status);
   }

   if (status == 25) return false;
   return true;
}
//---------------------------------------------------------------------------
const char * getReadableTime( time_t seconds )
{
	static char tmp[50];


	if (seconds < 120)
   {
   	sprintf( tmp, "%li seconds", seconds );
      return tmp;
   }

  	if (seconds % 60 != 0)
     	sprintf( tmp, "%li hours and %li seconds", seconds/60, seconds%60 );
	else
     	sprintf( tmp, "%li hours", seconds/60 );
	return tmp;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

