/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "dxcluster.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "toolbox.h"
#include "global.h"
#include <errno.h>



#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif

#define RADIUS          6370.0



DXCluster::DXCluster()
{
   readDxcDat();
}


DXCluster::~DXCluster()
{
   s_dxc_dat *tmp;

   while (dxcroot != NULL)
   {
      tmp = dxcroot;
      dxcroot = dxcroot->next;
      if (tmp->prefixes != NULL)
         free(tmp->prefixes);
      if (tmp->desc != NULL)
         free(tmp->desc);
      free(tmp);
   }
}


void DXCluster::readDxcDat()
{
   FILE *f;
   char tmp[1000], prefixes[1000], desc[1000], tmp2[500];
   int i, len, zone;
   float laenge, breite;
   s_dxc_dat *listtmp;


   dxcroot = NULL;
   if ((f = fopen(config->dxdata_file, "r")) == NULL) return;

   while (fgets(tmp, 999, f) != NULL)
   {
      if ((i = POS('\r', tmp)) != -1) tmp[i] = '\0';
      if ((i = POS('\n', tmp)) != -1) tmp[i] = '\0';

      // Mindestens zwei Doppelpunkte
      if ((i = POS(':', tmp)) != -1)
         if ((i = POS(':', tmp+i+1)) != -1)
         {
            // Neuer Eintrag in die Liste

            // Prefixes dieses Landes
            i = POS(':', tmp);
            memcpy(prefixes, tmp, i);
            prefixes[i] = '\0';
            len = strlen(tmp)-i-1;
            memmove(tmp, tmp+i+1, len);
            tmp[len] = '\0';

            // Beschreibung des Landes
            i = POS(':', tmp);
            memcpy(desc, tmp, i);
            desc[i] = '\0';
            len = strlen(tmp)-i-1;
            memmove(tmp, tmp+i+1, len);
            tmp[len] = '\0';

            // Zone
            i = POS(':', tmp);
            memcpy(tmp2, tmp, i);
            tmp2[i] = '\0';
            zone = atoi(tmp2);
            len = strlen(tmp)-i-1;
            memmove(tmp, tmp+i+1, len);
            tmp[len] = '\0';

            // Breite
            i = POS(';', tmp);
            memcpy(tmp2, tmp, i);
            tmp2[i] = '\0';
            breite = atof(tmp2);
            len = strlen(tmp)-i-1;
            memmove(tmp, tmp+i+1, len);
            tmp[len] = '\0';

            // Laenge
            i = POS(';', tmp);
            memcpy(tmp2, tmp, i);
            tmp2[i] = '\0';
            laenge = atof(tmp2);
            len = strlen(tmp)-i-1;
            memmove(tmp, tmp+i+1, len);
            tmp[len] = '\0';

            if (dxcroot == NULL)
            {
               // Erster Eintrag
               dxcroot = (s_dxc_dat *)malloc(sizeof(s_dxc_dat));
               listtmp = dxcroot;
            }
            else
            {
               listtmp = dxcroot;
               while (listtmp->next != NULL) listtmp = listtmp->next;

               listtmp->next = (s_dxc_dat *)malloc(sizeof(s_dxc_dat));
               listtmp = listtmp->next;
            }

            listtmp->next = NULL;
            listtmp->prefixes = (char *) strdup(prefixes);
            listtmp->desc = (char *) strdup(desc);
            listtmp->zone = zone;
            listtmp->north = breite;
            listtmp->east = laenge;
         }
   }

   fclose(f);
}


//   void DXCluster::getCallDescription( const char *call )
//
// Gibt Informationen zu dem uebergebenen Rufzeichen zurueck
s_dxc_dat * DXCluster::getCallDescription( const char *call )
{
   s_dxc_dat *tmp;
   char str[500], str2[500];
   int i, len;

   tmp = dxcroot;

   while (tmp != NULL)
   {
      // Beginnt dieses Rufzeichen mit einem String aus dem dxc.dat - File?
      strcpy(str, tmp->prefixes);
      do
      {
         if ((i = POS(',', str)) == -1)
         {
            strcpy(str2, str);
            str[0] = '\0';
         }
         else
         {
            memcpy(str2, str, i);
            str2[i] = '\0';

            len = strlen(str)-i-1;
            memmove(str, str+i+1, len);
            str[len] = '\0';
         }

         if (strstr(call, str2) == call)
            return tmp;
      }
      while (str[0] != '\0');

      tmp = tmp->next;
   }

   return NULL;
}


const char * DXCluster::courseName(double a)
{
  if (a <=  11.25) return "North";
  if (a <=  33.75) return "North-North-East";
  if (a <=  56.25) return "North-East";
  if (a <=  78.75) return "East-North-East";
  if (a <= 101.25) return "East";
  if (a <= 123.75) return "East-South-East";
  if (a <= 146.25) return "South-East";
  if (a <= 168.75) return "South-South-East";
  if (a <= 191.25) return "South";
  if (a <= 213.75) return "South-South-West";
  if (a <= 236.25) return "South-West";
  if (a <= 258.75) return "West-South-West";
  if (a <= 281.25) return "West";
  if (a <= 303.75) return "West-North-West";
  if (a <= 326.25) return "North-West";
  if (a <= 348.75) return "North-North-West";
  if (a <= 371.25) return "North";
  return "???";
}


void DXCluster::calcStnInfos(double north, double east, float & dist, double & degree)
{
   Locator loc(north, east);


   if (config->mypos != NULL)
   {
      dist = config->mypos->m_getDistanceTo(loc);
      degree = config->mypos->m_getDirectionTo(loc);
   }
   else
   {
      dist = 0;
      degree = 0;
   }
}



