.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutTimerFunc 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutTimerFunc - registers a timer callback to be triggered in a
specified number of milliseconds. 
.SH SYNTAX
.nf
.LP
void glutTimerFunc(unsigned int msecs,
		   void (*func)(int value), value);
.fi
.SH ARGUMENTS
.IP \fImsecs\fP 1i
Number of milliseconds to pass before calling the callback.
.IP \fIfunc\fP 1i
The timer callback function.
.IP \fIvalue\fP 1i
Integer value to pass to the timer callback.
.SH DESCRIPTION
glutTimerFunc registers the timer callback func to be triggered in at
least msecs milliseconds. The value parameter to the timer callback
will be the value of the value parameter to glutTimerFunc. Multiple
timer callbacks at same or differing times may be registered
simultaneously. 

The number of milliseconds is a lower bound on the time before the
callback is generated. GLUT attempts to deliver the timer callback as
soon as possible after the expiration of the callback's time interval. 

There is no support for canceling a registered callback. Instead, ignore a
callback based on its value parameter when it is triggered. 
.SH SEE ALSO
glutIdleFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
