/***************************************************************************
                          kgroupeduca.cpp  -  description
                             -------------------
    begin                : Thu Sep 7 2000
    copyright            : (C) 2000 by Javier Campos Morales
    email                : javi_c@ctv.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgroupeduca.h"
#include "kgroupeduca.moc"
#include "kcheckeduca.h"
#include "kradioeduca.h"
#include <iostream.h>
#include <qscrollbar.h>

KGroupEduca::KGroupEduca(QWidget *parent, const char *name ) : QVButtonGroup("Answers", parent, name)
{
		sv = new QScrollView(this);
		sv->setVScrollBarMode(QScrollView::Auto);
		sv->setHScrollBarMode(QScrollView::Auto);
		sv->setFrameStyle( QFrame::NoFrame | QFrame::Plain );
		vbox_2 = new QVBox( sv->viewport() );
    vbox_2->setSpacing( 6 );
    vbox_2->setMargin( 11 );
		sv->viewport()->setBackgroundMode( vbox_2->backgroundMode() );
		sv->setStaticBackground(true);
		sv->addChild( vbox_2 );
		TypeMode = Radio;
}

KGroupEduca::~KGroupEduca(){
}

/** Insert a check or radio button */
void KGroupEduca::insertAnswer( QString text)
{
	QButton *Answer = 0;

	switch( TypeMode )
	{
	case Radio:
		Answer = new KRadioEduca( vbox_2 );
		break;
	case Check:
		Answer = new KCheckEduca( vbox_2 );
		break;
	}
	Answer->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0 ) );
	Answer->setText( text );
	Answer->show();
	this->insert(Answer);
}

/** Set type */
void KGroupEduca::setType(int Type)
{
TypeMode = Type;
}

/** Clear all kradio or kcheck answers */
void KGroupEduca::clearAnswers()
{
		for( unsigned int i=0 ; i<10 ; ++i )
		{	
		QButton *tmpButton;
		if( (tmpButton = this->find(i)) )
				this->remove(tmpButton);
				delete tmpButton;
		}

}

/** Return if is checked radio or check buttons */
bool KGroupEduca::isChecked(int id)
{
	switch( TypeMode )
		{
		case Radio:
			{
			KRadioEduca *tmpRadioButton = (KRadioEduca*) this->find(id);
			if(tmpRadioButton != 0) return tmpRadioButton->isChecked();
			}
			break;
		case Check:
			{
			KRadioEduca *tmpCheckButton = (KRadioEduca*) this->find(id);
			if(tmpCheckButton != 0) return tmpCheckButton->isChecked();
			}
			break;
		}
	return 0;
}
