/***************************************************************************
                            kde_KActionCollection.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KACTIONCOLLECTION
#define KDE_KACTIONCOLLECTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A managed set of KAction objects.
 
 @short *
 A managed set of KAction objects.
*/
kde_KActionCollection * kde_new_KActionCollection(qt_QWidget * parent, char* name, kde_KInstance* instance);

/** *
 Use this constructor if you want the collection's actions to restrict
 their accelerator keys to @p watch rather than the @p parent.  If
 you don't require shortcuts, you can pass a null to the @p watch parameter.
   
*/
kde_KActionCollection * kde_new_KActionCollection1(qt_QWidget * watch, qt_QObject * parent, char* name, kde_KInstance* instance);
kde_KActionCollection * kde_new_KActionCollection2(kde_KActionCollection* copy);
void kde_del_KActionCollection( kde_KActionCollection* p );

/** *
 This sets the widget to which the keyboard shortcuts should be attached.
 You only need to call this if a null pointer was passed in the constructor.
   
*/
void kde_KActionCollection_setWidget(kde_KActionCollection* instPointer,qt_QWidget * widget);

/** *
 This indicates whether new actions which are created in this collection
 should have their keyboard shortcuts automatically connected on
 construction.  Set to 'false' if you will be loading XML-based settings.
 This is automatically done by KParts.  The default is 'true'.
   
*/
void kde_KActionCollection_setAutoConnectShortcuts(kde_KActionCollection* instPointer,int arg1);
int kde_KActionCollection_isAutoConnectShortcuts(kde_KActionCollection* instPointer);

/** *
 Doc/View model.  This lets you add the action collection of a document
 to a view's action collection.
   
*/
int kde_KActionCollection_addDocCollection(kde_KActionCollection* instPointer,kde_KActionCollection* pDoc);

/** * @deprecated  Deprecated because of ambiguous name.  Use kaccel() 
*/
kde_KAccel* kde_KActionCollection_accel(kde_KActionCollection* instPointer);
kde_KAccel* kde_KActionCollection_accel1(kde_KActionCollection* instPointer);

/** * Returns the KAccel object of the most recently set widget. 
*/
kde_KAccel* kde_KActionCollection_kaccel(kde_KActionCollection* instPointer);
kde_KAccel* kde_KActionCollection_kaccel1(kde_KActionCollection* instPointer);

/** * @internal, for KAction::kaccelCurrent() 
*/
kde_KAccel* kde_KActionCollection_builderKAccel(kde_KActionCollection* instPointer);

/** * Returns the KAccel object associated with widget #. 
*/
unsigned int kde_KActionCollection_count(kde_KActionCollection* instPointer);
int kde_KActionCollection_isEmpty(kde_KActionCollection* instPointer);
kde_KAction* kde_KActionCollection_action(kde_KActionCollection* instPointer,int index);
kde_KAction* kde_KActionCollection_action1(kde_KActionCollection* instPointer,char* name, char* classname);
qt_QStringList* kde_KActionCollection_groups(kde_KActionCollection* instPointer);
//KActionPtrList kde_KActionCollection_actions(kde_KActionCollection* instPointer,qt_QString * group);
//KActionPtrList kde_KActionCollection_actions1(kde_KActionCollection* instPointer);

/** *
 Used for reading shortcut configuration from a non-XML rc file.
   
*/
int kde_KActionCollection_readShortcutSettings(kde_KActionCollection* instPointer,qt_QString * sConfigGroup, kde_KConfigBase* pConfig);

/** *
 Used for writing shortcut configuration to a non-XML rc file.
   
*/
int kde_KActionCollection_writeShortcutSettings(kde_KActionCollection* instPointer,qt_QString * sConfigGroup, kde_KConfigBase* pConfig);
void kde_KActionCollection_setInstance(kde_KActionCollection* instPointer,kde_KInstance* instance);
kde_KInstance* kde_KActionCollection_instance(kde_KActionCollection* instPointer);

/** *
 Use this to tell the KActionCollection what rc file its configuration
 is stored in.
   
*/
void kde_KActionCollection_setXMLFile(kde_KActionCollection* instPointer,qt_QString * arg1);
qt_QString * kde_KActionCollection_xmlFile(kde_KActionCollection* instPointer);
void kde_KActionCollection_setHighlightingEnabled(kde_KActionCollection* instPointer,int enable);
int kde_KActionCollection_highlightingEnabled(kde_KActionCollection* instPointer);
void kde_KActionCollection_connectHighlight(kde_KActionCollection* instPointer,qt_QWidget * container, kde_KAction* action);
void kde_KActionCollection_disconnectHighlight(kde_KActionCollection* instPointer,qt_QWidget * container, kde_KAction* action);
kde_KActionCollection * kde_new_KActionCollection3(qt_QObject * parent, char* name, kde_KInstance* instance);
void kde_KActionCollection_insert(kde_KActionCollection* instPointer,kde_KAction* arg1);
void kde_KActionCollection_remove(kde_KActionCollection* instPointer,kde_KAction* arg1);
kde_KAction* kde_KActionCollection_take(kde_KActionCollection* instPointer,kde_KAction* arg1);

/** *
 Clears the entire actionCollection, deleting all actions.

*/
void kde_KActionCollection_clear(kde_KActionCollection* instPointer);
void kde_KActionCollection_virtual_hook(kde_KActionCollection* instPointer,int identifier, void* data);

#endif
