/***************************************************************************
                            kde_KAnimWidget.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KANIMWIDGET
#define KDE_KANIMWIDGET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is a widget used to display animation using multiple
 individual pixmaps.  This widget allows you to deal with variable
 size icons (e.g., ones that will change based on a global setting)
 as it loads the icons internally.  All you need to do is pass along
 a list of icon names and their size and everything else is taken
 care of.

 This widget also emits a 'clicked()' signal when it received a
 mouse press event.

 A quick example:
 <pre>
 QStringList icons;
 icons.append("one");
 icons.append("two");
 icons.append("three");
 KAnimWidget *anim = new KAnimWidget(icons, 0, this);
 anim->start();
 </pre>

 That example will search for the pixmaps "one.png", "two.png", and
 "three.png" in the share/icons/small/ directories as well as the
 app's pics directory.

 @author Kurt Granroth <granroth@kde.org>
 
 @short Widget animated using individual icons.
*/

/** *
 This is the most common constructor.  Pass along the name of the
 animated icons to use (e.g., "kde") for the animation and an
 optional size to load and you're set.  If you omit the size, the
 default size will be used.

*/
kde_KAnimWidget * kde_new_KAnimWidget(qt_QString * icons, int size, qt_QWidget * parent, char* name);

/** *
 Default constructor.  This will not do anything until you use
 @ref setIcons() later.

*/
kde_KAnimWidget * kde_new_KAnimWidget1(qt_QWidget * parent, char* name);

/** *
 Destructor
   
*/
void kde_del_KAnimWidget( kde_KAnimWidget* p );

/** *
 Starts the animation from frame 1
   
*/
void kde_KAnimWidget_start(kde_KAnimWidget* instPointer);

/** *
 Stops the animation.  This will also reset the widget to frame 1.
   
*/
void kde_KAnimWidget_stop(kde_KAnimWidget* instPointer);

/** *
 Sets the size of the icons.

*/
void kde_KAnimWidget_setSize(kde_KAnimWidget* instPointer,int size);

/** *
 Sets the name of the animated icons to load.  This will use the
 KIconLoader::loadAnimated method for the actual loading.

*/
void kde_KAnimWidget_setIcons(kde_KAnimWidget* instPointer,qt_QString * icons);
void kde_KAnimWidget_drawContents(kde_KAnimWidget* instPointer,qt_QPainter * p);
void kde_KAnimWidget_virtual_hook(kde_KAnimWidget* instPointer,int identifier, void* data);
void kde_KAnimWidget_slotTimerUpdate(kde_KAnimWidget* instPointer);
void kde_KAnimWidget_updateIcons(kde_KAnimWidget* instPointer);

#endif
