/***************************************************************************
                            kde_KMidSimpleAPI.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMIDSIMPLEAPI
#define KDE_KMIDSIMPLEAPI

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Simple API covering most of the uses of libkmid.

 You can use the members of this class in pure C applications, just by using
 the same name as the corresponding function member. 

 Suppose you're developing a game and you want to play some background music
 while the user is playing. You only have to call :

 When the user decides to quit the game, use 

 to stop the music and release the memory allocated by libkmid.

 @author Antonio Larrosa Jimenez <larrosa@kde.org> 
 
 @version 0.9.5 17/01/2000

 @short A very simple API around the rest of libkmid.

*/

/** *
 Initializes libkmid. Creates the DeviceManager object, and initializes
 some variables that will be used later.

*/
int kde_KMidSimpleAPI_kMidInit( );

/** *
 Loads a song that will be played with the next call to @ref kMidPlay().
     
*/
int kde_KMidSimpleAPI_kMidLoad( char* filename);

/** *
 Plays the song currently loaded with @ref kMidLoad().
 kMidPlay forks in order to play the song in a different process, it
 exits inmediately, so that the application can follow the normal
 execution flow while the sone is played.

 If loop is 0 the song is played once and then the child process
 finishes. If loop is 1, the song is played repeatedly until
 @ref #kMidStop() is called. You can call @ref #kMidStop() anytime you want
 (also if loop is 0) to stop the song and kill the child process.

*/
int kde_KMidSimpleAPI_kMidPlay( int loop);

/** *
 Stops playing a song inmediatly. It doesn't return until the child
 process that is playing the song is terminated.

*/
int kde_KMidSimpleAPI_kMidStop( );

/** *
 Releases the memory allocated by libkmid. To continue playing, you must
 first make a(nother) call to @ref #kMidInit().
     
*/
void kde_KMidSimpleAPI_kMidDestruct( );

/** *
 Returns 1 if the library is playing a song, and 0 if it's not.

*/
int kde_KMidSimpleAPI_kMidIsPlaying( );

/** *
 Returns the number of MIDI devices  ( MIDI ports + synthesizers )

*/
int kde_KMidSimpleAPI_kMidDevices( );

/** *
 Returns the name of the i-th device . In case libkmid wasn't yet
 initialized ( see @ref #kMidInit() ), the return value is NULL, and in
 case the parameter has a value out of the valid range 
 ( see @ref #kMidDevices() ) it returns an empty string.

*/
char* kde_KMidSimpleAPI_kMidName( int i);

/** *
 Returns the type of the i-th device . In case libkmid wasn't yet
 initialized ( see @ref #kMidInit() ), the return value is NULL, and in
 case the parameter has a value out of the valid range 
 ( see @ref #kMidDevices() ) it returns an empty string.

*/
char* kde_KMidSimpleAPI_kMidType( int i);

/** *
 Sets the MIDI device to use when playing a song.

*/
void kde_KMidSimpleAPI_kMidSetDevice( int i);

/** *
 Sets the Midi Mapper to use. Most of the users won't need a midi mapper,
 but there're still non-General Midi synthesizers out there, and people
 with one of those will get much better sound quality by using a MIDI
 mapper. 

 Please have a look at KMid's documentation for more information
 about MIDI mappers and how to write a MIDI mapper for your keyboard.
     
*/
void kde_KMidSimpleAPI_kMidSetMidiMapper( char* mapfilename);

/** *
 Returns the version number of libkmid, i.e. "0.9.5" or "1.0 Beta"
     
*/
char* kde_KMidSimpleAPI_kMidVersion( );

/** *
 Returns the copyright notice that applications using libkmid should print
 to the user in an about box or somewhere visible.
 I.e. 

 "LibKMid 0.9.5 (C) 1997-2000 Antonio Larrosa Jimenez <larrosa@kde.org>. Spain"
     
*/
char* kde_KMidSimpleAPI_kMidCopyright( );

#endif
