/***************************************************************************
                            kde_KURLCompletion.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURLCOMPLETION
#define KDE_KURLCOMPLETION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class does completion of URLs including user directories (~user)
 and environment variables.  Remote URLs are passed to KIO.

 @author David Smith <dsmith@algonet.se>

 @version $Id: kde_KURLCompletion.h,v 1.4 2002/11/25 12:24:36 rdale Exp $
 
 @short Completion of a single URL.
*/
#define KURLCOMPLETION_ExeCompletion	1
#define KURLCOMPLETION_FileCompletion	0
#define KURLCOMPLETION_DirCompletion	1

/** *
 Constructs a KURLCompletion object in FileCompletion mode.
	 
*/
kde_KURLCompletion * kde_new_KURLCompletion();

/** *
 This overloaded constructor allows you to set the Mode to ExeCompletion
 or FileCompletion without using @ref setMode. Default is FileCompletion
	 
*/
kde_KURLCompletion * kde_new_KURLCompletion1(int arg1);

/** *
 Destructs the KURLCompletion object.
	 
*/
void kde_del_KURLCompletion( kde_KURLCompletion* p );

/** *
 Finds completions to the given text.

 Remote URLs are listed with KIO. For performance reasons, local files
 are listed with KIO only if KURLCOMPLETION_LOCAL_KIO is set.
 The completion is done asyncronously if KIO is used.

 Returns the first match for user, environment, and local dir completion
 and QString::null for asyncronous completion (KIO).
	 
*/
qt_QString * kde_KURLCompletion_makeCompletion(kde_KURLCompletion* instPointer,qt_QString * arg1);

/** *
 Sets the current directory (used as base for completion)
 Default = $HOME.
	 
*/
void kde_KURLCompletion_setDir(kde_KURLCompletion* instPointer,qt_QString * dir);

/** *
 Returns the current directory.
	 
*/
qt_QString * kde_KURLCompletion_dir(kde_KURLCompletion* instPointer);

/** *
 Returns true if asyncronous completion is in progress.
	 
*/
int kde_KURLCompletion_isRunning(kde_KURLCompletion* instPointer);

/** *
 Stops asyncronous completion.
	 
*/
void kde_KURLCompletion_stop(kde_KURLCompletion* instPointer);

/** *
 Returns the completion mode: exe or file completion (default FileCompletion)
	 
*/
int kde_KURLCompletion_mode(kde_KURLCompletion* instPointer);

/** *
 Changes the completion mode: exe or file completion
	 
*/
void kde_KURLCompletion_setMode(kde_KURLCompletion* instPointer,int mode);

/** *
 Returns whether environment variables are completed and
 whether they are replaced internally while finding completions.
 Default is enabled.
	 
*/
int kde_KURLCompletion_replaceEnv(kde_KURLCompletion* instPointer);

/** *
 Enables/disables completion and replacement (internally) of
 environment variables in URLs. Default is enabled.
	 
*/
void kde_KURLCompletion_setReplaceEnv(kde_KURLCompletion* instPointer,int replace);

/** *
 Returns whether ~username is completed and whether ~username
 is replaced internally with the user's home directory while
 finding completions. Default is enabled.
	 
*/
int kde_KURLCompletion_replaceHome(kde_KURLCompletion* instPointer);

/** *
 Enables/disables completion of ~username and replacement
 (internally) of ~username with the user's home directory.
 Default is enabled.
	 
*/
void kde_KURLCompletion_setReplaceHome(kde_KURLCompletion* instPointer,int replace);

/** *
 Replaces username and/or environment variables, depending on the
 current settings and returns the filtered url. Only works with
 local files, i.e. returns back the original string for non-local
 urls.
	 
*/
qt_QString * kde_KURLCompletion_replacedPath(kde_KURLCompletion* instPointer,qt_QString * text);
void kde_KURLCompletion_postProcessMatch(kde_KURLCompletion* instPointer,qt_QString* match);
void kde_KURLCompletion_postProcessMatches(kde_KURLCompletion* instPointer,qt_QStringList* matches);
void kde_KURLCompletion_postProcessMatches1(kde_KURLCompletion* instPointer,kde_KCompletionMatches* matches);
void kde_KURLCompletion_virtual_hook(kde_KURLCompletion* instPointer,int identifier, void* data);
//void kde_KURLCompletion_slotEntries(kde_KURLCompletion* instPointer,kde_Job* arg1, kde_UDSEntryList* arg2);
void kde_KURLCompletion_slotIOFinished(kde_KURLCompletion* instPointer,kde_Job* arg1);

#endif
