/***************************************************************************
                            KSocket.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 You can connect this socket to any Internet address.

 The socket gives you three signals: When ready for reading,
 ready for writing or if the connection is broken.
 Using {@link #socket} you get a file descriptor
 which you can use with the usual UNIX function like {@link #write} or
  {@link #read}.
 If you have already such a socket identifier you can construct a KSocket
 on this identifier.

 If {@link #socket} delivers a value of -1 or less, the connection
 was not successful.

 See {@link KSocketSignals} for signals emitted by KSocket.

 

 @author Torben Weis <weis@uni-frankfurt.de>

 @version $Id: KSocket.java,v 1.8 2002/11/26 04:17:34 rdale Exp $

 @short A TCP/IP client socket.
 
*/
public class KSocket extends QObject  {
	protected KSocket(Class dummy){super((Class) null);}

	private native void newKSocket( int _sock);

/** 
 Constructs a KSocket with the provided file descriptor.

*/
	public KSocket( int _sock) {
		super((Class) null);
		newKSocket( _sock);
	}
	private native void newKSocket( String _host, short _port, int timeOut);

/** 
 Creates a socket and connects to a host.

*/
	public KSocket( String _host, short _port, int timeOut) {
		super((Class) null);
		newKSocket( _host, _port, timeOut);
	}
	private native void newKSocket( String _host, short _port);
	public KSocket( String _host, short _port) {
		super((Class) null);
		newKSocket( _host, _port);
	}
	private native void newKSocket( String _path);

/** 
 Connects to a UNIX domain socket.

*/
	public KSocket( String _path) {
		super((Class) null);
		newKSocket( _path);
	}

/** 
 Destructor. Closes the socket if it is still open.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a file descriptor for this socket.

*/
	public native int socket();

/** 
 Enables the socket for reading.

 If you enable read mode, the socket will emit the signal
 {@link #readEvent} whenever there is something to read out of this
 socket.

*/
	public native void enableRead( boolean enable);

/** 
 Enables the socket for writing.

 If you enable write mode, the socket will emit the signal
 {@link #writeEvent} whenever the socket is ready for writing.

 Warning: If you forget to call enableWrite(false) when you are
 not ready to send data, you will get lots of writeEvent() signals,
 in the order of thousands a second !

*/
	public native void enableWrite( boolean enable);

/** 
 Return address.
 This function is dumb. Don't ever use it
 if you need the peer address of this socket, use {@link KExtendedSocket#peerAddress}
 instead

     
*/
	public native long ipv4_addr();

/** 
 Connected to the writeNotifier.

 Called when
  the socket is ready for writing.

*/
	public native void slotWrite( int x);

/** 
 Connected to the readNotifier.

 Called when
  the socket is ready for reading.

*/
	public native void slotRead( int x);

/** 
  A small wrapper around {@link #gethostbyname} and such.
  Don't use this in new programs. Use {@link KExtendedSocket#lookup}

      
*/
	public static native boolean initSockaddr( int server_name, String hostname, short port, int domain);
	public static native boolean initSockaddr( int server_name, String hostname, short port);
	protected native boolean connect( String _host, short _port, int timeout);
	protected native boolean connect( String _host, short _port);
	protected native boolean connect( String _path);
}
