/***************************************************************************
                            KPixmapEffect.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPIXMAPEFFECT_H
#define KPIXMAPEFFECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class includes various pixmap-based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short 
 This class includes various pixmap-based graphical effects.
*/
@class KPixmap;
@class QSize;
@class QColor;

@interface  KPixmapEffect : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a gradient from color a to color b of the specified type.

*/
+ (KPixmap*) gradient: (KPixmap*)pixmap ca: (QColor *)ca cb: (QColor *)cb type: (int)type ncols: (int)ncols;
+ (KPixmap*) gradient: (KPixmap*)pixmap ca: (QColor *)ca cb: (QColor *)cb type: (int)type ;

/** 
 Creates an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
+ (KPixmap*) unbalancedGradient: (KPixmap*)pixmap ca: (QColor *)ca cb: (QColor *)cb type: (int)type xfactor: (int)xfactor yfactor: (int)yfactor ncols: (int)ncols;
+ (KPixmap*) unbalancedGradient: (KPixmap*)pixmap ca: (QColor *)ca cb: (QColor *)cb type: (int)type ;

/** 
 Creates a pixmap of a given size with the given pixmap.

 if the
 given size is bigger than the size of the pixmap, the pixmap is
 tiled.

*/
+ (KPixmap*) createTiled: (KPixmap*)pixmap size: (QSize *)size;

/** 
 Either brightens or dims a pixmap by a specified ratio.

*/
+ (KPixmap*) intensity: (KPixmap*)pixmap ratio: (float)ratio;

/** 
 Modifies the intensity of a pixmap's RGB channel component.

*/
+ (KPixmap*) channelIntensity: (KPixmap*)pixmap ratio: (float)ratio channel: (int)channel;

/** 
 Blends the provided pixmap into a background of the indicated color.

*/
+ (KPixmap*) blend: (KPixmap*)pixmap initial_intensity: (float)initial_intensity bgnd: (QColor *)bgnd eff: (int)eff anti_dir: (BOOL)anti_dir ncols: (int)ncols;
+ (KPixmap*) blend: (KPixmap*)pixmap initial_intensity: (float)initial_intensity bgnd: (QColor *)bgnd eff: (int)eff ;

/** 
 Builds a hash on any given pixmap.

*/
+ (KPixmap*) hash: (KPixmap*)pixmap lite: (int)lite spacing: (unsigned int)spacing ncols: (int)ncols;
+ (KPixmap*) hash: (KPixmap*)pixmap ;

/** 
 Creates a pattern from a pixmap.

 The given pixmap is "flattened"
 between color a to color b.

*/
+ (KPixmap*) pattern: (KPixmap*)pixmap size: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb ncols: (int)ncols;
+ (KPixmap*) pattern: (KPixmap*)pixmap size: (QSize *)size ca: (QColor *)ca cb: (QColor *)cb ;

/** 
 Recolors a pixmap.

 The most dark color will become color a,
 the most bright one color b, and in between.

*/
+ (KPixmap*) fade: (KPixmap*)pixmap val: (double)val color: (QColor *)color;

/** 
 Converts a pixmap to grayscale.

*/
+ (KPixmap*) toGray: (KPixmap*)pixmap fast: (BOOL)fast;
+ (KPixmap*) toGray: (KPixmap*)pixmap ;

/** 
 Desaturates a pixmap.

*/
+ (KPixmap*) desaturate: (KPixmap*)pixmap desat: (float)desat;
+ (KPixmap*) desaturate: (KPixmap*)pixmap ;

/** 
 Modifies the contrast of a pixmap.

*/
+ (KPixmap*) contrast: (KPixmap*)pixmap c: (int)c;

/** 
 Dithers a pixmap using Floyd-Steinberg dithering for low-color
 situations.

*/
+ (KPixmap*) dither: (KPixmap*)pixmap palette: (QColor*)palette size: (int)size;

/** 
 Calculate a 'selected' pixmap, for instance a selected icon
 on the desktop.

*/
+ (KPixmap*) selectedPixmap: (KPixmap*)pixmap col: (QColor *)col;
+ (int) VerticalGradient;
+ (int) HorizontalGradient;
+ (int) DiagonalGradient;
+ (int) CrossDiagonalGradient;
+ (int) PyramidGradient;
+ (int) RectangleGradient;
+ (int) PipeCrossGradient;
+ (int) EllipticGradient;
+ (int) Red;
+ (int) Green;
+ (int) Blue;
+ (int) NorthLite;
+ (int) NWLite;
+ (int) WestLite;
+ (int) SWLite;
+ (int) SouthLite;
+ (int) SELite;
+ (int) EastLite;
+ (int) NELite;
@end

#endif
