/***************************************************************************
                            KProtocolManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROTOCOLMANAGER_H
#define KPROTOCOLMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Provides information about I/O (Internet, etc.) settings chosen/set
 by the end user.

 KProtocolManager has a heap of static functions that allows only read
 access to KDE's IO related settings. These include proxy, cache, file
 transfer resumption, timeout and user-agent related settings.

 The information provided by this class is generic enough to be applicable
 to any application that makes use of KDE's IO sub-system.  Note that this
 mean the proxy, timeout etc. settings are saved in a separate user-specific
 config file and not in the config file of the application.

 @p Original author:

 @p Revised by:

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short 
 Provides information about I/O (Internet, etc.
*/
@class KURL; 

@class KConfig; 

@interface  KProtocolManager : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Returns the default user-agent string.

 This function returns the default user-agent string

   
*/
+ (NSString *) defaultUserAgent;

/** 
 Returns the default user-agent value.

 This function returns the default user-agent value
 taking into account 'keys'

 Keys can be any of the folliwing:
 'o'	Show OS
 'v'	Show OS Version
 'p'	Show platform
 'm'	Show machine architecture
 'l'	Show language

   
*/
+ (NSString *) defaultUserAgent: (NSString *)keys;

/** 
 Returns the userAgent string configured for the
 specified host.

 If hostname is not found or is empty (i.e. "" or
 -[QString null]) this function will return the default
 user agent.

*/
+ (NSString *) userAgentForHost: (NSString *)arg1;

/** 
 Returns the preferred timeout value for reading from
 remote connections in seconds.

*/
+ (int) readTimeout;

/** 
 Returns the preferred timeout value for remote connections
 in seconds.

*/
+ (int) connectTimeout;

/** 
 Returns the preferred timeout value for proxy connections
 in seconds.

*/
+ (int) proxyConnectTimeout;

/** 
 Returns the preferred response timeout value for
 remote connecting in seconds.

*/
+ (int) responseTimeout;

/** 
 Returns the set default timeout value for connecting
 to remote machines.

*/
//+ (int) defaultConnectTimeout;

/** 
 Returns whether or not the user specified the
 use of proxy server to make connections.
   
*/
+ (BOOL) useProxy;

/** 
 Returns whether or not the the proxy server
 lookup should be reversed or not.
   
*/
+ (BOOL) useReverseProxy;

/** 
 Returns the type of proxy configuration that is used.
   
*/
+ (int) proxyType;

/** 
 Returns the way proxy authorization should be handled.

*/
+ (int) proxyAuthMode;

/** 
 Returns the strings for hosts that should contacted
 DIRECT bypassing any proxy settings.
   
*/
+ (NSString *) noProxyFor;
+ (NSString *) proxyFor: (NSString *)arg1;

/** 
 Returns the Proxy server address for a given URL
 If automatic proxy configuration is configured, @ref KPAC
 is used to determine the proxy server, otherwise the return
 value of @ref  #-proxyFor for the URL's protocol is used.
 If an empty string is returned, the request is to be aborted,
 a return value of "DIRECT" requests a direct connection.

*/
+ (NSString *) proxyForURL: (KURL*)arg1;

/** 
 Marks this proxy as bad (down). It will not be used for the
 next 30 minutes. (The script may supply an alternate proxy)
   
*/
+ badProxy: (NSString *)arg1;

/** 

*/
+ (NSString *) proxyConfigScript;

/** 
 Returns true/false to indicate whether a cache
 should be used

*/
+ (BOOL) useCache;

/** 
 Returns the maximum age in seconds cached files should be
 kept before they are deleted as necessary.

*/
+ (int) maxCacheAge;

/** 
 Returns the maximum size that can be used for caching.

 By default this function returns the DEFAULT_MAX_CACHE_SIZE
 value as defined in http_slave_defaults.h.  Not that the
 value returned is in bytes, hence a value of 5120 would mean
 5 Kb.

*/
+ (int) maxCacheSize;

/** 
 The directory which contains the cache files
   
*/
+ (NSString *) cacheDir;

/** 
 Returns the Cache control directive to be used.
   
*/
+ (int) cacheControl;

/** 
 Returns true if partial downloads should be
 automatically resumed.
   
*/
+ (BOOL) autoResume;

/** 
 Returns true if partial downloads should be marked
 with a ".part" extension.
   
*/
+ (BOOL) markPartial;

/** 
 Returns the minimum file size for keeping aborted
 downloads.

 Any data downloaded that does not meet this minimum
 requirement will simply be discarded. The default size
 is 5 KB.

 @ return the minimum keep size for aborted downloads in bytes.
   
*/
+ (int) minimumKeepSize;

/** 
 Returns true if connections should be persistent
   
*/
+ (BOOL) persistentConnections;

/** 
 Force a reload of the general config file of
 io-slaves ( kioslaverc).
   
*/
+ reparseConfiguration;

/** 
 Return the protocol to use in order to handle the given @p url
 It's usually the same, except that FTP, when handled by a proxy,
 needs an HTTP ioslave.

 When a proxy is to be used, proxy contains the URL for the proxy.
   
*/
+ (NSString *) slaveProtocol: (KURL*)url proxy: (NSString *)proxy;

/** 

 (Shared with SlaveConfig)
   
*/
+ (KConfig*) config;
+ (int) NoProxy;
+ (int) ManualProxy;
+ (int) PACProxy;
+ (int) WPADProxy;
+ (int) EnvVarProxy;
+ (int) Prompt;
+ (int) Automatic;
@end

#endif
