/***************************************************************************
                            KRuler.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRULER_H
#define KRULER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 A ruler widget.

 The vertical ruler looks similar to this:

<pre>
    meters                       inches

    ------   <--- end mark  ---> ------
        --                            -
        --   <---little mark--->     --
        --                            -
        --                          ---
       ---   <---medium mark          -
        --                           --
        --        tiny mark---->      -
        --                         ----
        --                            -
      ----   <-----big mark          --
        --                            -
      |>--   <--ruler pointer-->   |>--

 </pre>

 There are tiny marks, little marks, medium marks, and big marks along the
  ruler.

 To receive mouse clicks or mouse moves,
 the class has to be overloaded.

 For performance reasons, the public methods don't call @ref -[QWidget repaint].
 (Slots do, see documentation below.)
 All the changed settings will be painted once after leaving
 to the main event loop.
 For performance painting the slot methods should be used,
 they do a fast @ref -[QWidget repaint] call after changing the values.
 For setting multiple values like @ref -minValue, @ref -maxValue, @ref -offset etc.
 using the public methods is recommended
 so the widget will be painted only once when entering the main event loop.

 @author Jrg Habenicht
 
 @short A ruler widget.

*/
@interface KRuler : QFrame 

/** 
 Constructs a horizontal ruler.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a ruler with orientation @p orient.

 @p parent, @p name and @p f are passed to QFrame.
 The default look is a raised widget
 but may be changed with the inherited @ref QFrame methods.

*/
- initWithInt: (int)orient parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithInt: (int)orient ;

/** 
 Constructs a ruler with orientation @p orient and initial width @p widgetWidth.

 The width sets the fixed width of the widget. This is useful if you
 want to draw the ruler bigger or smaller than the default size.
 Note: The size of the marks doesn't change.
 @p parent, @p name and @p f are passed to @ref QFrame.

   
*/
- initWithInt: (int)orient widgetWidth: (int)widgetWidth parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithInt: (int)orient widgetWidth: (int)widgetWidth ;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Sets the minimal value of the ruler pointer (default is 0).

 This method calls @ref -update so that the widget is painted after leaving
 to the main event loop.

*/
- setMinValue: (int)arg1;

/** 
 Returns the minimal value of the ruler pointer.

*/
- (int) minValue;

/** 
 Sets the maximum value of the ruler pointer (default is 100).

 This method calls @ref -update so that the widget is painted after leaving
 to the main event loop.
   
*/
- setMaxValue: (int)arg1;

/** 
 Returns the maximal value of the ruler pointer.
   
*/
- (int) maxValue;

/** 
 Sets minimum and maximum values of the ruler pointer.

 This method calls @ref -update so that the widget is painted after leaving
 to the main event loop.
   
*/
- setRange: (int)min max: (int)max;

/** 
 Sets the value of the ruler pointer.

 The value is indicated by painting the ruler pointer at the
 corresponding position.
 This method calls @ref -update so that the widget is painted after leaving
 to the main event loop.
   
*/
- setValue: (int)arg1;
- (int) value;

/** 
 Sets the distance between tiny marks.

 This is mostly used in the English system (inches) with distance of 1. 
   
*/
- setTinyMarkDistance: (int)arg1;

/** 
 Returns the distance between tiny marks.

*/
- (int) tinyMarkDistance;

/**  
 Sets the distance between little marks.

 The default value is 1 in the metric system and 2 in the English (inches) system.
   
*/
- setLittleMarkDistance: (int)arg1;

/**  
 Returns the distance between little marks.
   
*/
- (int) littleMarkDistance;

/** 
 Sets the distance between medium marks.

 For English (inches) styles it defaults to twice the little mark distance.
 For metric styles it defaults to five times the little mark distance.

*/
- setMediumMarkDistance: (int)arg1;
- (int) mediumMarkDistance;

/**  
 Sets distance between big marks.

 For English (inches) or metric styles it is twice the medium mark distance.

*/
- setBigMarkDistance: (int)arg1;

/** 
 Returns the distance between big marks.

*/
- (int) bigMarkDistance;

/** 
 Shows/hides tiny marks.

*/
- setShowTinyMarks: (BOOL)arg1;
- (BOOL) showTinyMarks;

/** 
 Shows/hides little marks.

*/
- setShowLittleMarks: (BOOL)arg1;
- (BOOL) showLittleMarks;

/** 
 Shows/hides medium marks.

*/
- setShowMediumMarks: (BOOL)arg1;
- (BOOL) showMediumMarks;

/** 
 Shows/hides big marks.

*/
- setShowBigMarks: (BOOL)arg1;
- (BOOL) showBigMarks;

/** 
 Shows/hides end marks.

*/
- setShowEndMarks: (BOOL)arg1;
- (BOOL) showEndMarks;

/** 
 Shows/hides the pointer.
   
*/
- setShowPointer: (BOOL)arg1;
- (BOOL) showPointer;

/** 
 Sets the value that is shown per little mark.

 For metric systems this is 1 per mark.
 Note: If you set the value for little marks the values for 
 medium and big marks are updated according to the
 the values set in the setXXMarkDistance(int) methods.

*/
- setValuePerLittleMark: (int)arg1;

/** 
 Sets the value that is shown per medium mark.

 For metric systems this is 5.
 Display of little marks is automatically disabled and
 big marks are updated according to 
 the values set in the @ref -setBigMarkDistance method.

*/
- setValuePerMediumMark: (int)arg1;

/** 
 Sets the value that is shown per big mark.

 For metric systems this is 1
 Display of little and medium marks marks is disabled.
   
*/
- setValuePerBigMark: (int)arg1;

/** 
 Show/hide number values of the end marks.

 Default is @p false.

*/
- setShowEndLabel: (BOOL)arg1;
- (BOOL) showEndLabel;

/** 
 Sets the label this is drawn at the beginning of the visible part
 of the ruler to @p label

*/
- setEndLabel: (NSString *)arg1;
- (NSString *) endLabel;

/** 
 Sets up the necessary tasks for the provided styles.

 A convenience method.

*/
- setRulerMetricStyle: (int)arg1;

/** 
 Sets the number of pixels between two base marks.

 Calling this method stretches or shrinks your ruler.

 For pixel display (@ref MetricStyle) the value is 10.0 marks
 per pixel ;-)
 For English (inches) it is 9.0, and for centimetres ~2.-[835 3].0 .
 If you want to magnify your part of display, you have to
 adjust the mark distance @p here.
 Notice: The double type is only supported to give the possibility
         of having some double values.
         It should be used with care.  Using values below 10.0
         shows visible jumps of markpositions (e.g. 2.345).
         Using whole numbers is highly recommended.
 To use @p int values use setPixelPerMark((int)your_int_value);
 default: 1 mark per 10 pixels 
   
*/
- setPixelPerMark: (double)rate;

/** 
 Returns the number of pixels between two base marks.

*/
- (double) pixelPerMark;

/** 
 Sets the length of the ruler, i.e. the difference between
 the begin mark and the end mark of the ruler.

 Same as (-width - -offset)

 when the length is not locked, it gets adjusted with the
 length of the widget.
   
*/
- setLength: (int)arg1;
- (int) length;

/** 
 Locks the length of the ruler, i.e. the difference between
 the two end marks doesn't change when the widget is resized.

*/
- setLengthFixed: (BOOL)fix;
- (BOOL) lengthFixed;

/** 
 Sets the number of pixels by which the ruler may slide up or left.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
- slideUp: (int)count;
- slideUp;

/** 
 Sets the number of pixels by which the ruler may slide down or right.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
- slideDown: (int)count;
- slideDown;

/** 
 Sets the ruler slide offset.

 This is like @ref -slideup or @ref -slidedown with an absolute offset
 from the start of the ruler.

*/
- setOffset: (int)offset;

/** 
 Returns the current ruler offset.

*/
- (int) offset;
- (int) endOffset;

/** 
 Sets the pointer to a new position.

 The offset is NOT updated.
 @ref -[QWidget repaint] is called afterwards.

*/
- slotNewValue: (int)arg1;

/** 
 Sets the ruler marks to a new position.

 The pointer is NOT updated.
 @ref -[QWidget repaint] is called afterwards.

*/
- slotNewOffset: (int)arg1;
- slotEndOffset: (int)arg1;
+ (int) Custom;
+ (int) Pixel;
+ (int) Inch;
+ (int) Millimetres;
+ (int) Centimetres;
+ (int) Metres;
@end

/** Override these methods in subclasses of KRuler to customise event handling behaviour */
@protocol KRulerEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
