/***************************************************************************
                            KStatusBar.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTATUSBAR_H
#define KSTATUSBAR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QStatusBar.h>

/**

  Display status messages.

  You can insert text labels or custom widgets. Their geometry is managed
  internally. KStatusBar resizes itself, but positioning is left to
  @ref KMainWindow (or to you, if you don't use @ref KMainWindow ).

  A special type of item is a message which is a temporary text-message
  displayed on top of other items in full-width. Messages are visible for
  specified time, or until you call the slot @ref -[QStatusBar clear]. See
  @ref -[QStatusBar message]for details.

  KStatusBar inherits @ref QStatusBar, you can freely use all @ref QStatusBar
  methods.

  Empty text items are not visible. They will become visible when you change
  (add) text.

 @author Mark Donohoe (donohoe@kde.org) Maintained by Sven Radej <radej@kde.org>

 @version $Id: KStatusBar.h,v 1.3 2002/03/15 02:12:23 rdale Exp $
 
 @short KDE statusbar widget.
*/
@interface KStatusBar : QStatusBar 

/** 
  Constructs a status bar. @p parent is usually @ref KMainWindow.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
  Destructor.

  Deletes all internal objects.
   
*/
- (void) dealloc;

/** 
  Inserts a text label into the status bar.
  Paremeters @p stretch and  @p permanent are passed to
  @ref -[QStatusBar addWidget].

  If @p permanent is true, then item will be placed on the far right of
  the statusbar and will never be hidden by @ref -[QStatusBar message].

   
*/
- insertTextItem: (NSString *)text identifier: (int)identifier stretch: (int)stretch permanent: (BOOL)permanent;
- insertTextItem: (NSString *)text identifier: (int)identifier ;

/** 
  Inserts a fixed width text label into status bar. The width will be set
  according to @p text, but will remain fixed even if you change text.
  You can change fixed width by calling @ref setItemFixed.

*/
- insertFixedItem: (NSString *)text identifier: (int)identifier permanent: (BOOL)permanent;
- insertFixedItem: (NSString *)text identifier: (int)identifier ;

/** 
  Removes an item.

*/
- removeIntItem: (int)identifier;

/** 
 Changes the text in a status bar field.

 The item will be resized to fit the text. If you change text to be empty,
 item will not be visible (untill you add some text).

*/
- changeTextItem: (NSString *)text identifier: (int)identifier;

/** 
 Sets the alignment of item @p id. By default all fields are aligned
 @p AlignHCenter | @p AlignVCenter. See @ref -[QLabel setAlignment]for details.

  
*/
- setItemAlignment: (int)identifier align: (int)align;

/** 
 Sets item @p id to have fixed width. This cannot be undone, but you can
 always set new fixed width.

*/
- setItemFixed: (int)identifier width: (int)width;
- setItemFixed: (int)identifier ;
+ (int) Toggle;
+ (int) Show;
+ (int) Hide;
@end

/** Override these methods in subclasses of KStatusBar to customise event handling behaviour */
@protocol KStatusBarEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
