/***************************************************************************
                            KTempFile.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTEMPFILE_H
#define KTEMPFILE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The KTempFile class creates and opens a unique file for temporary use.

 This is especially useful if you need to create a file in a world
 writable directory like /tmp without being vulnerable to so called
 symlink attacks.

 KDE applications, however, shouldn't create files in /tmp in the first 
 place but use the "tmp" resource instead. The standard KTempFile 
 constructor will do that by default.

 To create a temporary file that starts with a certain name
 in the "tmp" resource, one should use:
 KTempFile(locateLocal("tmp", prefix), extension);

 KTempFile does not create any missing directories, but -locateLocal does.

 See also @ref KStandardDirs

 @author Waldo Bastian <bastian@kde.org>
 
 @short 
 The KTempFile class creates and opens a unique file for temporary use.
*/
@class QDataStream; 
@class QFile; 
@class QTextStream; 

@interface  KTempFile : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a temporary file with the name:
  <filePrefix><six letters><fileExtension>

 The default @p filePrefix is "$KDEHOME/tmp-$HOST/appname"
 The default @p fileExtension is ".tmp"

*/
- initWithText: (NSString *)filePrefix fileExtension: (NSString *)fileExtension mode: (int)mode;
- init;

/** 
 The destructor closes the file.
 If autoDelete is enabled the file gets unlinked as well.

*/
- (void) dealloc;

/** 
 Turn automatic deletion on or off.
 Automatic deletion is off by default.

*/
- setAutoDelete: (BOOL)autoDelete;

/** 
 Returns the status of the file based on errno. (see errno.h) 
 0 means OK.

 You should check the status after object creation to check 
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
- (int) status;

/** 
 The name of the file.

*/
- (NSString *) name;

/** 
 An integer file descriptor open for writing to the file 

*/
- (int) handle;

/** 

*/
//- (FILE*) fstream;

/** 

*/
- (QTextStream*) textStream;

/** 

*/
- (QDataStream*) dataStream;

/** 
 A QFile open for writing to the file

*/
- (QFile*) file;

/** 
 Unlinks the file from the directory. The file is
 deleted once the last reader/writer closes it.

*/
- unlink;

/** 
 Closes the file.
 Returns 'true' is successful, or 'false' if an error has occured.
 See -status for details about errors.

*/
- (BOOL) close;

/** 
 Constructor used by KSaveFile

*/
- initWithBOOL: (BOOL)arg1;

/** 

 Create function used internally by KTempFile and KSaveFile

*/
- (BOOL) create: (NSString *)filePrefix fileExtension: (NSString *)fileExtension mode: (int)mode;
- setError: (int)error;
@end

#endif
