package org.kde.qt;


/** {@link QDataTable} emits these signals */
public interface QDataTableSignals {
	void pressed( int row, int col, int button, QPoint mousePos );
	void verticalSliderPressed();
	void horizontalSliderPressed();
	void beforeInsert( QSqlRecord buf );
	void primeDelete( QSqlRecord buf );
	void beforeUpdate( QSqlRecord buf );
	void valueChanged( int row, int col );
	void contentsMoving( int x, int y );
	void dropped( QDropEvent e );
	void currentChanged( QSqlRecord record );
	void destroyed( QObject obj );
	void contextMenuRequested( int row, int col, QPoint pos );
	void verticalSliderReleased();
	void beforeDelete( QSqlRecord buf );
	void primeInsert( QSqlRecord buf );
	void selectionChanged();
	void primeUpdate( QSqlRecord buf );
	void doubleClicked( int row, int col, int button, QPoint mousePos );
	void horizontalSliderReleased();
	void cursorChanged( int mode );
	void clicked( int row, int col, int button, QPoint mousePos );
}

