/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFPRINT_PRINTSETTINGS_H__
#define __XFPRINT_PRINTSETTINGS_H__

#include <option.h>

typedef struct _XfprintSettingsSheets		XfprintSettingsSheets;
typedef struct _XfprintSettingsVirtualPages	XfprintSettingsVirtualPages;
typedef struct _XfprintSettingsPrettyPrint	XfprintSettingsPrettyPrint;
typedef struct _XfprintSettingsInput		XfprintSettingsInput;
typedef struct _XfprintSettingsHeadings		XfprintSettingsHeadings;
typedef struct _XfprintSettings			XfprintSettings;

struct _XfprintSettingsSheets
{
	gboolean	landscape;
	gboolean	fillcols;
	guint		cols;
	guint		rows;
	const gchar	*papersize;
	gboolean	borders;
	gboolean	reverse;
};

struct _XfprintSettingsVirtualPages
{
	guint		linenumbers;
	guint		lpp;		/* lines per page */
	guint		cpl;		/* chars per line */
	guint		tabsize;
	const gchar	*nonprtfmt;
};

struct _XfprintSettingsPrettyPrint
{
	const gchar	*language;
	const gchar	*highlight;
	guint		strip;
};

struct _XfprintSettingsInput
{
	const gchar	*encoding;
	gboolean	all;
	guint		from;
	guint		to;
	gboolean	cut;
	gboolean	interpret;
	gboolean	binary;
};

struct _XfprintSettingsHeadings
{
	gboolean	headers;
	gchar		header[64];
	gchar		underlay[64];
	gchar		ctitle[64];
	gchar		ltitle[64];
	gchar		rtitle[64];
	gchar		cfooter[64];
	gchar		lfooter[64];
	gchar		rfooter[64];
};

struct _XfprintSettings
{
	XfprintSettingsSheets		sheets;
	XfprintSettingsVirtualPages	vpages;
	XfprintSettingsPrettyPrint	pprint;
	XfprintSettingsInput		input;
	XfprintSettingsHeadings		headings;

	guint				copies;
};

extern XfprintSettings	*xfprintsettings_defaults(void);
extern XfprintSettings	*xfprintsettings_load(void);
extern void		xfprintsettings_save(const XfprintSettings *);
extern void		xfprintsettings_free(XfprintSettings *);

/* predefined options */
extern const XfprintOption papersizes[];
extern const XfprintOption encodings[];
extern const XfprintOption languages[];
extern const XfprintOption non_printable_fmts[];
extern const XfprintOption hilevels[];

#endif	/* !__XFPRINT_PRINTSETTINGS_H__ */
