#include "fetchmail.h"

#define TESTSTRING "TESTBUFFER"

#define CHECK_BUF(buf) do { \
	size_t i;  \
	size_t len = sizeof(TESTSTRING); \
	for (i = 0; i < len; i++) { \
		if ((buf)[i]) exit(EXIT_FAILURE); \
	} \
} while(0)

static char buf2[] = TESTSTRING;

int main(void) {
	char *bufp1;
	char *bufp2;
	char *bufp3;
	static char buf1[] = TESTSTRING;
	char buf3[] = TESTSTRING;
	bufp1 = buf1; /* deliberately alias to incentivize optimization */
	bufp2 = buf2; /* deliberately alias to incentivize optimization */
	bufp3 = buf3; /* deliberately alias to incentivize optimization */

	fm_safe_clearmem(buf1, sizeof(buf1));
	fm_safe_clearmem(buf2, sizeof(buf2));
	fm_safe_clearmem(buf3, sizeof(buf3));
	CHECK_BUF(bufp1);
	CHECK_BUF(bufp2);
	CHECK_BUF(bufp3);
	return EXIT_SUCCESS;
}
