.\"@(#)rpc.mountd.8"
.\"
.\" Copyright (C) 1999 Olaf Kirch <okir@monad.swb.de>
.\" Modified by Paul Clements, 2004.
.\"
.TH rpc.mountd 8 "31 Dec 2009"
.SH NAME
rpc.mountd \- NFS mount daemon
.SH SYNOPSIS
.BI "/usr/sbin/rpc.mountd [" options "]"
.SH DESCRIPTION
The
.B rpc.mountd
daemon implements the server side of the NFS MOUNT protocol,
an NFS side protocol used by NFS version 2 [RFC1094] and NFS version 3 [RFC1813].
It also responds to requests from the Linux kernel to authenticate
clients and provides details of access permissions.
.PP
The NFS server
.RI ( nfsd )
maintains a cache of authentication and authorization information which
is used to identify the source of each request, and then what access
permissions that source has to any local filesystem.  When required
information is not found in the cache, the server sends a request to
.B mountd
to fill in the missing information.  Mountd uses a table of information
stored in
.B /var/lib/nfs/etab
and maintained by
.BR exportfs (8),
possibly based on the contents of 
.BR exports (5),
to respond to each request.
.SS Mounting exported NFS File Systems
The NFS MOUNT protocol has several procedures.
The most important of these are
MNT (mount an export) and
UMNT (unmount an export).
.PP
A MNT request has two arguments: an explicit argument that
contains the pathname of the root directory of the export to be mounted,
and an implicit argument that is the sender's IP address.
.PP
When receiving a MNT request from an NFS client,
.B rpc.mountd
checks both the pathname and the sender's IP address against its export table.
If the sender is permitted to access the requested export,
.B rpc.mountd
returns an NFS file handle for the export's root directory to the client.
The client can then use the root file handle and NFS LOOKUP requests
to navigate the directory structure of the export.
.SS The rmtab File
The
.B rpc.mountd
daemon registers every successful MNT request by adding an entry to the
.I /var/lib/nfs/rmtab
file.
When receivng a UMNT request from an NFS client,
.B rpc.mountd
simply removes the matching entry from
.IR /var/lib/nfs/rmtab ,
as long as the access control list for that export allows that sender
to access the export.
.PP
Clients can discover the list of file systems an NFS server is
currently exporting, or the list of other clients that have mounted
its exports, by using the
.BR showmount (8)
command.
.BR showmount (8)
uses other procedures in the NFS MOUNT protocol to report information
about the server's exported file systems.
.PP
Note, however, that there is little to guarantee that the contents of
.I /var/lib/nfs/rmtab
are accurate.
A client may continue accessing an export even after invoking UMNT.
If the client reboots without sending a UMNT request, stale entries
remain for that client in
.IR /var/lib/nfs/rmtab .
.SS Mounting File Systems with NFSv4
Version 4 (and later) of NFS does not use a separate NFS MOUNT
protocol.  Instead mounting is performed using regular NFS requests
handled by the NFS server in the Linux kernel
.RI ( nfsd ).
Consequently
.I /var/lib/nfs/rmtab
is not updated to reflect any NFSv4 activity.
.SH OPTIONS
.TP
.B \-d kind " or " \-\-debug kind
Turn on debugging. Valid kinds are: all, auth, call, general and parse.
.TP
.BR \-l " or " \-\-log\-auth
Enable logging of responses to authentication and access requests from
nfsd.  Each response is then cached by the kernel for 30 minutes (or as set by
.B \-\-ttl
below), and will be refreshed after 15 minutes (half the ttl time) if
the relevant client remains active.
Note that
.B -l
is equivalent to
.B "-d auth"
and so can be enabled in
.B /etc/nfs.conf
with
.B "\[dq]debug = auth\[dq]"
in the
.B "[mountd]"
section.
.IP
.B rpc.mountd
will always log authentication responses to MOUNT requests when NFSv3 is
used, but to get similar logs for NFSv4, this option is required.
.TP
.BR \-i " or " \-\-cache\-use\-ipaddr
Normally each client IP address is matched against each host identifier
(name, wildcard, netgroup etc) found in
.B /etc/exports
and a combined identity is formed from all matching identifiers.
Often many clients will map to the same combined identity so performing
this mapping reduces the number of distinct access details that the
kernel needs to store.
Specifying the
.B \-i
option suppresses this mapping so that access to each filesystem is
requested and cached separately for each client IP address.  Doing this
can increase the burden of updating the cache slightly, but can make the
log messages produced by the
.B -l
option easier to read.
.TP
.B \-T " or " \-\-ttl
Provide a time-to-live (TTL) for cached information given to the kernel.
The kernel will normally request an update if the information is needed
after half of this time has expired.  Increasing the provided number,
which is in seconds, reduces the rate of cache update requests, and this
is particularly noticeable when these requests are logged with
.BR \-l .
However increasing also means that changes to hostname to address
mappings can take longer to be noticed.
The default TTL is 1800 (30 minutes).
.TP
.B \-F " or " \-\-foreground
Run in foreground (do not daemonize)
.TP
.B \-h " or " \-\-help
Display usage message.
.TP
.B \-o num " or " \-\-descriptors num
Set the limit of the number of open file descriptors to num. The
default is to leave the limit unchanged.
.TP
.B \-N mountd-version " or " \-\-no-nfs-version mountd-version
This option can be used to request that
.B rpc.mountd
do not offer certain versions of NFS. The current version of
.B rpc.mountd
can support both NFS version 2, 3 and 4. If the
either one of these version should not be offered,
.B rpc.mountd
must be invoked with the option
.B "\-\-no-nfs-version <vers>" .
.TP
.B \-n " or " \-\-no-tcp
Don't advertise TCP for mount.
.TP
.B \-p num " or " \-P num " or " \-\-port num
Specifies the port number used for RPC listener sockets.
If this option is not specified,
.B rpc.mountd
will try to consult
.IR /etc/services ,
if gets port succeed, set the same port for all listener socket,
otherwise chooses a random ephemeral port for each listener socket.
.IP
This option can be used to fix the port value of
.BR rpc.mountd 's
listeners when NFS MOUNT requests must traverse a firewall
between clients and servers.
.TP
.B \-H " prog or " \-\-ha-callout prog
Specify a high availability callout program.
This program receives callouts for all MOUNT and UNMOUNT requests.
This allows
.B rpc.mountd
to be used in a High Availability NFS (HA-NFS) environment.
.IP
The callout program is run with 4 arguments.
The first is
.B mount
or
.B unmount
depending on the reason for the callout.
The second will be the name of the client performing the mount.
The third will be the path that the client is mounting.
The last is the number of concurrent mounts that we believe the client
has of that path.
.IP
This callout is not needed with 2.6 and later kernels.
Instead, mount the nfsd filesystem on
.IR /proc/fs/nfsd .
.TP
.BI "\-s," "" " \-\-state\-directory\-path "  directory
Specify a directory in which to place state information (etab and rmtab).
If this option is not specified the default of
.I /var/lib/nfs
is used.
.TP
.BI "\-r," "" " \-\-reverse\-lookup"
.B rpc.mountd
tracks IP addresses in the
.I rmtab
file.  When a DUMP request is made (by
someone running
.BR "showmount -a" ,
for instance), it returns IP addresses instead
of hostnames by default. This option causes
.B rpc.mountd
to perform a reverse lookup on each IP address and return that hostname instead.
Enabling this can have a substantial negative effect on performance
in some situations.
.TP
.BR "\-t N" " or " "\-\-num\-threads=N " or  " \-\-num\-threads N "
This option specifies the number of worker threads that rpc.mountd
spawns.  The default is 1 thread, which is probably enough.  More
threads are usually only needed for NFS servers which need to handle
mount storms of hundreds of NFS mounts in a few seconds, or when
your DNS server is slow or unreliable.
.TP
.B  \-u " or " \-\-no-udp
Don't advertise UDP for mounting
.TP
.B \-V version " or " \-\-nfs-version version
This option can be used to request that
.B rpc.mountd
offer certain versions of NFS. The current version of
.B rpc.mountd
can support both NFS version 2 and the newer version 3.
.TP
.B \-v " or " \-\-version
Print the version of
.B rpc.mountd
and exit.
.TP
.B \-g " or " \-\-manage-gids
Accept requests from the kernel to map user id numbers into  lists of
group id numbers for use in access control.  An NFS request will
normally (except when using Kerberos or other cryptographic
authentication) contains a user-id and a list of group-ids.  Due to a
limitation in the NFS protocol, at most 16 groups ids can be listed.
If you use the
.B \-g
flag, then the list of group ids received from the client will be
replaced by a list of group ids determined by an appropriate lookup on
the server. Note that the 'primary' group id is not affected so a
.B newgroup
command on the client will still be effective.  This function requires
a Linux Kernel with version at least 2.6.21.

.SH CONFIGURATION FILE
Many of the options that can be set on the command line can also be
controlled through values set in the
.B [mountd]
or, in some cases, the
.B [nfsd]
sections of the
.I /etc/nfs.conf
configuration file.
Values recognized in the
.B [mountd]
section include
.BR manage-gids ,
.BR cache\-use\-ipaddr ,
.BR descriptors ,
.BR port ,
.BR threads ,
.BR ttl ,
.BR reverse-lookup ", and"
.BR state-directory-path ,
.B ha-callout
which each have the same effect as the option with the same name.

The values recognized in the
.B [nfsd]
section include
.BR TCP ,
.BR UDP ,
.BR vers3 ", and"
.B vers4
which each have the same meaning as given by
.BR rpc.nfsd (8).

.SH TCP_WRAPPERS SUPPORT
You can protect your
.B rpc.mountd
listeners using the
.B tcp_wrapper
library or
.BR iptables (8).
.PP
Note that the
.B tcp_wrapper
library supports only IPv4 networking.
.PP
Add the hostnames of NFS peers that are allowed to access
.B rpc.mountd
to
.IR /etc/hosts.allow .
Use the daemon name
.B mountd
even if the
.B rpc.mountd
binary has a different name.
.PP
Hostnames used in either access file will be ignored when
they can not be resolved into IP addresses.
For further information see the
.BR tcpd (8)
and
.BR hosts_access (5)
man pages.
.SS IPv6 and TI-RPC support
TI-RPC is a pre-requisite for supporting NFS on IPv6.
If TI-RPC support is built into
.BR rpc.mountd ,
it attempts to start listeners on network transports marked 'visible' in
.IR /etc/netconfig .
As long as at least one network transport listener starts successfully,
.B rpc.mountd
will operate.
.SH FILES
.TP 2.5i
.I /etc/exports
input file for
.BR exportfs ,
listing exports, export options, and access control lists
.TP 2.5i
.I /var/lib/nfs/rmtab
table of clients accessing server's exports
.SH SEE ALSO
.BR exportfs (8),
.BR exports (5),
.BR showmount (8),
.BR rpc.nfsd (8),
.BR rpc.rquotad (8),
.BR nfs (5),
.BR nfs.conf (5),
.BR tcpd (8),
.BR hosts_access (5),
.BR iptables (8),
.BR netconfig (5)
.sp
RFC 1094 - "NFS: Network File System Protocol Specification"
.br
RFC 1813 - "NFS Version 3 Protocol Specification"
.br
RFC 7530 - "Network File System (NFS) Version 4 Protocol"
.br
RFC 8881 - "Network File System (NFS) Version 4 Minor Version 1 Protocol"
.SH AUTHOR
Olaf Kirch, H. J. Lu, G. Allan Morris III, and a host of others.
