/*
 *  kis_tool_ellipse.h - part of Krayon
 *
 *  Copyright (c) 2000 John Califf <jcaliff@compuzone.net>
 *  Copyright (c) 2002 Patrick Julien <freak@codepimps.org>
 *  Copyright (c) 2004 Clarence Dang <dang@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __KIS_TOOL_ELLIPSE_H__
#define __KIS_TOOL_ELLIPSE_H__

#include "kis_tool_shape.h"

class KisCanvas;
class KisDoc;
class KisPainter;
class KisView;
class KisRect;

class KisToolEllipse : public KisToolShape {

	typedef KisToolShape super;
	Q_OBJECT

public:
	KisToolEllipse();
	virtual ~KisToolEllipse();

        //
        // KisCanvasObserver interface
        //

        virtual void update (KisCanvasSubject *subject);

        //
        // KisToolPaint interface
        //

	virtual void setup(KActionCollection *collection);

	virtual void buttonPress(KisButtonPressEvent *event);
	virtual void move(KisMoveEvent *event);
	virtual void buttonRelease(KisButtonReleaseEvent *event);

protected:
	virtual void draw(const KisPoint& start, const KisPoint& stop);

protected:
	KisPoint m_dragCenter;
	KisPoint m_dragStart;
	KisPoint m_dragEnd;

	bool m_dragging;
	KisImageSP m_currentImage;
};


#include "kis_tool_factory.h"

class KisToolEllipseFactory : public KisToolFactory {
	typedef KisToolFactory super;
public:
	KisToolEllipseFactory(KActionCollection * ac) : super(ac) {};
	virtual ~KisToolEllipseFactory(){};
	
	virtual KisTool * createTool() { 
		KisTool * t =  new KisToolEllipse(); 
		Q_CHECK_PTR(t);
		t -> setup(m_ac);
		return t; 
	}
	virtual KisID id() { return KisID("ellipse", i18n("Ellipse tool")); }
};


#endif //__KIS_TOOL_ELLIPSE_H__

