iconName = 'about_kde'
labelText = 'KAboutApplication'

from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KAboutApplication, KPushButton, KTextEdit


helpText = ("Typically available via the applications 'Help' menu, this "
            "dialog presents the user with the applications About widget.")

docParts = ('kdeui', 'KAboutDialog')

class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('About Application'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showAboutDialog)

    def showAboutDialog(self):
        dlg = KAboutApplication(self)
        dlg.show()
