/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGPathElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGPathElement.h"
#include "SVGPathSegArc.h"
#include "SVGPathSegClosePath.h"
#include "SVGPathSegCurvetoCubic.h"
#include "SVGPathSegCurvetoCubicSmooth.h"
#include "SVGPathSegCurvetoQuadratic.h"
#include "SVGPathSegCurvetoQuadraticSmooth.h"
#include "SVGPathSegLineto.h"
#include "SVGPathSegLinetoHorizontal.h"
#include "SVGPathSegLinetoVertical.h"
#include "SVGPathSegList.h"
#include "SVGPathSegMoveto.h"
#include "SVGStringList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPathElement)

/* Hash table */

static const HashTableValue JSSVGPathElementTableValues[17] =
{
    { "pathLength", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementPathLength, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGPathElementXmllang, (intptr_t)setJSSVGPathElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGPathElementXmlspace, (intptr_t)setJSSVGPathElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementFarthestViewportElement, (intptr_t)0 },
    { "pathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementPathSegList, (intptr_t)0 },
    { "normalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementNormalizedPathSegList, (intptr_t)0 },
    { "animatedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementAnimatedPathSegList, (intptr_t)0 },
    { "animatedNormalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementAnimatedNormalizedPathSegList, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPathElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGPathElementTableValues, 0 };
#else
    { 36, 31, JSSVGPathElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPathElementPrototypeTableValues[29] =
{
    { "getTotalLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetTotalLength, (intptr_t)0 },
    { "getPointAtLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPointAtLength, (intptr_t)1 },
    { "getPathSegAtLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPathSegAtLength, (intptr_t)1 },
    { "createSVGPathSegClosePath", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath, (intptr_t)0 },
    { "createSVGPathSegMovetoAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs, (intptr_t)2 },
    { "createSVGPathSegMovetoRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel, (intptr_t)2 },
    { "createSVGPathSegLinetoAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs, (intptr_t)2 },
    { "createSVGPathSegLinetoRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel, (intptr_t)2 },
    { "createSVGPathSegCurvetoCubicAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs, (intptr_t)6 },
    { "createSVGPathSegCurvetoCubicRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel, (intptr_t)6 },
    { "createSVGPathSegCurvetoQuadraticAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs, (intptr_t)4 },
    { "createSVGPathSegCurvetoQuadraticRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel, (intptr_t)4 },
    { "createSVGPathSegArcAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs, (intptr_t)7 },
    { "createSVGPathSegArcRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel, (intptr_t)7 },
    { "createSVGPathSegLinetoHorizontalAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs, (intptr_t)1 },
    { "createSVGPathSegLinetoHorizontalRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel, (intptr_t)1 },
    { "createSVGPathSegLinetoVerticalAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs, (intptr_t)1 },
    { "createSVGPathSegLinetoVerticalRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel, (intptr_t)1 },
    { "createSVGPathSegCurvetoCubicSmoothAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs, (intptr_t)4 },
    { "createSVGPathSegCurvetoCubicSmoothRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel, (intptr_t)4 },
    { "createSVGPathSegCurvetoQuadraticSmoothAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs, (intptr_t)2 },
    { "createSVGPathSegCurvetoQuadraticSmoothRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel, (intptr_t)2 },
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPathElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGPathElementPrototypeTableValues, 0 };
#else
    { 69, 63, JSSVGPathElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPathElementPrototype::s_info = { "SVGPathElementPrototype", 0, &JSSVGPathElementPrototypeTable, 0 };

JSObject* JSSVGPathElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGPathElement>(exec);
}

bool JSSVGPathElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPathElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPathElement::s_info = { "SVGPathElement", &JSSVGElement::s_info, &JSSVGPathElementTable, 0 };

JSSVGPathElement::JSSVGPathElement(PassRefPtr<Structure> structure, PassRefPtr<SVGPathElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGPathElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGPathElementPrototype(JSSVGPathElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGPathElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGPathElementPathLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->pathLengthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGPathElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValuePtr jsSVGPathElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValuePtr jsSVGPathElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->systemLanguage()), imp);
}

JSValuePtr jsSVGPathElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValuePtr jsSVGPathElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValuePtr jsSVGPathElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGPathElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGPathElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGPathElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGPathElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValuePtr jsSVGPathElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

JSValuePtr jsSVGPathElementPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->pathSegList()), imp);
}

JSValuePtr jsSVGPathElementNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->normalizedPathSegList()), imp);
}

JSValuePtr jsSVGPathElementAnimatedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->animatedPathSegList()), imp);
}

JSValuePtr jsSVGPathElementAnimatedNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->animatedNormalizedPathSegList()), imp);
}

void JSSVGPathElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPathElement, Base>(exec, propertyName, value, &JSSVGPathElementTable, this, slot);
}

void setJSSVGPathElementXmllang(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGPathElementXmlspace(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGPathElement* imp = static_cast<SVGPathElement*>(static_cast<JSSVGPathElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetTotalLength(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsNumber(exec, imp->getTotalLength());
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetPointAtLength(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float distance = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp->getPointAtLength(distance)).get(), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetPathSegAtLength(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float distance = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = jsNumber(exec, imp->getPathSegAtLength(distance));
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegClosePath()), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegMovetoAbs(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegMovetoRel(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoAbs(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoRel(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x1 = args.at(exec, 2)->toFloat(exec);
    float y1 = args.at(exec, 3)->toFloat(exec);
    float x2 = args.at(exec, 4)->toFloat(exec);
    float y2 = args.at(exec, 5)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x1 = args.at(exec, 2)->toFloat(exec);
    float y1 = args.at(exec, 3)->toFloat(exec);
    float x2 = args.at(exec, 4)->toFloat(exec);
    float y2 = args.at(exec, 5)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x1 = args.at(exec, 2)->toFloat(exec);
    float y1 = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x1 = args.at(exec, 2)->toFloat(exec);
    float y1 = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticRel(x, y, x1, y1)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float r1 = args.at(exec, 2)->toFloat(exec);
    float r2 = args.at(exec, 3)->toFloat(exec);
    float angle = args.at(exec, 4)->toFloat(exec);
    bool largeArcFlag = args.at(exec, 5)->toBoolean(exec);
    bool sweepFlag = args.at(exec, 6)->toBoolean(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegArcAbs(x, y, r1, r2, angle, largeArcFlag, sweepFlag)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float r1 = args.at(exec, 2)->toFloat(exec);
    float r2 = args.at(exec, 3)->toFloat(exec);
    float angle = args.at(exec, 4)->toFloat(exec);
    bool largeArcFlag = args.at(exec, 5)->toBoolean(exec);
    bool sweepFlag = args.at(exec, 6)->toBoolean(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegArcRel(x, y, r1, r2, angle, largeArcFlag, sweepFlag)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoHorizontalAbs(x)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoHorizontalRel(x)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float y = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoVerticalAbs(y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float y = args.at(exec, 0)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegLinetoVerticalRel(y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x2 = args.at(exec, 2)->toFloat(exec);
    float y2 = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);
    float x2 = args.at(exec, 2)->toFloat(exec);
    float y2 = args.at(exec, 3)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothRel(x, y, x2, y2)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothAbs(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(exec, 0)->toFloat(exec);
    float y = args.at(exec, 1)->toFloat(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothRel(x, y)), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    const UString& extension = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGPathElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
