.\" $XdotOrg: $
.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004 Sun Microsystems, Inc.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpQueryScreens 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpQueryScreens \- Queries an X Server to determine which screens, of all the 
screens on the server, support the X Print Service Extension
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]	
.br
      #include <X11/extensions/Print.h>
.LP    
.B Screen **XpQueryScreens
(
.I display, 
.I list_count_return 
)
.br
      Display *\fIdisplay\fP\^;
.br
      int *\fIlist_count_return\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I list_count_return
Returns the number of screens in the list.
.SH DESCRIPTION
.LP
This request returns a non-NULL pointer to a list of screen pointers if one or 
more screens support the X Print Service Extension; otherwise it returns NULL.

XpQueryScreens determines if the X Print Service Extension is present, and if 
so, which of all the screens on the X Server support the X Print Service 
Extension. Unlike many other extensions, the X Print Service Extension may be 
restricted to a subset of all available screens - for example, a single X Server 
may be supporting video displays on some screens and printers on others.

The list of screen pointers can be freed by calling XFree.
