//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class provides a widget often used for dialog titles.
    ///  \image html ktitlewidget.png "KTitleWidget with title and icon"
    ///  @section Usage
    ///  KTitleWidget is very simple to use. You can either use its default text
    ///  (and pixmap) properties or display your own widgets in the title widget.
    ///  A title text with a left aligned pixmap:
    ///  @code
    /// KTitleWidget titleWidget = new KTitleWidget(this);
    /// titleWidget.SetText(i18n("Title"));
    /// titleWidget.SetPixmap(KIcon("screen").pixmap(22, 22), KTitleWidget.ImageLeft);
    ///  @endcode
    ///  Use it with a own widget:
    ///  @code
    /// KTitleWidget checkboxTitleWidget = new KTitleWidget(this);
    /// QWidget checkBoxTitleMainWidget = new QWidget(this);
    /// QVBoxLayout titleLayout = new QVBoxLayout(checkBoxTitleMainWidget);
    /// titleLayout.SetMargin(6);
    /// QCheckBox checkBox = new QCheckBox("Text Checkbox", checkBoxTitleMainWidget);
    /// titleLayout.AddWidget(checkBox);
    /// checkboxTitleWidget.SetWidget(checkBoxTitleMainWidget);
    ///  @endcode
    /// </remarks>        <author> Urs Wolfer \<uwolfer @ kde.org\>
    ///  </author>
    ///         <short> Standard title widget with a white background and round border. </short>
    ///         <see> KPageView</see>
    [SmokeClass("KTitleWidget")]
    public class KTitleWidget : QWidget, IDisposable {
        protected KTitleWidget(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KTitleWidget), this);
        }
        /// <remarks>
        ///  Possible title pixmap alignments.
        /// 
        /// <li>
        /// ImageLeft: Display the pixmap left
        /// </li>
        /// 
        /// <li>
        /// ImageRight: Display the pixmap right (default)
        ///      
        /// </li></remarks>        <short>    Possible title pixmap alignments.</short>
        public enum ImageAlignment {
            ImageLeft = 0,
            ImageRight = 1,
        }
        /// <remarks>
        ///  Comment message types
        ///      </remarks>        <short>    Comment message types      </short>
        public enum MessageType {
            PlainMessage = 0,
            InfoMessage = 1,
            WarningMessage = 2,
            ErrorMessage = 3,
        }
        [Q_PROPERTY("QString", "text")]
        public string Text {
            get { return (string) interceptor.Invoke("text", "text()", typeof(string)); }
            set { interceptor.Invoke("setText$", "setText(QString)", typeof(void), typeof(string), value); }
        }
        [Q_PROPERTY("QPixmap", "pixmap")]
        public QPixmap Pixmap {
            get { return (QPixmap) interceptor.Invoke("pixmap", "pixmap()", typeof(QPixmap)); }
            set { interceptor.Invoke("setPixmap#", "setPixmap(QPixmap)", typeof(void), typeof(QPixmap), value); }
        }
        [Q_PROPERTY("int", "autoHideTimeout")]
        public int AutoHideTimeout {
            get { return (int) interceptor.Invoke("autoHideTimeout", "autoHideTimeout()", typeof(int)); }
            set { interceptor.Invoke("setAutoHideTimeout$", "setAutoHideTimeout(int)", typeof(void), typeof(int), value); }
        }
        /// <remarks>
        ///  Constructs a title widget with the given @param parent.
        ///      </remarks>        <short>    Constructs a title widget with the given @param parent.</short>
        public KTitleWidget(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTitleWidget#", "KTitleWidget(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KTitleWidget() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTitleWidget", "KTitleWidget()", typeof(void));
        }
        /// <remarks>
        /// <param> name="widget" Widget displayed on the title widget.
        ///      </param></remarks>        <short>   </short>
        public void SetWidget(QWidget widget) {
            interceptor.Invoke("setWidget#", "setWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        /// </remarks>        <return> the text displayed in the comment below the title, if any
        /// </return>
        ///         <short>   </short>
        ///         <see> setComment</see>
        public string Comment() {
            return (string) interceptor.Invoke("comment", "comment() const", typeof(string));
        }
        /// <remarks>
        ///  Sets this label's buddy to buddy.
        ///  When the user presses the shortcut key indicated by the label in this
        ///  title widget, the keyboard focus is transferred to the label's buddy
        ///  widget.
        /// <param> name="buddy" the widget to activate when the shortcut key is activated
        ///      </param></remarks>        <short>    Sets this label's buddy to buddy.</short>
        public void SetBuddy(QWidget buddy) {
            interceptor.Invoke("setBuddy#", "setBuddy(QWidget*)", typeof(void), typeof(QWidget), buddy);
        }
        /// <remarks>
        /// <param> name="text" Text displayed on the label. It can either be plain text or rich text. If it
        ///  is plain text, the text is displayed as a bold title text.
        /// </param><param> name="alignment" Alignment of the text. Default is left and vertical centered.
        /// </param></remarks>        <short>   </short>
        ///         <see> text</see>
        [Q_SLOT("void setText(QString, Qt::Alignment)")]
        public void SetText(string text, uint alignment) {
            interceptor.Invoke("setText$$", "setText(const QString&, Qt::Alignment)", typeof(void), typeof(string), text, typeof(uint), alignment);
        }
        [Q_SLOT("void setText(QString)")]
        public void SetText(string text) {
            interceptor.Invoke("setText$", "setText(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        /// <param> name="text" Text displayed on the label. It can either be plain text or rich text. If it
        ///  is plain text, the text is displayed as a bold title text.
        /// </param><param> name="type" The sort of message it is; will also set the icon accordingly @see MessageType
        /// </param></remarks>        <short>   </short>
        ///         <see> text</see>
        [Q_SLOT("void setText(QString, MessageType)")]
        public void SetText(string text, KTitleWidget.MessageType type) {
            interceptor.Invoke("setText$$", "setText(const QString&, KTitleWidget::MessageType)", typeof(void), typeof(string), text, typeof(KTitleWidget.MessageType), type);
        }
        /// <remarks>
        /// <param> name="comment" Text displayed beneath the main title as a comment.
        ///                 It can either be plain text or rich text.
        /// </param><param> name="type" The sort of message it is. @see MessageType
        /// </param></remarks>        <short>   </short>
        ///         <see> comment</see>
        [Q_SLOT("void setComment(QString, MessageType)")]
        public void SetComment(string comment, KTitleWidget.MessageType type) {
            interceptor.Invoke("setComment$$", "setComment(const QString&, KTitleWidget::MessageType)", typeof(void), typeof(string), comment, typeof(KTitleWidget.MessageType), type);
        }
        [Q_SLOT("void setComment(QString)")]
        public void SetComment(string comment) {
            interceptor.Invoke("setComment$", "setComment(const QString&)", typeof(void), typeof(string), comment);
        }
        /// <remarks>
        /// <param> name="pixmap" Pixmap displayed in the header. The pixmap is by default right, but
        /// </param><param> name="alignment" can be used to display it also left.
        /// </param></remarks>        <short>   </short>
        ///         <see> pixmap</see>
        [Q_SLOT("void setPixmap(QPixmap, ImageAlignment)")]
        public void SetPixmap(QPixmap pixmap, KTitleWidget.ImageAlignment alignment) {
            interceptor.Invoke("setPixmap#$", "setPixmap(const QPixmap&, KTitleWidget::ImageAlignment)", typeof(void), typeof(QPixmap), pixmap, typeof(KTitleWidget.ImageAlignment), alignment);
        }
        [Q_SLOT("void setPixmap(QPixmap)")]
        public void SetPixmap(QPixmap pixmap) {
            interceptor.Invoke("setPixmap#", "setPixmap(const QPixmap&)", typeof(void), typeof(QPixmap), pixmap);
        }
        /// <remarks>
        /// <param> name="icon" name of the icon to display in the header. The pixmap is by default right, but
        /// </param><param> name="alignment" can be used to display it also left.
        /// </param></remarks>        <short>   </short>
        ///         <see> pixmap</see>
        [Q_SLOT("void setPixmap(QString, ImageAlignment)")]
        public void SetPixmap(string icon, KTitleWidget.ImageAlignment alignment) {
            interceptor.Invoke("setPixmap$$", "setPixmap(const QString&, KTitleWidget::ImageAlignment)", typeof(void), typeof(string), icon, typeof(KTitleWidget.ImageAlignment), alignment);
        }
        [Q_SLOT("void setPixmap(QString)")]
        public void SetPixmap(string icon) {
            interceptor.Invoke("setPixmap$", "setPixmap(const QString&)", typeof(void), typeof(string), icon);
        }
        /// <remarks>
        /// <param> name="pixmap" the icon to display in the header. The pixmap is by default right, but
        /// </param><param> name="alignment" can be used to display it also left.
        /// </param></remarks>        <short>   </short>
        ///         <see> pixmap</see>
        [Q_SLOT("void setPixmap(QIcon, ImageAlignment)")]
        public void SetPixmap(QIcon icon, KTitleWidget.ImageAlignment alignment) {
            interceptor.Invoke("setPixmap#$", "setPixmap(const QIcon&, KTitleWidget::ImageAlignment)", typeof(void), typeof(QIcon), icon, typeof(KTitleWidget.ImageAlignment), alignment);
        }
        [Q_SLOT("void setPixmap(QIcon)")]
        public void SetPixmap(QIcon icon) {
            interceptor.Invoke("setPixmap#", "setPixmap(const QIcon&)", typeof(void), typeof(QIcon), icon);
        }
        /// <remarks>
        /// <param> name="pixmap" the icon to display in the header. The pixmap is by default right, but
        /// </param><param> name="alignment" can be used to display it also left.
        /// </param></remarks>        <short>   </short>
        ///         <see> pixmap</see>
        [Q_SLOT("void setPixmap(MessageType, ImageAlignment)")]
        public void SetPixmap(KTitleWidget.MessageType type, KTitleWidget.ImageAlignment alignment) {
            interceptor.Invoke("setPixmap$$", "setPixmap(KTitleWidget::MessageType, KTitleWidget::ImageAlignment)", typeof(void), typeof(KTitleWidget.MessageType), type, typeof(KTitleWidget.ImageAlignment), alignment);
        }
        [Q_SLOT("void setPixmap(MessageType)")]
        public void SetPixmap(KTitleWidget.MessageType type) {
            interceptor.Invoke("setPixmap$", "setPixmap(KTitleWidget::MessageType)", typeof(void), typeof(KTitleWidget.MessageType), type);
        }
        /// <remarks>
        ///  Set the autohide timeout of the label
        ///  Set value to 0 to disable autohide, which is the default.
        /// <param> name="msecs" timeout value in milliseconds
        ///      </param></remarks>        <short>    Set the autohide timeout of the label  Set value to 0 to disable autohide, which is the default.</short>
        [Q_SLOT("void setAutoHideTimeout(int)")]
        public void SetAutoHideTimeout(int msecs) {
            interceptor.Invoke("setAutoHideTimeout$", "setAutoHideTimeout(int)", typeof(void), typeof(int), msecs);
        }
        [SmokeMethod("changeEvent(QEvent*)")]
        protected override void ChangeEvent(QEvent e) {
            interceptor.Invoke("changeEvent#", "changeEvent(QEvent*)", typeof(void), typeof(QEvent), e);
        }
        [SmokeMethod("showEvent(QShowEvent*)")]
        protected override void ShowEvent(QShowEvent arg1) {
            interceptor.Invoke("showEvent#", "showEvent(QShowEvent*)", typeof(void), typeof(QShowEvent), arg1);
        }
        [SmokeMethod("eventFilter(QObject*, QEvent*)")]
        protected new virtual bool EventFilter(QObject arg1, QEvent arg2) {
            return (bool) interceptor.Invoke("eventFilter##", "eventFilter(QObject*, QEvent*)", typeof(bool), typeof(QObject), arg1, typeof(QEvent), arg2);
        }
        ~KTitleWidget() {
            interceptor.Invoke("~KTitleWidget", "~KTitleWidget()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KTitleWidget", "~KTitleWidget()", typeof(void));
        }
        protected new IKTitleWidgetSignals Emit {
            get { return (IKTitleWidgetSignals) Q_EMIT; }
        }
    }

    public interface IKTitleWidgetSignals : IQWidgetSignals {
    }
}
