/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.optimizers;

import java.util.List;
import java.util.Locale;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.sail.rdbms.algebra.FalseValue;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.algebra.SqlAnd;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlCompare;
import org.openrdf.sail.rdbms.algebra.SqlConcat;
import org.openrdf.sail.rdbms.algebra.SqlEq;
import org.openrdf.sail.rdbms.algebra.SqlIsNull;
import org.openrdf.sail.rdbms.algebra.SqlLowerCase;
import org.openrdf.sail.rdbms.algebra.SqlNot;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.SqlOr;
import org.openrdf.sail.rdbms.algebra.StringValue;
import org.openrdf.sail.rdbms.algebra.TrueValue;
import org.openrdf.sail.rdbms.algebra.base.BinarySqlOperator;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlConstant;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.base.UnarySqlOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstantOptimizer
extends RdbmsQueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    @Override
    public void meet(SelectQuery node) throws RuntimeException {
        super.meet(node);
        List<SqlExpr> filters = node.getFilters();
        for (int i = filters.size() - 1; i >= 0; --i) {
            if (!(filters.get(i) instanceof TrueValue)) continue;
            node.removeFilter(filters.get(i));
        }
    }

    @Override
    public void meet(SqlAnd node) throws RuntimeException {
        super.meet(node);
        SqlExpr left = node.getLeftArg();
        SqlExpr right = node.getRightArg();
        if (left instanceof FalseValue || right instanceof FalseValue) {
            this.replace(node, new FalseValue());
        } else if (left instanceof TrueValue && right instanceof TrueValue) {
            this.replace(node, new TrueValue());
        } else if (left instanceof TrueValue) {
            this.replace(node, right.clone());
        } else if (right instanceof TrueValue) {
            this.replace(node, left.clone());
        } else if (right instanceof SqlNull || left instanceof SqlNull) {
            this.replace(node, new SqlNull());
        } else if (right instanceof SqlNot && ((SqlNot)right).getArg().equals(left)) {
            this.replace(node, new FalseValue());
        } else if (left instanceof SqlNot && ((SqlNot)left).getArg().equals(right)) {
            this.replace(node, new FalseValue());
        }
    }

    @Override
    public void meet(SqlCase node) throws RuntimeException {
        super.meet(node);
        List<SqlCase.Entry> entries = node.getEntries();
        for (SqlCase.Entry e : entries) {
            if (e.getCondition() instanceof SqlNull) {
                node.removeEntry(e);
                continue;
            }
            if (e.getCondition() instanceof FalseValue) {
                node.removeEntry(e);
                continue;
            }
            if (!(e.getCondition() instanceof TrueValue)) continue;
            node.truncateEntries(e);
            break;
        }
        if ((entries = node.getEntries()).isEmpty()) {
            this.replace(node, new SqlNull());
        } else if (entries.size() == 1) {
            SqlIsNull is;
            SqlNot not;
            SqlCase.Entry entry = entries.get(0);
            if (entry.getCondition() instanceof TrueValue) {
                this.replace(node, entry.getResult().clone());
            } else if (entry.getCondition() instanceof FalseValue) {
                this.replace(node, new SqlNull());
            } else if (entry.getCondition() instanceof SqlNot && (not = (SqlNot)entry.getCondition()).getArg() instanceof SqlIsNull && (is = (SqlIsNull)not.getArg()).getArg().equals(entry.getResult())) {
                this.replace(node, entry.getResult().clone());
            }
        }
    }

    @Override
    public void meet(SqlCompare node) throws RuntimeException {
        super.meet(node);
        SqlExpr left = node.getLeftArg();
        SqlExpr right = node.getRightArg();
        if (left instanceof SqlNull || right instanceof SqlNull) {
            this.replace(node, new SqlNull());
        }
    }

    @Override
    public void meet(SqlConcat node) throws RuntimeException {
        super.meet(node);
        SqlExpr left = node.getLeftArg();
        SqlExpr right = node.getRightArg();
        if (left instanceof StringValue && right instanceof StringValue) {
            StringValue l = (StringValue)left;
            StringValue r = (StringValue)right;
            this.replace(node, new StringValue((String)l.getValue() + (String)r.getValue()));
        }
    }

    @Override
    public void meet(SqlEq node) throws RuntimeException {
        super.meet(node);
        SqlExpr left = node.getLeftArg();
        SqlExpr right = node.getRightArg();
        if (left instanceof SqlNull || right instanceof SqlNull) {
            this.replace(node, new SqlNull());
        } else if (left instanceof SqlConstant && right instanceof SqlConstant) {
            SqlConstant l = (SqlConstant)left;
            SqlConstant r = (SqlConstant)right;
            if (l.getValue().equals(r.getValue())) {
                this.replace(node, new TrueValue());
            } else {
                this.replace(node, new FalseValue());
            }
        }
    }

    @Override
    public void meet(SqlIsNull node) throws RuntimeException {
        super.meet(node);
        SqlExpr arg = node.getArg();
        if (arg instanceof SqlNull) {
            this.replace(node, new TrueValue());
        } else if (arg instanceof SqlConstant) {
            this.replace(node, new FalseValue());
        } else if (arg instanceof SqlCase) {
            SqlExpr rep = null;
            SqlExpr prev = null;
            SqlCase scase = (SqlCase)arg;
            for (SqlCase.Entry entry : scase.getEntries()) {
                SqlExpr condition = entry.getCondition();
                if (rep == null) {
                    rep = SqlExprSupport.and(condition.clone(), SqlExprSupport.isNull(entry.getResult().clone()));
                    prev = SqlExprSupport.not(condition.clone());
                    continue;
                }
                rep = SqlExprSupport.or(rep, SqlExprSupport.and(SqlExprSupport.and(prev.clone(), condition.clone()), SqlExprSupport.isNull(entry.getResult().clone())));
                prev = SqlExprSupport.and(prev, SqlExprSupport.not(condition.clone()));
            }
            this.replace(node, SqlExprSupport.or(rep, prev.clone()));
        }
    }

    @Override
    public void meet(SqlLowerCase node) throws RuntimeException {
        super.meet(node);
        if (node.getArg() instanceof SqlNull) {
            this.replace(node, new SqlNull());
        } else if (node.getArg() instanceof SqlConstant) {
            SqlConstant arg = (SqlConstant)node.getArg();
            String lower = arg.getValue().toString().toLowerCase(Locale.US);
            this.replace(node, SqlExprSupport.str(lower));
        }
    }

    @Override
    public void meet(SqlNot node) throws RuntimeException {
        super.meet(node);
        SqlExpr arg = node.getArg();
        if (arg instanceof TrueValue) {
            this.replace(node, new FalseValue());
        } else if (arg instanceof FalseValue) {
            this.replace(node, new TrueValue());
        } else if (arg instanceof SqlNull) {
            this.replace(node, new SqlNull());
        } else if (arg instanceof SqlNot) {
            SqlNot not = (SqlNot)arg;
            this.replace(node, not.getArg().clone());
        } else if (arg instanceof SqlOr) {
            SqlOr or = (SqlOr)arg;
            this.replace(node, SqlExprSupport.and(SqlExprSupport.not(or.getLeftArg().clone()), SqlExprSupport.not(or.getRightArg().clone())));
        }
    }

    @Override
    public void meet(SqlOr node) throws RuntimeException {
        super.meet(node);
        SqlExpr left = node.getLeftArg();
        SqlExpr right = node.getRightArg();
        if (left instanceof TrueValue || right instanceof TrueValue) {
            this.replace(node, new TrueValue());
        } else if (left instanceof FalseValue && right instanceof FalseValue) {
            this.replace(node, new FalseValue());
        } else if (left instanceof FalseValue) {
            this.replace(node, right.clone());
        } else if (right instanceof FalseValue) {
            this.replace(node, left.clone());
        } else if (right instanceof SqlNull && this.andAllTheWay(node)) {
            this.replace(node, left.clone());
        } else if (left instanceof SqlNull && this.andAllTheWay(node)) {
            this.replace(node, right.clone());
        } else if (right instanceof SqlNull && left instanceof SqlNull) {
            this.replace(node, new SqlNull());
        } else if (left instanceof SqlNull && right instanceof SqlOr) {
            SqlOr r = (SqlOr)right;
            SqlExpr rleft = r.getLeftArg();
            SqlExpr rright = r.getRightArg();
            if (rleft instanceof SqlNull || rright instanceof SqlNull) {
                this.replace(node, right.clone());
            }
        } else if (right instanceof SqlNull && left instanceof SqlOr) {
            SqlOr l = (SqlOr)left;
            SqlExpr lleft = l.getLeftArg();
            SqlExpr lright = l.getRightArg();
            if (lleft instanceof SqlNull || lright instanceof SqlNull) {
                this.replace(node, left.clone());
            }
        } else if (right instanceof SqlNull && left instanceof SqlAnd) {
            SqlExpr isNotNull;
            SqlAnd l = (SqlAnd)left;
            SqlExpr lleft = l.getLeftArg();
            SqlExpr lright = l.getRightArg();
            SqlExpr isNotEq = this.other(lright, isNotNull = this.arg(this.arg(lleft, SqlNot.class), SqlIsNull.class), SqlEq.class);
            if (isNotEq instanceof SqlConstant) {
                this.replace(node, lright);
            }
        }
    }

    public void optimize(SqlExpr sqlExpr) {
        sqlExpr.visit(this);
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(this);
    }

    private boolean andAllTheWay(QueryModelNode node) {
        if (node.getParentNode() instanceof SelectQuery) {
            return true;
        }
        if (node.getParentNode() instanceof FromItem) {
            return true;
        }
        if (node.getParentNode() instanceof SqlAnd) {
            return this.andAllTheWay(node.getParentNode());
        }
        return false;
    }

    private SqlExpr arg(SqlExpr node, Class<? extends UnarySqlOperator> type) {
        if (type.isInstance(node)) {
            return type.cast(node).getArg();
        }
        return null;
    }

    private SqlExpr other(SqlExpr node, SqlExpr compare, Class<? extends BinarySqlOperator> type) {
        if (type.isInstance(node)) {
            BinarySqlOperator cast = type.cast(node);
            SqlExpr left = cast.getLeftArg();
            SqlExpr right = cast.getRightArg();
            if (left.equals(compare)) {
                return right;
            }
            if (right.equals(compare)) {
                return left;
            }
        }
        return null;
    }

    private void replace(SqlExpr before, SqlExpr after) {
        before.replaceWith(after);
        after.visit(this);
    }
}

