/*
* canvas.h -- Declaration of class KImageCanvas.
* Generated by newclass on Thu Oct  9 09:03:54 EST 1997.
*/
#ifndef SSK_CANVAS_H
#define SSK_CANVAS_H

#include<qstring.h>
#include<qwmatrix.h>
#include<qlabel.h>
#include<qscrollview.h>

class KVImageHolder;
class QPainter;
class QPaintDevice;
class QPen;

/**
* @short KImageCanvas
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: canvas.h,v 1.8 1999/01/10 18:16:44 ssk Exp $
*/
class KImageCanvas : public QScrollView
{
	Q_OBJECT
public:
	enum Error { OK, BadPath, BadFormat, NoMemory };
	/**
	* KImageCanvas Constructor
	*/
	KImageCanvas( QWidget *parent = 0 );

	/**
	* KImageCanvas Destructor
	*/
	virtual ~KImageCanvas();

	/**
	* Check canvas status.
	* @return Status code
	* @see ::Error
	*/
	Error status() const;
public:
	/**
	*
	*/
	int load( const char *file, const char *URL=0, bool max = false );
	/**
	*
	*/
	bool save( const char *URL, const char *format=0 );

	/**
	* Resets the image to as loaded.
	*/
	void reset();

	/**
	* Clears the image to blank.
	*/
	void clear();
	
	/**
	* Transform the image by the matrix.
	*/
	void transformImage( const QWMatrix& mat );



	/**
	* Tile the image to the desktop
	*/
	void tileToDesktop() const;

	/**
	*
	*/
	void maxToDesktop() const;
	/**
	*
	*/
	void maxpectToDesktop() const;

	/**
	* Get the current image.
	*/
	QImage getImage() const;

	/**
	* Get the url for the current image.
	*/
	QString url() const;

	void copyImage( QPaintDevice *dest ) const;

public slots:
	void setImage( const QImage& );

	/**
	* Crop image to the current selection, if any.
	* If there is no selection, nothing happens.
	*/
	void cropImage();

	void maxToWin();
	void maxpectToWin();

	// image scrolling

	void pageDown() { verticalScrollBar()->addPage(); }
	void pageUp() { verticalScrollBar()->subtractPage(); }

	void lineDown() { verticalScrollBar()->addLine(); }
	void lineUp() { verticalScrollBar()->subtractLine(); }

	void pageRight() { horizontalScrollBar()->addPage(); }
	void pageLeft() { horizontalScrollBar()->subtractPage(); }

	void lineRight() { horizontalScrollBar()->addLine(); }
	void lineLeft() { horizontalScrollBar()->subtractLine(); }

protected:
	/**
	*
	*/
	void resizeEvent( QResizeEvent * );
	
	void mouseReleaseEvent( QMouseEvent * );

	/**
	* Sets the status.
	*/
	void setStatus( Error );

signals:
	/**
	*
	*/
	void imageSizeChanged();
    void contextPress(const QPoint&);

private:
	Error		_status;
	QString		_file;

	QSize		_originalSize;
	KVImageHolder	*_client;

	QPixmap		*_orig;

	/**
	* Returns a pixmap that is to be used for editing.
	*/
	QPixmap *transPixmap();
};

inline void KImageCanvas::setStatus( Error e )
{
	_status = e;
}

inline QString KImageCanvas::url() const
{
	return _file;
}

/**
* Image widget, used as child in canvas.
*/
class KVImageHolder : public QLabel
{
	Q_OBJECT
private:
	QRect _selection;

	bool _selected;

	QPainter *_painter;
	QPen *_pen;

public:
	KVImageHolder( QWidget *parent = 0 );

	virtual ~KVImageHolder();

	/**
	* Return the current selection.  If no selection has been made,
	* the returned rectangle will be null.
	*/
	QRect selected() const;
	QPixmap selection();

	void clearSelection() { _selected = false; }

	void setImagePix( const QPixmap& image );
    
signals:
    void contextPress(const QPoint&);
 

protected:
	void mousePressEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );

	void paintEvent( QPaintEvent * );

private:
	void drawSelect();
	void eraseSelect();
};

#endif // SSK_CANVAS_H
