/*
 * Definiowanie Menu Gwnego dla WindowMakera
 * Fonty w standardzie ISO8895-2
 *
 * Skadnia jest nastpujca:
 *
 * <Tytu> [SHORTCUT <Skrut>] <Komenda> <Paramery>
 *
 * <Tytu> Tytu moe by dowolnym cigiem znakw. Jeli bd w nim wystpowa
 *         spacje umiec go w cudzysowie np. "Tytu ze spacj"
 * 
 * SHORTCUT Definiowanie skrtu.
 * <Skrt> Nazwa rodzaju skrtu umieszczonego w pliku
 *         $HOME/GNUstep/Defaults/WindowMaker, tak jak RootMenuKey 
 *         lub MiniaturizeKey.
 *
 * Skrty mog wystpowa w sekcji MENU lub OPEN_MENU .
 * 
 * <Komenda> jedna z dostpnych komend: 
 *	MENU - rozpoczcie definicji (pod)menu 
 *	END  - zakoczenie definicji (pod)menu 
 *	OPEN_MENU - generowanie podmenu na podstawie podanego katalogu,
 *              umieszczajc w nim pliki wykonywalne i podkatalogi.
 *	WORKSPACE_MENU - Dodanie podmenu zawierajcego aktywne pulpity. Tylko
 *		             jedno workspace_menu jest potrzebne. 		
 *	EXEC <program> - wykonanie jakiegokolwiek programu
 *	EXIT - wyjcie z menadera okien
 *	RESTART [<window manager>] - restart WindowMakera albo start innego
 *			                     manadera okien
 *	REFRESH - odwierzenie ekranu
 *	ARRANGE_ICONS - uporzdkowanie ikon na pulpicie
 *	SHUTDOWN - zabicie wszystkich procesw (i wyjcie z X window)
 *	SHOW_ALL - pokazanie wszystkich ukrytych programw
 *  HIDE_OTHERS - schowanie aktywnych okien pulpitu, oprcz aktywnego
 *  SAVE_SESSION - zapamietanie aktualnego stanu desktpou, z wszystkimi
 *                 uruchomionymi programami, i z wszystkimi ich stanami
 *                 geometrycznymi, pozycji na ekranie, umieszczone na
 *                 odpowiednim pulpicie, ukryte lub uaktywnione.
 *                 Wszystkie te ustawiemia bed aktywne, dopki nie
 *                 zostan uyte komendy SAVE_SESSION i CLEAR_SESSION.
 *                 Jeeli SaveSessionOnExit = Yes; w pliku konfiguracyjnym
 *                 WindowMakera, wtedy zapamitywanie wszystkich ustawie
 *                 jest dokonywanie po kadym wyjciu, niezalenie od
 *                 komend SAVE_SESSION czy CLEAR_SESSION .
 *  CLEAR_SESSION - Czyszczenie poprzednio zapamitanych sesji. Nie ponosi to
 *                  adnych zmian w pliku SaveSessionOnExit .
 *  INFO - Wywietlenie informacji o WindowMakerze
 *
 * <Parametry> zalezne od uruchamianego programu.
 *
 * ** Opcje w lini komend EXEC:
 * %s - znak jest zastepowany przez text znajdujacy sie w ,,schowku''
 * %a(tytu[,komunikat]) - otwiera dodatkowe okno o tytule tytu, komunikacie
 *                         komunikat i czeka na podanie parametrw, ktre 
 *                         zostan wstawione zamiast %a. Niestety nie udalo mi
 *                         si uzyska polskich fontw w tej pocji :( 
 * %w - znak jest zastepowany przez XID aktywnego okna
 * %W - znak jest zastepowany przez numer aktywnego pulpitu
 * 
 * Aby uywa specjalnych znakw ( takich jak % czy " ) naley poprzedzic je znakiem \
 * np. :xterm -T "\"Witaj wiecie\""
 *
 * Mona uywac znakw specjalnych, takich jak \n
 *
 * Sekcja MENU musi by zakoczona sekcja END, pod t sama nazw.
 *
 * Przykad:
 *
 * "Test" MENU
 *  "XTerm" EXEC xterm
 *      // stworzenie podmenu z plikami w podkatalogu /usr/openwin/bin
 *  "XView apps" OPEN_MENU "/usr/openwin/bin"
 *      // umieszcza w jednym podmenu pliki z rznych podkatalogw
 *  "X11 apps" OPEN_MENU /usr/X11/bin $HOME/bin/X11
 *      // ustawienie ta
 *  "Background" OPEN_MENU -noext $HOME/images /usr/share/images WITH wmsetbg -u *      // wstawienie menu z pliku style.menu
 *      // wstawienie menu z pliku style.menu
 *  "Style" OPEN_MENU style.menu
 * "Test" END
 *
 * Jeeli zamiast polskich fontw s jakie krzaczki naley wyedetowa pliki
 * $HOME/GNUstep/Defaults/WMGLOBAL i $HOME/GNUstep/Defaults/WindowMaker,  
 * lub wej w menu Konfiguracja.
 * Aby uzyska polskie znaki naley uzupeni definicje fontw.
 * np. zamieni
 *
 * SystemFont = "-*-helvetica-medium-r-normal-*-%d-100-*-*-*-*-*-*";
 *
 * na
 *
 * SystemFont = "-*-helvetica-medium-r-normal-*-%d-100-*-*-*-*-iso8859-2";
 *
 * i wszdzie tam gdzie wystpuje podobna definicja.
 */
                  

#include "wmmacros"
#define ULUB_EDYTOR vi 
/* Jeli nie lubisz edytora vi zmie na swj ulubiony edytor */
#define ULUB_TERM xterm
/* A tutaj ustaw swj ulubiony terminal */

"WindowMaker" MENU
	"Informacja" MENU
		"Informacja o WMaker..." INFO_PANEL
		"Legalno..."           LEGAL_PANEL
		"Konsola Systemu"        EXEC xconsole
		"Obcienie Systemu"     EXEC xosview || xload
		"Lista Procesw"         EXEC ULUB_TERM -T "Lista Procesw" -e top
		"Przegldarka Manuali"   EXEC xman
	"Informacja" END
	
	"Konfiguracja" MENU	
		"Edycja menu"       EXEC ULUB_TERM -T "Edycja menu" -e ULUB_EDYTOR $HOME/GNUstep/Library/WindowMaker/menu
		"Ustawienie fontw" EXEC ULUB_TERM -T "Ustawienie fontw" -e ULUB_EDYTOR $HOME/GNUstep/Defaults/WMGLOBAL
		"Konfiguracja"      EXEC ULUB_TERM -T "Konfiguracja" -e ULUB_EDYTOR $HOME/GNUstep/Defaults/WindowMaker
	"Konfiguracja" END
	
	"Uruchom..." EXEC %a(Uruchom,Wpisz komende do uruchomienia:)
	"Terminal"   EXEC ULUB_TERM -T "Mj ulubiony terminal" -sb 
	"Edytor"     EXEC ULUB_TERM -T "Moj ulubiony edytor" -e ULUB_EDYTOR %a(Edytor,Podaj plik do edycji:)
	"Pulpity"    WORKSPACE_MENU
	
	"Aplikacje" MENU
		"Grafika" MENU
			"Gimp"        EXEC gimp >/dev/null
			"XV"          EXEC xv
			"XFig"        EXEC xfig
			"XPaint"      EXEC xpaint
			"Gnuplot"     EXEC ULUB_TERM -T "GNU plot" -e gnuplot
			"Edytor ikon" EXEC bitmap
		"Grafika" END
		"Tekst" MENU
			"LyX"                 EXEC lyx
  			"Ghostview"           EXEC gv %a(GhostView,Wprowadz nazwe pliku *.ps *.pdf *.no:)
  			"XDvi"                EXEC xdvi %a(XDvi,Wprowadz nazwe pliku *.dvi:)
			"Acrobat"             EXEC /usr/local/Acrobat3/bin/acroread %a(Acrobat,Wprowadz nazwe pliku *.pdf:)
			"Xpdf"                EXEC xpdf %a(Xpdf,Wprowadz nazwe pliku *.pdf:)
			"Arkusz kalkulacyjny" EXEC xspread
		"Tekst" END
		"X File Manager"     EXEC xfm
		"OffiX Files"        EXEC files
		"TkDesk"             EXEC tkdesk
		"Midnight Commander" EXEC ULUB_TERM -T "Midnight Commander" -e mc
		"X Gnu debbuger"     EXEC xxgdb
		"Xwpe"               EXEC xwpe
	"Aplikacje" END
	
	"Internet" MENU
		"Przegldarki" MENU
			"Netscape" EXEC netscape 
			"Arena"    EXEC arena
			"Lynx"     EXEC ULUB_TERM -e lynx %a(Lynx,Podaj URL:)
		"Przegldarki" END
		"Programy pocztowe" MENU
			"Pine" EXEC ULUB_TERM -T "Program pocztowy Pine" -e pine 
			"Elm"  EXEC ULUB_TERM -T "Program pocztowy Elm" -e elm
			"Xmh"  EXEC xmh
		"Programy pocztowe" END
		"Emulator terminala" MENU
			"Minicom" EXEC xminicom
			"Seyon"   EXEC seyon
		"Emulator terminala" END
		"Telnet"     EXEC ULUB_TERM -e telnet %a(Telnet,Podaj nazwe hosta:)
		"Ssh"        EXEC ULUB_TERM -e ssh %a(Ssh,Podaj nazwe hosta:)
		"Ftp"        EXEC ULUB_TERM -e ftp %a(Ftp,Podaj nazwe hosta:)
		"Irc"        EXEC ULUB_TERM -e irc %a(Irc,Podaj swoj pseudonim:)
		"Ping"       EXEC ULUB_TERM -e ping %a(Ping,Podaj nazwe hosta:)
		"Talk"       EXEC ULUB_TERM -e talk %a(Talk,Podaj nazwe uzytkownika, z ktorym chcesz nawiazac polaczenie:)
	"Internet" END

	"Editory" MENU
		"XFte"    EXEC xfte
		"XEmacs"  EXEC xemacs || emacs
		"XJed"    EXEC xjed 
		"NEdit"   EXEC nedit
		"Xedit"   EXEC xedit
		"Editres" EXEC editres
		"VI"      EXEC ULUB_TERM -e vi
	"Editory" END
	
	"Dwik" MENU
		"CDPlay"  EXEC workbone
		"Xmcd"    EXEC xmcd 2> /dev/null
		"Xplaycd" EXEC xplaycd
		"Xmixer"  EXEC xmixer
	"Dwik" END
	
    "Gry" MENU
    	"Maze"      EXEC maze
    	"Karty "    EXEC spider
    	"Londownik" EXEC xlander
    	"Szachy "   EXEC xboard
    	"Xeyes"     EXEC xeyes -geometry 51x23
    	"Xmahjongg" EXEC xmahjongg
    	"Xlogo"     EXEC xlogo
    	"Xroach"    EXEC xroach
    	"Xtetris"   EXEC xtetris -color
    	"Xvier"     EXEC xvier
    	"Xgas"      EXEC xgas
    	"Xkobo"     EXEC xkobo
    	"xboing"    EXEC xboing -sound
    	"XBill"     EXEC xbill
    "Gry" END
	
	"Uytki" MENU
		"Kalkulator"          EXEC xcalc
		"Zegarek"             EXEC xclock
		"Opcje Okna"          EXEC xprop | xmessage -center -title 'xprop' -file -
		"Przegldarka Fontw" EXEC xfontsel
		"Szko Powikszajce" EXEC xmag
		"Mapa Kolorw"        EXEC xcmap
		"XKill"               EXEC xkill
		"Clipboard"           EXEC xclipboard
	"Uytki" END

	"Selekcyjne" MENU
		"Kopia"                  EXEC echo '%s' | wxcopy
		"Poczta do ..."          EXEC ULUB_TERM -name mail -T "Pine" -e pine %s
		"Serfuj do ..."          EXEC netscape %s
		"Pobierz Manual ..."     EXEC MANUAL_SEARCH(%s)
		"Pocz si z ..."       EXEC telnet %s
		"Pobierz plik z FTP ..." EXEC ftp %s
	"Selekcyjne" END

	"Ekran" MENU
		"Ukryj Pozostae"         HIDE_OTHERS
		"Poka wszystko"          SHOW_ALL
		"Uporzdkowanie icon"     ARRANGE_ICONS
		"Odswie"                 REFRESH
		"Zablokuj"                EXEC xlock -allowroot -usefirst
		"Zachowaj Sesje"          SAVE_SESSION
		"Wyczy zachowan sesje" CLEAR_SESSION
	"Ekran" END

	"Wygld" MENU
		"Tematy"          OPEN_MENU -noext THEMES_DIR $HOME/GNUstep/Library/WindowMaker/Themes WITH setstyle
		"Style"           OPEN_MENU -noext STYLES_DIR $HOME/GNUstep/Library/WindowMaker/Styles WITH setstyle
		"Ustawienia ikon" OPEN_MENU -noext ICON_SETS_DIR $HOME/GNUstep/Library/WindowMaker/IconSets WITH seticons
		"To" MENU
			"Jednolite" MENU
               	"Czarny"            WS_BACK '(solid, black)'
               	"Niebieski"         WS_BACK '(solid, "#505075")'
				"Indigo"            WS_BACK '(solid, "#243e6c")'
				"Gboko Niebieski" WS_BACK '(solid, "#224477")'
               	"Fioletowy"         WS_BACK '(solid, "#554466")'
               	"Pszeniczny"        WS_BACK '(solid, "wheat4")'
               	"Ciemno Szary"      WS_BACK '(solid, "#333340")'
               	"Winny"             WS_BACK '(solid, "#400020")'
			"Jednolite" END
			"Cieniowane" MENU
				"Zachd Soca"         WS_BACK '(mvgradient, deepskyblue4, black, deepskyblue4, tomato4)'
				"Niebo"                 WS_BACK '(vgradient, blue4, white)'
    			"Cieniowany Niebieski"  WS_BACK '(vgradient, "#7080a5", "#101020")'
				"Cieniowane Indigo"     WS_BACK '(vgradient, "#746ebc", "#242e4c")'
			   	"Cieniowany Fioletowy"  WS_BACK '(vgradient, "#654c66", "#151426")'
    			"Cieniowany Pszeniczny" WS_BACK '(vgradient, "#a09060", "#302010")'
    			"Cieniowany Szary"      WS_BACK '(vgradient, "#636380", "#131318")'
    			"Cieniowany Winnny"     WS_BACK '(vgradient, "#600040", "#180010")'
			"Cieniowane" END
			"Obrazki" OPEN_MENU -noext BACKGROUNDS_DIR $HOME/GNUstep/Library/WindowMaker/Backgrounds WITH wmsetbg -u -t
		"To" END
		"Zaoamitanie Tematu"        EXEC getstyle -t $HOME/GNUstep/Library/WindowMaker/Themes/"%a(Nazwa tematu,Wpisz nazwe pliku:)"
		"Zapamitanie Ustawie Ikon" EXEC geticonset $HOME/GNUstep/Library/WindowMaker/IconSets/"%a(Ustawienia ikon,wpisz nazwe pliku:)"
	"Wygld" END

	"Wyjcie" MENU
		"Przeadowanie"    RESTART
		"Start BlackBox"   RESTART blackbox
		"Start kwm"        RESTART kwm
		"Start IceWM"      RESTART icewm
		"Wyjcie..."       EXIT
		"Zabicie sesji..." SHUTDOWN
	"Wyjcie" END
"WindowMaker" END
