/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef KBABELPREF_H
#define KBABELPREF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include <qptrlist.h>

class SavePreferences;
class IdentityPreferences;
class MiscPreferences;
class EditorPreferences;
class SearchPreferences;
class DiffPreferences;
class SpellPreferences;
struct ModuleInfo;

#include "settings.h"
#include "context.h"

class KBabelPreferences : public KDialogBase
{
    Q_OBJECT
public:
    KBabelPreferences(SearchSettings,EditorSettings,SpellcheckSettings,KBabel::SaveSettings
                ,KBabel::IdentitySettings,KBabel::MiscSettings,SourceContextSettings
                ,QPtrList<ModuleInfo>);

public slots:
    void updateSaveSettings(KBabel::SaveSettings);
    void updateIdentitySettings(KBabel::IdentitySettings);
    void updateSearchSettings(SearchSettings);
    void updateMiscSettings(KBabel::MiscSettings);
    void updateSourceContextSettings(SourceContextSettings);

signals:
    void identityOptionsChanged(KBabel::IdentitySettings);
    void saveOptionsChanged(KBabel::SaveSettings);
    void editorOptionsChanged(EditorSettings);
    void spellcheckOptionsChanged(SpellcheckSettings);
    void searchOptionsChanged(SearchSettings);
    void miscOptionsChanged(KBabel::MiscSettings);
    void sourceContextOptionsChanged(SourceContextSettings);

protected slots:
   virtual void slotHelp();
   virtual void slotDefault();
   virtual void slotApply();
   virtual void slotOk();
   virtual void slotCancel();


private:
    SavePreferences *_savePage;
    IdentityPreferences* _identityPage;
    EditorPreferences* _editorPage;
    SearchPreferences* _searchPage;
    MiscPreferences* _miscPage;
    DiffPreferences* _diffPage;
    SpellPreferences* _spellPage;
    SourceContextPreferences* _sourcePage;

    KBabel::SaveSettings _saveSettings;
    KBabel::IdentitySettings _idSettings;
    EditorSettings _editorSettings;
    SpellcheckSettings _spellcheckSettings;
    SearchSettings _searchSettings;
    KBabel::MiscSettings _miscSettings;
    SourceContextSettings _sourceSettings;
};


#endif // KBABELPREF_H
