/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qpixmap.h>

#include <kgenericfactory.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "areaperimeterwidget.h"
#include "kmathtool_geometry.h"


typedef KGenericFactory<KMathToolGeometry> KMathToolGeometryFactory;
K_EXPORT_COMPONENT_FACTORY(kmathtool_geometry, KMathToolGeometryFactory)

KMathToolGeometry::KMathToolGeometry(QObject* parent, const char* name, const QStringList&)
  : KMathToolModule(parent, name)
{
  QStringList groups;
  groups << i18n("Geometry") << i18n("Area and Perimeter");

  AreaPerimeterWidget* view;

  view = new AreaPerimeterWidget(AreaPerimeterWidget::Circle, widget( ));
  view->setHeading(i18n("Area and Perimeter of a Circle"));
  view->setPixmap(locate("appdata", "pics/circle.png"));
  view->setName(i18n("Circle"));
  view->setGroups(groups);
  addView(view);

  view = new AreaPerimeterWidget(AreaPerimeterWidget::Rectangle, widget( ));
  view->setHeading(i18n("Area and Perimeter of a Rectangle"));
  view->setPixmap(locate("appdata", "pics/rectangle.png"));
  view->setName(i18n("Rectangle"));
  view->setGroups(groups);
  addView(view);

  view = new AreaPerimeterWidget(AreaPerimeterWidget::Square, widget( ));
  view->setHeading(i18n("Area and Perimeter of a Square"));
  view->setPixmap(locate("appdata", "pics/square.png"));
  view->setName(i18n("Square"));
  view->setGroups(groups);
  addView(view);
}

#include "kmathtool_geometry.moc"
