/* XQDTK.H */
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/keysym.h>

/*
  Bits in the "flags" field of Button structure
*/
#define		DISABLED	1	/* button has been disabled */
#define		HIGHLIGHTED	2	/* button is highlighted */

/*
  Codes for justification of text
*/
typedef enum	{
		Right, Left, Centered,
		North, East, South, West,
		NEast, NWest, SEast, SWest
		} Justification;

/* Entries in pulldown menus are of type PulldownEntry */
typedef struct {
		char name[20];
	        void (*function)(int);
	        int arg;
	       } PulldownEntry;

/*
  Structure returned by button making functions
*/
typedef struct _button_window	{
				struct _button_window *next;
				Window window;
				void (*function)();
				int arg;
				Pixmap pixmap, disable_pmap;
				int width, height;
				int flags;
				Bool pulldown;	/* true if the button is in */
				} Button;	/* a pulldown menu */


typedef struct _pulldown	{
				struct _pulldown *next;
	        		Window window;
				int width, height;
	        		int num_entries;
				int menu_id;	
				Button *caller;
	        		Button **pullbutton;
	       			} PulldownMenu; 

/*
  Structure for menu bars
 */
typedef struct _menubar		{
				struct _menubar *next;
				Window window;
				PulldownMenu **menus;
				int num_menus;
				int x, y, width, height;
				int xstart;
				} MenuBar;

typedef Window PopUp;

/*
  Structure returned by x_text_box()
*/
typedef struct _text_window	{
				struct _text_window *next;
				Window window;
				char *text;
				int max_chars;
				Justification just;
				int x, y, width, height;
				} TextBox;

/*
  Structure returned by x_edit_box()
*/
typedef struct _edit_window	{
				struct _edit_window *next;
				Window window;
				char *text;
				int max_chars;
				int first_char, last_char, current_char;
				int x, y, width, height;
				int marker_x;
				void (*function)();
				int arg;
				} EditBox;

typedef enum	{
		Text,
		Points,
		} DisplayItemType;

typedef enum	{
		Connected,
		Disconnected,
		} PointStyle;

/*
  Structure for making graphics display lists
*/
typedef struct _display_item	{
				struct _display_item *next;
				DisplayItemType type;    /* Text or Points */
				int style;   /* Justification or PointStyle */
				int x, y;    /* coordinates (Text only) */
				int size;    /* characters or points */
				union	{    /* text or XPoint array */
					char *text;
					XPoint *points;
					} data;
				} DisplayItem;

/*
  Structure returned by x_graphics_window()
*/
typedef struct _graphics_window	{
				struct _graphics_window *next;
				Window window;
				GC gc;
				void (*function)();
				int arg;
				DisplayItem *list;
				} GraphWindow;

/*
  Global variables
*/

extern Display *display;	/* pointer to display opened by x_init */
extern int black, white;	/* global pixel values obtained from X server */
extern int x_coord, y_coord;	/* coordinates of a button press */
extern int button;		/* ID of button that was pressed */

/*
  Prototypes for toolkit functions
*/

Window x_init(char *name, int x, int y, int width, int height,
		int argc, char *argv[]);

Window x_label(Window parent, char *text, int x, int y,
		int width, int height);

MenuBar *x_create_menubar(Window parent, int x, int y, int width,
		int height, int num_menus);

void x_create_pulldown(MenuBar *mb, char *text, int num_entries, 
		PulldownEntry *entries);

void x_enable_entry(MenuBar *mb, int menu, int entry);

void x_disable_entry(MenuBar *mb, int menu, int entry);

PopUp x_create_popup(Window parent, int x, int y, int width,
		int height);

void x_popup(PopUp w);

void x_popdown(PopUp w);

Button *x_labeled_button(Window parent, char *text, int x, int y,
		int width, int height, void (*function)(int), int arg);

Button *x_picture_button(Window parent, char *bitmap_data, int x, int y,
		int width, int height, void (*function)(int), int arg);

TextBox *x_text_box(Window parent, int max_chars, Justification just,
		int x, int y, int width, int height);

EditBox *x_edit_box(Window parent, int max_chars, int x, int y, 
		int width, int height, void (*function)(int), 
		int arg);

GraphWindow *x_graphics_window(Window parent,
		int x, int y, int width, int height,
		char *tile_data, int tile_width, int tile_height,
		void (*function)(int), int arg, int border_width);
  
void x_draw_text(GraphWindow *gw, char *text,
		int x, int y, Justification just);

void x_draw_points(GraphWindow *gw, XPoint *points, int n_points,
		PointStyle style);

void x_erase_graph(GraphWindow *gw);

void x_activate_edit_box(EditBox *eb, char *prompt, char *init_text);

char *x_get_edit_text(EditBox *eb);

void x_display_text(TextBox *text_box, char *text);

void x_highlight_button(Button *button);

void x_unhighlight_button(Button *button);

void x_enable_button(Button *button);

void x_disable_button(Button *button);

void x_event_loop(void);
