.TH XvQueryBestSize 3X
.\" $XFree86: xc/doc/man/Xv/XvQueryBestSize.man,v 1.4 1999/03/02 11:49:16 dawes Exp $
.SH Name
XvQueryBestSize \- determine the optimum drawable region size
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp 1l
\fBXvQueryBestSize\fP(\fIdpy, port, motion, vw, vh, dw, dh, p_dw, p_dh\fR)
.sp 1l
.B Display \fI*dpy\fR;
.br 
.B XvPortID \fIport\fR; 
.br
.B Bool \fImotion\fR;
.br
.B unsigned 
.B int \fIvw, vh\fR;
.br
\fBunsigned int \fIdw, dh;\fR 
.br 
\fBunsigned int \fI*p_dw, *p_dh;\fR
.\"
.SH Arguments
.\"
.IP \fIdpy\fR 15
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIport\fR 15
Defines the port associated with the display and adaptor for which 
the optimum size is to be calculated.
.IP \fImotion\fR 15
Specifies \fITrue\fP if the destination size needs to support
full motion, and \fIFalse\fP if the destination size need only
support still images.
.IP \fIvw,vh\fR 15
Specifies the size of the source video region desired.
.IP \fIdw,dh\fR 15
Specifies the size of the destination drawable region desired.
.IP \fIp_dw,p_dh\fR 15
Pointers to where the closest destination sizes supported by the server are
returned.
.\"
.SH Description
.\"
Some ports may be able to scale incoming or outgoing video.  
XvQueryBestSize(3X) returns the size of the closest destination
region that is supported by the adaptor.  The returned size is
guaranteed to be smaller than the requested size if a smaller 
size is supported.
.\"
.SH Returned Values
.IP [Success] 8
Returned if XvQueryBestSize(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvQueryBestSize(3X) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.br
