.TH XvSelectVideoNotify 3X
.\" $XFree86: xc/doc/man/Xv/XvSelectVideoNotify.man,v 1.4 1999/03/02 11:49:17 dawes Exp $
.SH Name
XvSelectVideoNotify \- enable or disable VideoNotify events
.\"
.SH Syntax
\fB#include\fI <X11/extensions/Xvlib.h>\fR
.sp 1l
\fBXvSelectVideoNotify(\fIdpy, drawable, onoff\fR)
.sp 1l
\fBregister Display \fI*dpy\fR;
.br
\fBDrawable \fIdrawable\fR;
.br
\fBBool \fIonoff\fR;
.SH Arguments
.\"
.IP \fIdpy\fR 15
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIdrawable\fR 15
Defines the drawable in which video activity is to be reported.
.IP \fIonoff\fR 15
Selects whether video notification is enabled or disabled.
.\"
.SH Description
XvSelectVideoNotify(3X) enables or disables events to be reported for 
video activity in a drawable.
.\"
.SH Returned Values
.IP [Success] 8
Returns True if XvSelectVideoNotify(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvSelectVideoNotify(3X) failed to allocate memory to process
the request.
.Diagnostics
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.SH See Also
.\"
XvVideoNotify
.br
