/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRect.h"

#include "ClientRect.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClientRect);

/* Hash table */

static const HashTableValue JSClientRectTableValues[8] =
{
    { "top", DontDelete|ReadOnly, (intptr_t)jsClientRectTop, (intptr_t)0 },
    { "right", DontDelete|ReadOnly, (intptr_t)jsClientRectRight, (intptr_t)0 },
    { "bottom", DontDelete|ReadOnly, (intptr_t)jsClientRectBottom, (intptr_t)0 },
    { "left", DontDelete|ReadOnly, (intptr_t)jsClientRectLeft, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsClientRectWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsClientRectHeight, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsClientRectConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSClientRectTableValues, 0 };
#else
    { 18, 15, JSClientRectTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSClientRectConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClientRectConstructorTableValues, 0 };
#else
    { 1, 0, JSClientRectConstructorTableValues, 0 };
#endif

class JSClientRectConstructor : public DOMConstructorObject {
public:
    JSClientRectConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSClientRectConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSClientRectPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSClientRectConstructor::s_info = { "ClientRectConstructor", 0, &JSClientRectConstructorTable, 0 };

bool JSClientRectConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRectConstructor, DOMObject>(exec, &JSClientRectConstructorTable, this, propertyName, slot);
}

bool JSClientRectConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRectConstructor, DOMObject>(exec, &JSClientRectConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSClientRectPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClientRectPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClientRectPrototypeTableValues, 0 };
#else
    { 1, 0, JSClientRectPrototypeTableValues, 0 };
#endif

const ClassInfo JSClientRectPrototype::s_info = { "ClientRectPrototype", 0, &JSClientRectPrototypeTable, 0 };

JSObject* JSClientRectPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRect>(exec, globalObject);
}

const ClassInfo JSClientRect::s_info = { "ClientRect", 0, &JSClientRectTable, 0 };

JSClientRect::JSClientRect(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ClientRect> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSClientRect::~JSClientRect()
{
    forgetDOMObject(this, impl());
}

JSObject* JSClientRect::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClientRectPrototype(JSClientRectPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSClientRect::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRect, Base>(exec, &JSClientRectTable, this, propertyName, slot);
}

bool JSClientRect::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRect, Base>(exec, &JSClientRectTable, this, propertyName, descriptor);
}

JSValue jsClientRectTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->top());
}

JSValue jsClientRectRight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->right());
}

JSValue jsClientRectBottom(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->bottom());
}

JSValue jsClientRectLeft(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->left());
}

JSValue jsClientRectWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->width());
}

JSValue jsClientRectHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* castedThis = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    ClientRect* imp = static_cast<ClientRect*>(castedThis->impl());
    return jsNumber(exec, imp->height());
}

JSValue jsClientRectConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClientRect* domObject = static_cast<JSClientRect*>(asObject(slot.slotBase()));
    return JSClientRect::getConstructor(exec, domObject->globalObject());
}
JSValue JSClientRect::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ClientRect* object)
{
    return getDOMObjectWrapper<JSClientRect>(exec, globalObject, object);
}
ClientRect* toClientRect(JSC::JSValue value)
{
    return value.inherits(&JSClientRect::s_info) ? static_cast<JSClientRect*>(asObject(value))->impl() : 0;
}

}
