.\" Copyright \(co Digital Equipment Corporation, 1996
.\" 
.\" Permission to use, copy, modify, distribute, and sell this
.\" documentation for any purpose is hereby granted without fee,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.  Digital Equipment Corporation
.\" makes no representations about the suitability for any purpose
.\" of the information in this document.  This documentation is
.\" provided ``as is'' without express or implied warranty.
.\"
.\" Copyright 1999, 2005 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" X Window System is a trademark of The Open Group.
.\" 
.TH DPMSSetTimeouts __libmansuffix__ __xorgversion__ "X FUNCTIONS"
.SH NAME
DPMSSetTimeouts \- permits applications to set the timeout values
used by the X server for DPMS timings
.SH SYNOPSIS
.PP
.nf
\fBcc\fR [ \fIflag\fR \&.\&.\&. ] \fIfile\fR \&.\&.\&. -\fBlXext\fR [ \fIlibrary\fR \&.\&.\&. ]
\&#include <X11/extensions/dpms.h>
.HP
.B Status DPMSSetTimeouts
(
.br
      Display *\fIdisplay\fP\^,
.br
      CARD16 \fIstandby\fP\^,
.br
      CARD16 \fIsuspend\fP\^,
.br
      CARD16 \fIoff\fP\^ 
);
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies the connection to the X server
.TP
.I standby
Specifies the new standby timeout in seconds
.TP
.I suspend
Specifies the new suspend timeout in seconds
.TP
.I off
Specifies the new off timeout in seconds
.SH DESCRIPTION
.LP
The DPMSSetTimeouts function permits applications to set the timeout values
used by the X server for Display Power Management Signaling (DPMS) timings. 
.LP
The value \fIstandby\fP is the amount of inactivity time, in seconds, before 
standby mode is invoked. The actual 
effects of this mode are dependent on the characteristics of the monitor and 
frame buffer card. Standby mode is 
implemented by shutting off the horizontal sync signal, and pulsing the vertical 
sync signal. Standby mode 
provides the quickest monitor recovery time.  Note also that many monitors 
implement this mode identical to 
suspend mode.  A value of zero disables the standby mode.
.LP
The value \fIsuspend\fP is the amount of time of inactivity, in seconds, before 
the second level of power 
savings is invoked. Suspend mode's physical and electrical characteristics are 
implementation defined. For DPMS 
compliant hardware, setting the suspend mode is implemented by pulsing the 
horizontal sync signal and 
shutting off the vertical sync signal.  In general, suspend mode recovery is 
considered to be slower than 
standby mode, but faster than off mode. However it may vary from monitor to 
monitor.  As noted above, many 
monitors implement this mode identical to the standby mode.  A value of zero 
disables this mode.
.LP
The value \fIoff\fP is the amount of time of inactivity,in seconds, before the 
third and final level of power 
savings is invoked. Off mode's physical and electrical characteristics are 
implementation defined. In DPMS 
compliant hardware, it is implemented by shutting off both horizontal and 
vertical sync signals, resulting in 
powering down of the monitor.  Recovery time is implementation dependent. 
Usually the recovery time is very 
close to the power-up time of the monitor. A value of zero disables this mode.
.LP
Chronologically, \fIstandby\fP mode occurs before or simultaneously with 
\fIsuspend\fP mode, and 
\fIsuspend\fP mode must occur before or simultaneously with \fIoff\fP mode. 
Therefore, non-zero mode timeout 
values must be greater than or equal to the timeout values of earlier modes.  If 
inconsistent values are 
supplied, a BadValue error will result.
.SH "RETURN VALUES"
.TP 15
TRUE
The 
.I DPMSSetTimeouts 
function returns TRUE when the function has succeeded. 
.SH ERRORS
.TP 15
.SM BadValue
An argument is out of range.
.SH "SEE ALSO"
.BR DPMSCapable (__libmansuffix__),
.BR DPMSInfo (__libmansuffix__),
.BR DPMSGetTimeouts (__libmansuffix__)
