/*
 * Copyright 2013 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef SkPDFResourceDict_DEFINED
#define SkPDFResourceDict_DEFINED

#include "SkRefCnt.h"
#include "SkTDArray.h"

class SkPDFDict;
class SkPDFObject;

/** \class SkPDFResourceDict

    A resource dictionary, which maintains the relevant sub-dicts and
    allows generation of a list of referenced SkPDFObjects inserted with
    insertResourceAsRef.
*/
class SkPDFResourceDict {
public:
    enum SkPDFResourceType {
        kExtGState_ResourceType,
        kPattern_ResourceType,
        kXObject_ResourceType,
        kFont_ResourceType,
        // These additional types are defined by the spec, but not
        // currently used by Skia: ColorSpace, Shading, Properties
        kResourceTypeCount
    };

    static char GetResourceTypePrefix(SkPDFResourceDict::SkPDFResourceType type);

    /** Create a PDF resource dictionary.
     *  The full set of ProcSet entries is automatically created for backwards
     *  compatibility, as recommended by the PDF spec.
     *
     *  Any arguments can be nullptr.
     */
    static sk_sp<SkPDFDict> Make(
        const SkTDArray<SkPDFObject*>* gStateResources,
        const SkTDArray<SkPDFObject*>* patternResources,
        const SkTDArray<SkPDFObject*>* xObjectResources,
        const SkTDArray<SkPDFObject*>* fontResources);

    /**
     * Returns the name for the resource that will be generated by the resource
     * dict.
     *
     *  @param type  The type of resource being entered, like
     *    kPattern_ResourceType or kExtGState_ResourceType.
     *  @param key   The resource key, should be unique within its type.
     */
    static SkString getResourceName(SkPDFResourceType type, int key);
};

#endif
