# Version: MPL 1.1 / GPLv3+ / LGPLv3+
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License or as specified alternatively below. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# Major Contributor(s):
# [ Copyright (C) 2012 Tim Retout <tim@retout.co.uk> (initial developer) ]
#
# All Rights Reserved.
#
# For minor contributions see the git repository.
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 3 or later (the "GPLv3+"), or
# the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
# in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
# instead of those above.

use strict;
use warnings;

use Test::More;

use lib '.';

BEGIN {
    use_ok('packager::work', qw(
           set_global_variable
           create_package_todos
           execute_system_calls
    ));
}

$packager::globals::compiler = 'gcc';
@packager::globals::logfileinfo = ();

my $packagelist = <<'END';
   # Comment
   some_product  gcc,gcc3.3  en_US,en_GB|fr_FR  some_target
   other_thing   x           y                  z
END

my @packagelist = split "\n", $packagelist;

my $targets = create_package_todos( \@packagelist );

is_deeply(\@packager::globals::logfileinfo,
          ["some_target_en_US_en_GB\n",
           "some_target_fr_FR\n"]);

is_deeply($targets,
          ["some_target_en_US_en_GB",
           "some_target_fr_FR"]);

done_testing();
