/* dict.c generated by valac 0.56.17, the Vala compiler
 * generated from dict.vala, do not modify */

/* enchant: Dict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gmodule.h>
#include <enchant.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef struct _ParamSpecEnchantDict ParamSpecEnchantDict;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
	gchar* language_tag;
	gchar* error;
	gboolean is_pwl;
	EnchantProvider* provider;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantDict {
	GParamSpec parent_instance;
};

static gpointer enchant_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN const gchar* enchant_dict_get_extra_word_characters (EnchantDict* self);
VALA_EXTERN gint enchant_dict_is_word_character (EnchantDict* _self_,
                                     guint32 uc_in,
                                     size_t n);
VALA_EXTERN void enchant_dict_set_error (EnchantDict* self,
                             const gchar* err);
VALA_EXTERN void enchant_session_clear_error (EnchantSession* self);
VALA_EXTERN const gchar* enchant_dict_get_error (EnchantDict* self);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
static gchar** enchant_dict_filter_suggestions (EnchantDict* self,
                                         gchar** suggs,
                                         gint suggs_length1,
                                         gint* result_length1);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
VALA_EXTERN void enchant_dict_add (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN gint enchant_dict_is_added (EnchantDict* self,
                            const gchar* word_buf,
                            ssize_t len);
VALA_EXTERN void enchant_dict_remove (EnchantDict* self,
                          const gchar* word_buf,
                          ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gint enchant_dict_is_removed (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len);
VALA_EXTERN void enchant_dict_store_replacement (EnchantDict* self,
                                     const gchar* mis,
                                     ssize_t mis_len,
                                     const gchar* cor,
                                     ssize_t cor_len);
VALA_EXTERN void enchant_dict_free_string_list (EnchantDict* self,
                                    gchar** string_list);
VALA_EXTERN void enchant_dict_describe (EnchantDict* self,
                            EnchantDictDescribeFn fn,
                            void* user_data);
VALA_EXTERN EnchantDict* enchant_dict_new (void);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type);
static void enchant_dict_finalize (EnchantDict * obj);
static GType enchant_dict_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar*
enchant_dict_get_extra_word_characters (EnchantDict* self)
{
	const gchar* _tmp0_ = NULL;
	DictGetExtraWordCharacters _tmp1_;
	const gchar* result;
#line 62 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "dict.vala"
	_tmp1_ = self->get_extra_word_characters_method;
#line 63 "dict.vala"
	if (_tmp1_ != NULL) {
#line 338 "dict.c"
		DictGetExtraWordCharacters _tmp2_;
		const gchar* _tmp3_;
#line 64 "dict.vala"
		_tmp2_ = self->get_extra_word_characters_method;
#line 64 "dict.vala"
		_tmp3_ = _tmp2_ (self);
#line 64 "dict.vala"
		_tmp0_ = _tmp3_;
#line 347 "dict.c"
	} else {
#line 64 "dict.vala"
		_tmp0_ = "";
#line 351 "dict.c"
	}
#line 63 "dict.vala"
	result = _tmp0_;
#line 63 "dict.vala"
	return result;
#line 357 "dict.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 371 "dict.c"
}

gint
enchant_dict_is_word_character (EnchantDict* _self_,
                                guint32 uc_in,
                                size_t n)
{
	gboolean _tmp0_ = FALSE;
	gunichar uc = 0U;
	gboolean _tmp3_ = FALSE;
	GUnicodeType type = 0;
	gint result;
#line 67 "dict.vala"
	_vala_return_val_if_fail (n <= ((size_t) 2), "n <= 2", 0);
#line 70 "dict.vala"
	if (_self_ != NULL) {
#line 388 "dict.c"
		DictIsWordCharacter _tmp1_;
#line 70 "dict.vala"
		_tmp1_ = _self_->is_word_character_method;
#line 70 "dict.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 394 "dict.c"
	} else {
#line 70 "dict.vala"
		_tmp0_ = FALSE;
#line 398 "dict.c"
	}
#line 70 "dict.vala"
	if (_tmp0_) {
#line 402 "dict.c"
		DictIsWordCharacter _tmp2_;
#line 71 "dict.vala"
		_tmp2_ = _self_->is_word_character_method;
#line 71 "dict.vala"
		result = _tmp2_ (_self_, uc_in, n);
#line 71 "dict.vala"
		return result;
#line 410 "dict.c"
	}
#line 73 "dict.vala"
	uc = (gunichar) uc_in;
#line 76 "dict.vala"
	if (uc == string_get_char ("'", (glong) 0)) {
#line 76 "dict.vala"
		_tmp3_ = TRUE;
#line 418 "dict.c"
	} else {
#line 76 "dict.vala"
		_tmp3_ = uc == string_get_char ("’", (glong) 0);
#line 422 "dict.c"
	}
#line 76 "dict.vala"
	if (_tmp3_) {
#line 426 "dict.c"
		gint _tmp4_ = 0;
#line 77 "dict.vala"
		if (n < ((size_t) 2)) {
#line 77 "dict.vala"
			_tmp4_ = 1;
#line 432 "dict.c"
		} else {
#line 77 "dict.vala"
			_tmp4_ = 0;
#line 436 "dict.c"
		}
#line 77 "dict.vala"
		result = _tmp4_;
#line 77 "dict.vala"
		return result;
#line 442 "dict.c"
	}
#line 79 "dict.vala"
	type = g_unichar_type (uc);
#line 81 "dict.vala"
	switch (type) {
#line 81 "dict.vala"
		case G_UNICODE_MODIFIER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_LOWERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_TITLECASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_UPPERCASE_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_LETTER:
#line 81 "dict.vala"
		case G_UNICODE_COMBINING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 81 "dict.vala"
		case G_UNICODE_DECIMAL_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_LETTER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_OTHER_NUMBER:
#line 81 "dict.vala"
		case G_UNICODE_CONNECT_PUNCTUATION:
#line 472 "dict.c"
		{
#line 94 "dict.vala"
			result = 1;
#line 94 "dict.vala"
			return result;
#line 478 "dict.c"
		}
#line 81 "dict.vala"
		case G_UNICODE_DASH_PUNCTUATION:
#line 482 "dict.c"
		{
			gboolean _tmp5_ = FALSE;
#line 97 "dict.vala"
			if (n == ((size_t) 1)) {
#line 97 "dict.vala"
				_tmp5_ = type == G_UNICODE_DASH_PUNCTUATION;
#line 489 "dict.c"
			} else {
#line 97 "dict.vala"
				_tmp5_ = FALSE;
#line 493 "dict.c"
			}
#line 97 "dict.vala"
			if (_tmp5_) {
#line 98 "dict.vala"
				result = 1;
#line 98 "dict.vala"
				return result;
#line 501 "dict.c"
			}
#line 99 "dict.vala"
			result = 0;
#line 99 "dict.vala"
			return result;
#line 507 "dict.c"
		}
		default:
		{
#line 102 "dict.vala"
			result = 0;
#line 102 "dict.vala"
			return result;
#line 515 "dict.c"
		}
	}
}

void
enchant_dict_set_error (EnchantDict* self,
                        const gchar* err)
{
	EnchantSession* _tmp0_;
	EnchantSession* _tmp1_;
	gchar* _tmp2_;
#line 106 "dict.vala"
	g_return_if_fail (self != NULL);
#line 106 "dict.vala"
	g_return_if_fail (err != NULL);
#line 107 "dict.vala"
	_tmp0_ = self->session;
#line 107 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 108 "dict.vala"
	g_debug ("dict.vala:108: enchant_dict_set_error: %s", err);
#line 109 "dict.vala"
	_tmp1_ = self->session;
#line 109 "dict.vala"
	_tmp2_ = g_strdup (err);
#line 109 "dict.vala"
	_g_free0 (_tmp1_->error);
#line 109 "dict.vala"
	_tmp1_->error = _tmp2_;
#line 545 "dict.c"
}

const gchar*
enchant_dict_get_error (EnchantDict* self)
{
	EnchantSession* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
#line 112 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "dict.vala"
	_tmp0_ = self->session;
#line 113 "dict.vala"
	_tmp1_ = _tmp0_->error;
#line 113 "dict.vala"
	result = _tmp1_;
#line 113 "dict.vala"
	return result;
#line 564 "dict.c"
}

gint
enchant_dict_check (EnchantDict* _self_,
                    const gchar* word_buf,
                    ssize_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantSession* _tmp3_;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	EnchantSession* _tmp6_;
	const gchar* _tmp7_;
	DictCheck _tmp8_;
	gint result;
#line 120 "dict.vala"
	if (_self_ == NULL) {
#line 120 "dict.vala"
		_tmp0_ = TRUE;
#line 587 "dict.c"
	} else {
#line 120 "dict.vala"
		_tmp0_ = word_buf == NULL;
#line 591 "dict.c"
	}
#line 120 "dict.vala"
	if (_tmp0_) {
#line 121 "dict.vala"
		result = -1;
#line 121 "dict.vala"
		return result;
#line 599 "dict.c"
	}
#line 122 "dict.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 122 "dict.vala"
	word = _tmp1_;
#line 123 "dict.vala"
	_tmp2_ = word;
#line 123 "dict.vala"
	if (_tmp2_ == NULL) {
#line 124 "dict.vala"
		result = -1;
#line 124 "dict.vala"
		_g_free0 (word);
#line 124 "dict.vala"
		return result;
#line 615 "dict.c"
	}
#line 126 "dict.vala"
	_tmp3_ = _self_->session;
#line 126 "dict.vala"
	enchant_session_clear_error (_tmp3_);
#line 129 "dict.vala"
	_tmp4_ = _self_->session;
#line 129 "dict.vala"
	_tmp5_ = word;
#line 129 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 130 "dict.vala"
		result = 1;
#line 130 "dict.vala"
		_g_free0 (word);
#line 130 "dict.vala"
		return result;
#line 633 "dict.c"
	}
#line 133 "dict.vala"
	_tmp6_ = _self_->session;
#line 133 "dict.vala"
	_tmp7_ = word;
#line 133 "dict.vala"
	if (enchant_session_contains (_tmp6_, _tmp7_)) {
#line 134 "dict.vala"
		result = 0;
#line 134 "dict.vala"
		_g_free0 (word);
#line 134 "dict.vala"
		return result;
#line 647 "dict.c"
	}
#line 136 "dict.vala"
	_tmp8_ = _self_->check_method;
#line 136 "dict.vala"
	if (_tmp8_ != NULL) {
#line 653 "dict.c"
		DictCheck _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 137 "dict.vala"
		_tmp9_ = _self_->check_method;
#line 137 "dict.vala"
		_tmp10_ = word;
#line 137 "dict.vala"
		_tmp11_ = word;
#line 137 "dict.vala"
		_tmp12_ = strlen (_tmp11_);
#line 137 "dict.vala"
		_tmp13_ = _tmp12_;
#line 137 "dict.vala"
		result = _tmp9_ (_self_, _tmp10_, (size_t) _tmp13_);
#line 137 "dict.vala"
		_g_free0 (word);
#line 137 "dict.vala"
		return result;
#line 675 "dict.c"
	} else {
		EnchantSession* _tmp14_;
#line 138 "dict.vala"
		_tmp14_ = _self_->session;
#line 138 "dict.vala"
		if (_tmp14_->is_pwl) {
#line 139 "dict.vala"
			result = 1;
#line 139 "dict.vala"
			_g_free0 (word);
#line 139 "dict.vala"
			return result;
#line 688 "dict.c"
		}
	}
#line 141 "dict.vala"
	result = -1;
#line 141 "dict.vala"
	_g_free0 (word);
#line 141 "dict.vala"
	return result;
#line 697 "dict.c"
}

static gchar**
enchant_dict_filter_suggestions (EnchantDict* self,
                                 gchar** suggs,
                                 gint suggs_length1,
                                 gint* result_length1)
{
	GStrvBuilder* sb = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
#line 146 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 147 "dict.vala"
	_tmp0_ = g_strv_builder_new ();
#line 147 "dict.vala"
	sb = _tmp0_;
#line 720 "dict.c"
	{
		gchar** sugg_collection = NULL;
		gint sugg_collection_length1 = 0;
		gint _sugg_collection_size_ = 0;
		gint sugg_it = 0;
#line 148 "dict.vala"
		sugg_collection = suggs;
#line 148 "dict.vala"
		sugg_collection_length1 = suggs_length1;
#line 148 "dict.vala"
		for (sugg_it = 0; sugg_it < sugg_collection_length1; sugg_it = sugg_it + 1) {
#line 732 "dict.c"
			gchar* _tmp1_;
			gchar* sugg = NULL;
#line 148 "dict.vala"
			_tmp1_ = g_strdup (sugg_collection[sugg_it]);
#line 148 "dict.vala"
			sugg = _tmp1_;
#line 739 "dict.c"
			{
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp3_;
#line 149 "dict.vala"
				_tmp3_ = sugg;
#line 149 "dict.vala"
				if (g_utf8_validate (_tmp3_, (gssize) -1, NULL)) {
#line 747 "dict.c"
					EnchantSession* _tmp4_;
					const gchar* _tmp5_;
#line 149 "dict.vala"
					_tmp4_ = self->session;
#line 149 "dict.vala"
					_tmp5_ = sugg;
#line 149 "dict.vala"
					_tmp2_ = !enchant_session_exclude (_tmp4_, _tmp5_);
#line 756 "dict.c"
				} else {
#line 149 "dict.vala"
					_tmp2_ = FALSE;
#line 760 "dict.c"
				}
#line 149 "dict.vala"
				if (_tmp2_) {
#line 764 "dict.c"
					GStrvBuilder* _tmp6_;
					const gchar* _tmp7_;
#line 150 "dict.vala"
					_tmp6_ = sb;
#line 150 "dict.vala"
					_tmp7_ = sugg;
#line 150 "dict.vala"
					g_strv_builder_add (_tmp6_, _tmp7_);
#line 773 "dict.c"
				}
#line 148 "dict.vala"
				_g_free0 (sugg);
#line 777 "dict.c"
			}
		}
	}
#line 152 "dict.vala"
	_tmp8_ = sb;
#line 152 "dict.vala"
	_tmp10_ = _tmp9_ = g_strv_builder_end (_tmp8_);
#line 152 "dict.vala"
	_tmp11_ = _tmp10_;
#line 152 "dict.vala"
	_tmp11__length1 = _vala_array_length (_tmp9_);
#line 152 "dict.vala"
	if (result_length1) {
#line 152 "dict.vala"
		*result_length1 = _tmp11__length1;
#line 793 "dict.c"
	}
#line 152 "dict.vala"
	result = _tmp11_;
#line 152 "dict.vala"
	_g_strv_builder_unref0 (sb);
#line 152 "dict.vala"
	return result;
#line 801 "dict.c"
}

gchar**
enchant_dict_suggest (EnchantDict* self,
                      const gchar* word_buf,
                      ssize_t len,
                      size_t* result_length1)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp3_;
	gchar** dict_suggs = NULL;
	gint dict_suggs_length1;
	gint _dict_suggs_size_;
	DictSuggest _tmp4_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
#line 156 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, NULL);
#line 157 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 157 "dict.vala"
	word = _tmp0_;
#line 158 "dict.vala"
	_tmp1_ = word;
#line 158 "dict.vala"
	if (_tmp1_ == NULL) {
#line 833 "dict.c"
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 159 "dict.vala"
		_tmp2_ = NULL;
#line 159 "dict.vala"
		_tmp2__length1 = 0;
#line 159 "dict.vala"
		if (result_length1) {
#line 159 "dict.vala"
			*result_length1 = _tmp2__length1;
#line 844 "dict.c"
		}
#line 159 "dict.vala"
		result = _tmp2_;
#line 159 "dict.vala"
		_g_free0 (word);
#line 159 "dict.vala"
		return result;
#line 852 "dict.c"
	}
#line 161 "dict.vala"
	_tmp3_ = self->session;
#line 161 "dict.vala"
	enchant_session_clear_error (_tmp3_);
#line 164 "dict.vala"
	dict_suggs = NULL;
#line 164 "dict.vala"
	dict_suggs_length1 = 0;
#line 164 "dict.vala"
	_dict_suggs_size_ = dict_suggs_length1;
#line 165 "dict.vala"
	_tmp4_ = self->suggest_method;
#line 165 "dict.vala"
	if (_tmp4_ != NULL) {
#line 868 "dict.c"
		DictSuggest _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		size_t _tmp10_ = 0;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
#line 166 "dict.vala"
		_tmp5_ = self->suggest_method;
#line 166 "dict.vala"
		_tmp6_ = word;
#line 166 "dict.vala"
		_tmp7_ = word;
#line 166 "dict.vala"
		_tmp8_ = strlen (_tmp7_);
#line 166 "dict.vala"
		_tmp9_ = _tmp8_;
#line 166 "dict.vala"
		_tmp11_ = _tmp5_ (self, _tmp6_, (size_t) _tmp9_, &_tmp10_);
#line 166 "dict.vala"
		dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 166 "dict.vala"
		dict_suggs = _tmp11_;
#line 166 "dict.vala"
		dict_suggs_length1 = _tmp10_;
#line 166 "dict.vala"
		_dict_suggs_size_ = dict_suggs_length1;
#line 167 "dict.vala"
		_tmp12_ = dict_suggs;
#line 167 "dict.vala"
		_tmp12__length1 = dict_suggs_length1;
#line 167 "dict.vala"
		if (_tmp12_ != NULL) {
#line 904 "dict.c"
			gchar** _tmp13_;
			gint _tmp13__length1;
			gint _tmp14_ = 0;
			gchar** _tmp15_;
#line 168 "dict.vala"
			_tmp13_ = dict_suggs;
#line 168 "dict.vala"
			_tmp13__length1 = dict_suggs_length1;
#line 168 "dict.vala"
			_tmp15_ = enchant_dict_filter_suggestions (self, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
#line 168 "dict.vala"
			dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 168 "dict.vala"
			dict_suggs = _tmp15_;
#line 168 "dict.vala"
			dict_suggs_length1 = _tmp14_;
#line 168 "dict.vala"
			_dict_suggs_size_ = dict_suggs_length1;
#line 923 "dict.c"
		}
	}
#line 171 "dict.vala"
	_tmp16_ = dict_suggs;
#line 171 "dict.vala"
	_tmp16__length1 = dict_suggs_length1;
#line 171 "dict.vala"
	if (result_length1) {
#line 171 "dict.vala"
		*result_length1 = _tmp16__length1;
#line 934 "dict.c"
	}
#line 171 "dict.vala"
	result = _tmp16_;
#line 171 "dict.vala"
	_g_free0 (word);
#line 171 "dict.vala"
	return result;
#line 942 "dict.c"
}

void
enchant_dict_add (EnchantDict* self,
                  const gchar* word_buf,
                  ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 174 "dict.vala"
	g_return_if_fail (self != NULL);
#line 174 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 175 "dict.vala"
	enchant_dict_add_to_session (self, word_buf, len);
#line 176 "dict.vala"
	_tmp0_ = self->session;
#line 176 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 176 "dict.vala"
	enchant_pwl_add (_tmp1_, word_buf, len);
#line 177 "dict.vala"
	_tmp2_ = self->session;
#line 177 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 177 "dict.vala"
	enchant_pwl_remove (_tmp3_, word_buf, len);
#line 972 "dict.c"
}

void
enchant_dict_add_to_session (EnchantDict* self,
                             const gchar* word_buf,
                             ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictAddToSession _tmp5_;
#line 180 "dict.vala"
	g_return_if_fail (self != NULL);
#line 180 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 181 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 181 "dict.vala"
	word = _tmp0_;
#line 182 "dict.vala"
	_tmp1_ = word;
#line 182 "dict.vala"
	if (_tmp1_ == NULL) {
#line 183 "dict.vala"
		_g_free0 (word);
#line 183 "dict.vala"
		return;
#line 1003 "dict.c"
	}
#line 184 "dict.vala"
	_tmp2_ = self->session;
#line 184 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 185 "dict.vala"
	_tmp3_ = self->session;
#line 185 "dict.vala"
	_tmp4_ = word;
#line 185 "dict.vala"
	enchant_session_add (_tmp3_, _tmp4_);
#line 186 "dict.vala"
	_tmp5_ = self->add_to_session_method;
#line 186 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1019 "dict.c"
		DictAddToSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 187 "dict.vala"
		_tmp6_ = self->add_to_session_method;
#line 187 "dict.vala"
		_tmp7_ = word;
#line 187 "dict.vala"
		_tmp8_ = word;
#line 187 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 187 "dict.vala"
		_tmp10_ = _tmp9_;
#line 187 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1037 "dict.c"
	}
#line 180 "dict.vala"
	_g_free0 (word);
#line 1041 "dict.c"
}

gint
enchant_dict_is_added (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 190 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 190 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 191 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 191 "dict.vala"
	word = _tmp0_;
#line 192 "dict.vala"
	_tmp1_ = word;
#line 192 "dict.vala"
	if (_tmp1_ == NULL) {
#line 193 "dict.vala"
		result = 0;
#line 193 "dict.vala"
		_g_free0 (word);
#line 193 "dict.vala"
		return result;
#line 1075 "dict.c"
	}
#line 194 "dict.vala"
	_tmp2_ = self->session;
#line 194 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 195 "dict.vala"
	_tmp4_ = self->session;
#line 195 "dict.vala"
	_tmp5_ = word;
#line 195 "dict.vala"
	if (enchant_session_contains (_tmp4_, _tmp5_)) {
#line 195 "dict.vala"
		_tmp3_ = 1;
#line 1089 "dict.c"
	} else {
#line 195 "dict.vala"
		_tmp3_ = 0;
#line 1093 "dict.c"
	}
#line 195 "dict.vala"
	result = _tmp3_;
#line 195 "dict.vala"
	_g_free0 (word);
#line 195 "dict.vala"
	return result;
#line 1101 "dict.c"
}

void
enchant_dict_remove (EnchantDict* self,
                     const gchar* word_buf,
                     ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 198 "dict.vala"
	g_return_if_fail (self != NULL);
#line 198 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 199 "dict.vala"
	enchant_dict_remove_from_session (self, word_buf, len);
#line 200 "dict.vala"
	_tmp0_ = self->session;
#line 200 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 200 "dict.vala"
	enchant_pwl_remove (_tmp1_, word_buf, len);
#line 201 "dict.vala"
	_tmp2_ = self->session;
#line 201 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 201 "dict.vala"
	enchant_pwl_add (_tmp3_, word_buf, len);
#line 1131 "dict.c"
}

void
enchant_dict_remove_from_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	DictRemoveFromSession _tmp5_;
#line 204 "dict.vala"
	g_return_if_fail (self != NULL);
#line 204 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 205 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 205 "dict.vala"
	word = _tmp0_;
#line 206 "dict.vala"
	_tmp1_ = word;
#line 206 "dict.vala"
	if (_tmp1_ == NULL) {
#line 207 "dict.vala"
		_g_free0 (word);
#line 207 "dict.vala"
		return;
#line 1162 "dict.c"
	}
#line 208 "dict.vala"
	_tmp2_ = self->session;
#line 208 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 209 "dict.vala"
	_tmp3_ = self->session;
#line 209 "dict.vala"
	_tmp4_ = word;
#line 209 "dict.vala"
	enchant_session_remove (_tmp3_, _tmp4_);
#line 210 "dict.vala"
	_tmp5_ = self->remove_from_session_method;
#line 210 "dict.vala"
	if (_tmp5_ != NULL) {
#line 1178 "dict.c"
		DictRemoveFromSession _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 211 "dict.vala"
		_tmp6_ = self->remove_from_session_method;
#line 211 "dict.vala"
		_tmp7_ = word;
#line 211 "dict.vala"
		_tmp8_ = word;
#line 211 "dict.vala"
		_tmp9_ = strlen (_tmp8_);
#line 211 "dict.vala"
		_tmp10_ = _tmp9_;
#line 211 "dict.vala"
		_tmp6_ (self, _tmp7_, (size_t) _tmp10_);
#line 1196 "dict.c"
	}
#line 204 "dict.vala"
	_g_free0 (word);
#line 1200 "dict.c"
}

gint
enchant_dict_is_removed (EnchantDict* self,
                         const gchar* word_buf,
                         ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	gint _tmp3_ = 0;
	EnchantSession* _tmp4_;
	const gchar* _tmp5_;
	gint result;
#line 214 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 214 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 215 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 215 "dict.vala"
	word = _tmp0_;
#line 216 "dict.vala"
	_tmp1_ = word;
#line 216 "dict.vala"
	if (_tmp1_ == NULL) {
#line 217 "dict.vala"
		result = 0;
#line 217 "dict.vala"
		_g_free0 (word);
#line 217 "dict.vala"
		return result;
#line 1234 "dict.c"
	}
#line 218 "dict.vala"
	_tmp2_ = self->session;
#line 218 "dict.vala"
	enchant_session_clear_error (_tmp2_);
#line 219 "dict.vala"
	_tmp4_ = self->session;
#line 219 "dict.vala"
	_tmp5_ = word;
#line 219 "dict.vala"
	if (enchant_session_exclude (_tmp4_, _tmp5_)) {
#line 219 "dict.vala"
		_tmp3_ = 1;
#line 1248 "dict.c"
	} else {
#line 219 "dict.vala"
		_tmp3_ = 0;
#line 1252 "dict.c"
	}
#line 219 "dict.vala"
	result = _tmp3_;
#line 219 "dict.vala"
	_g_free0 (word);
#line 219 "dict.vala"
	return result;
#line 1260 "dict.c"
}

void
enchant_dict_store_replacement (EnchantDict* self,
                                const gchar* mis,
                                ssize_t mis_len,
                                const gchar* cor,
                                ssize_t cor_len)
{
#line 223 "dict.vala"
	g_return_if_fail (self != NULL);
#line 223 "dict.vala"
	g_return_if_fail (mis != NULL);
#line 223 "dict.vala"
	g_return_if_fail (cor != NULL);
#line 1276 "dict.c"
}

void
enchant_dict_free_string_list (EnchantDict* self,
                               gchar** string_list)
{
	EnchantSession* _tmp0_;
	gchar** _tmp1_;
#line 226 "dict.vala"
	g_return_if_fail (self != NULL);
#line 227 "dict.vala"
	_tmp0_ = self->session;
#line 227 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 228 "dict.vala"
	_tmp1_ = string_list;
#line 228 "dict.vala"
	string_list = NULL;
#line 228 "dict.vala"
	g_strfreev ((gchar**) _tmp1_);
#line 1297 "dict.c"
}

void
enchant_dict_describe (EnchantDict* self,
                       EnchantDictDescribeFn fn,
                       void* user_data)
{
	EnchantSession* _tmp0_;
	EnchantProvider* provider = NULL;
	EnchantSession* _tmp1_;
	EnchantProvider* _tmp2_;
	gchar* name = NULL;
	gchar* desc = NULL;
	gchar* file = NULL;
	EnchantProvider* _tmp3_;
	gchar* tag = NULL;
	EnchantSession* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
#line 231 "dict.vala"
	g_return_if_fail (self != NULL);
#line 231 "dict.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 234 "dict.vala"
	_tmp0_ = self->session;
#line 234 "dict.vala"
	enchant_session_clear_error (_tmp0_);
#line 235 "dict.vala"
	_tmp1_ = self->session;
#line 235 "dict.vala"
	_tmp2_ = _tmp1_->provider;
#line 235 "dict.vala"
	provider = _tmp2_;
#line 240 "dict.vala"
	_tmp3_ = provider;
#line 240 "dict.vala"
	if (_tmp3_ != NULL) {
#line 1338 "dict.c"
		EnchantProvider* _tmp4_;
		GModule* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		EnchantProvider* _tmp8_;
		ProviderIdentify _tmp9_;
		EnchantProvider* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		EnchantProvider* _tmp13_;
		ProviderDescribe _tmp14_;
		EnchantProvider* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
#line 241 "dict.vala"
		_tmp4_ = provider;
#line 241 "dict.vala"
		_tmp5_ = _tmp4_->module;
#line 241 "dict.vala"
		_tmp6_ = g_module_name (_tmp5_);
#line 241 "dict.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 241 "dict.vala"
		_g_free0 (file);
#line 241 "dict.vala"
		file = _tmp7_;
#line 242 "dict.vala"
		_tmp8_ = provider;
#line 242 "dict.vala"
		_tmp9_ = _tmp8_->identify;
#line 242 "dict.vala"
		_tmp10_ = provider;
#line 242 "dict.vala"
		_tmp11_ = _tmp9_ (_tmp10_);
#line 242 "dict.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 242 "dict.vala"
		_g_free0 (name);
#line 242 "dict.vala"
		name = _tmp12_;
#line 243 "dict.vala"
		_tmp13_ = provider;
#line 243 "dict.vala"
		_tmp14_ = _tmp13_->describe;
#line 243 "dict.vala"
		_tmp15_ = provider;
#line 243 "dict.vala"
		_tmp16_ = _tmp14_ (_tmp15_);
#line 243 "dict.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 243 "dict.vala"
		_g_free0 (desc);
#line 243 "dict.vala"
		desc = _tmp17_;
#line 1393 "dict.c"
	} else {
		EnchantSession* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 245 "dict.vala"
		_tmp18_ = self->session;
#line 245 "dict.vala"
		_tmp19_ = _tmp18_->personal_filename;
#line 245 "dict.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 245 "dict.vala"
		_g_free0 (file);
#line 245 "dict.vala"
		file = _tmp20_;
#line 246 "dict.vala"
		_tmp21_ = g_strdup ("Personal Wordlist");
#line 246 "dict.vala"
		_g_free0 (name);
#line 246 "dict.vala"
		name = _tmp21_;
#line 247 "dict.vala"
		_tmp22_ = g_strdup ("Personal Wordlist");
#line 247 "dict.vala"
		_g_free0 (desc);
#line 247 "dict.vala"
		desc = _tmp22_;
#line 1422 "dict.c"
	}
#line 250 "dict.vala"
	_tmp23_ = self->session;
#line 250 "dict.vala"
	_tmp24_ = _tmp23_->language_tag;
#line 250 "dict.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 250 "dict.vala"
	tag = _tmp25_;
#line 251 "dict.vala"
	_tmp26_ = name;
#line 251 "dict.vala"
	_tmp27_ = desc;
#line 251 "dict.vala"
	_tmp28_ = file;
#line 251 "dict.vala"
	fn (tag, _tmp26_, _tmp27_, _tmp28_, user_data);
#line 231 "dict.vala"
	_g_free0 (tag);
#line 231 "dict.vala"
	_g_free0 (file);
#line 231 "dict.vala"
	_g_free0 (desc);
#line 231 "dict.vala"
	_g_free0 (name);
#line 1448 "dict.c"
}

EnchantDict*
enchant_dict_construct (GType object_type)
{
	EnchantDict* self = NULL;
#line 44 "dict.vala"
	self = (EnchantDict*) g_type_create_instance (object_type);
#line 44 "dict.vala"
	return self;
#line 1459 "dict.c"
}

EnchantDict*
enchant_dict_new (void)
{
#line 44 "dict.vala"
	return enchant_dict_construct (TYPE_ENCHANT_DICT);
#line 1467 "dict.c"
}

static void
value_enchant_dict_init (GValue* value)
{
#line 44 "dict.vala"
	value->data[0].v_pointer = NULL;
#line 1475 "dict.c"
}

static void
value_enchant_dict_free_value (GValue* value)
{
#line 44 "dict.vala"
	if (value->data[0].v_pointer) {
#line 44 "dict.vala"
		enchant_dict_unref (value->data[0].v_pointer);
#line 1485 "dict.c"
	}
}

static void
value_enchant_dict_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 44 "dict.vala"
	if (src_value->data[0].v_pointer) {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = enchant_dict_ref (src_value->data[0].v_pointer);
#line 1497 "dict.c"
	} else {
#line 44 "dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1501 "dict.c"
	}
}

static gpointer
value_enchant_dict_peek_pointer (const GValue* value)
{
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1510 "dict.c"
}

static gchar*
value_enchant_dict_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 44 "dict.vala"
	if (collect_values[0].v_pointer) {
#line 1521 "dict.c"
		EnchantDict * object;
		object = collect_values[0].v_pointer;
#line 44 "dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 44 "dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1528 "dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 44 "dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1532 "dict.c"
		}
#line 44 "dict.vala"
		value->data[0].v_pointer = enchant_dict_ref (object);
#line 1536 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1540 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1544 "dict.c"
}

static gchar*
value_enchant_dict_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	EnchantDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 44 "dict.vala"
	if (!object_p) {
#line 44 "dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1559 "dict.c"
	}
#line 44 "dict.vala"
	if (!value->data[0].v_pointer) {
#line 44 "dict.vala"
		*object_p = NULL;
#line 1565 "dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 44 "dict.vala"
		*object_p = value->data[0].v_pointer;
#line 1569 "dict.c"
	} else {
#line 44 "dict.vala"
		*object_p = enchant_dict_ref (value->data[0].v_pointer);
#line 1573 "dict.c"
	}
#line 44 "dict.vala"
	return NULL;
#line 1577 "dict.c"
}

GParamSpec*
param_spec_enchant_dict (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecEnchantDict* spec;
#line 44 "dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 44 "dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 44 "dict.vala"
	return G_PARAM_SPEC (spec);
#line 1596 "dict.c"
}

gpointer
value_get_enchant_dict (const GValue* value)
{
#line 44 "dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT), NULL);
#line 44 "dict.vala"
	return value->data[0].v_pointer;
#line 1606 "dict.c"
}

void
value_set_enchant_dict (GValue* value,
                        gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 44 "dict.vala"
		enchant_dict_ref (value->data[0].v_pointer);
#line 1628 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1632 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1638 "dict.c"
	}
}

void
value_take_enchant_dict (GValue* value,
                         gpointer v_object)
{
	EnchantDict * old;
#line 44 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
	old = value->data[0].v_pointer;
#line 44 "dict.vala"
	if (v_object) {
#line 44 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 44 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 44 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 1659 "dict.c"
	} else {
#line 44 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1663 "dict.c"
	}
#line 44 "dict.vala"
	if (old) {
#line 44 "dict.vala"
		enchant_dict_unref (old);
#line 1669 "dict.c"
	}
}

static void
enchant_dict_class_init (EnchantDictClass * klass,
                         gpointer klass_data)
{
#line 44 "dict.vala"
	enchant_dict_parent_class = g_type_class_peek_parent (klass);
#line 44 "dict.vala"
	((EnchantDictClass *) klass)->finalize = enchant_dict_finalize;
#line 1681 "dict.c"
}

static void
enchant_dict_instance_init (EnchantDict * self,
                            gpointer klass)
{
#line 44 "dict.vala"
	self->ref_count = 1;
#line 1690 "dict.c"
}

static void
enchant_dict_finalize (EnchantDict * obj)
{
	EnchantDict * self;
	EnchantProvider* owner = NULL;
	EnchantSession* _tmp0_;
	EnchantProvider* _tmp1_;
	EnchantProvider* _tmp2_;
#line 44 "dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_DICT, EnchantDict);
#line 44 "dict.vala"
	g_signal_handlers_destroy (self);
#line 57 "dict.vala"
	_tmp0_ = self->session;
#line 57 "dict.vala"
	_tmp1_ = _tmp0_->provider;
#line 57 "dict.vala"
	owner = _tmp1_;
#line 58 "dict.vala"
	_tmp2_ = owner;
#line 58 "dict.vala"
	if (_tmp2_ != NULL) {
#line 1715 "dict.c"
		EnchantProvider* _tmp3_;
		ProviderDisposeDict _tmp4_;
		EnchantProvider* _tmp5_;
#line 59 "dict.vala"
		_tmp3_ = owner;
#line 59 "dict.vala"
		_tmp4_ = _tmp3_->dispose_dict;
#line 59 "dict.vala"
		_tmp5_ = owner;
#line 59 "dict.vala"
		_tmp4_ (_tmp5_, self);
#line 1727 "dict.c"
	}
#line 46 "dict.vala"
	_enchant_session_unref0 (self->session);
#line 1731 "dict.c"
}

static GType
enchant_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_dict_init, value_enchant_dict_free_value, value_enchant_dict_copy_value, value_enchant_dict_peek_pointer, "p", value_enchant_dict_collect_value, "p", value_enchant_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantDict), 0, (GInstanceInitFunc) enchant_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_dict_type_id;
	enchant_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_dict_type_id;
}

GType
enchant_dict_get_type (void)
{
	static volatile gsize enchant_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_dict_type_id__once)) {
		GType enchant_dict_type_id;
		enchant_dict_type_id = enchant_dict_get_type_once ();
		g_once_init_leave (&enchant_dict_type_id__once, enchant_dict_type_id);
	}
	return enchant_dict_type_id__once;
}

gpointer
enchant_dict_ref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 44 "dict.vala"
	return instance;
#line 1766 "dict.c"
}

void
enchant_dict_unref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 44 "dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 44 "dict.vala"
		ENCHANT_DICT_GET_CLASS (self)->finalize (self);
#line 44 "dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1780 "dict.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

